/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

import net.psammead.util.Scan;

public final class XMLCodec {
    private XMLCodec() {
    }

    public static String encodeBody(String s) {
        StringBuilder out = new StringBuilder();
        int len = s.length();
        block5: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '&': {
                    out.append("&amp;");
                    continue block5;
                }
                case '<': {
                    out.append("&lt;");
                    continue block5;
                }
                case '>': {
                    out.append("&gt;");
                    continue block5;
                }
                default: {
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    public static String decodeBody(String s) throws IllegalArgumentException {
        Scan tok = new Scan(s);
        StringBuilder out = new StringBuilder();
        while (!tok.isFinished()) {
            out.append(tok.scan("&"));
            if (tok.isFinished()) break;
            if (tok.is("&amp;")) {
                out.append('&');
                continue;
            }
            if (tok.is("&lt;")) {
                out.append('<');
                continue;
            }
            if (tok.is("&gt;")) {
                out.append('>');
                continue;
            }
            if (!tok.is("&")) continue;
            out.append('&');
        }
        return out.toString();
    }

    public static String encodeAttribute(String s) {
        StringBuilder out = new StringBuilder();
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '&': {
                    out.append("&amp;");
                    continue block6;
                }
                case '<': {
                    out.append("&lt;");
                    continue block6;
                }
                case '>': {
                    out.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    out.append("&quot;");
                    continue block6;
                }
                default: {
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    public static String decodeAttribute(String s) throws IllegalArgumentException {
        Scan tok = new Scan(s);
        StringBuilder out = new StringBuilder();
        while (!tok.isFinished()) {
            out.append(tok.scan("&"));
            if (tok.isFinished()) break;
            if (tok.is("&quot;")) {
                out.append('\"');
                continue;
            }
            if (tok.is("&amp;")) {
                out.append('&');
                continue;
            }
            if (tok.is("&lt;")) {
                out.append('<');
                continue;
            }
            if (tok.is("&gt;")) {
                out.append('>');
                continue;
            }
            if (!tok.is("&")) continue;
            out.append('&');
        }
        return out.toString();
    }
}

