/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.psammead.util.DebugUtil;
import net.psammead.util.JavaLiteral;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToString {
    public static final String NULL_LITERAL = "<null>";
    private Object object;
    private List<Part> parts;

    public ToString(Object object) {
        this.object = object;
        this.parts = new ArrayList<Part>();
    }

    public ToString append(String name, Object value) {
        this.parts.add(new Part(name, value));
        return this;
    }

    public ToString appendField(String name) {
        Field[] classFields;
        Class<?> objectClass = this.object.getClass();
        for (Field field : classFields = objectClass.getFields()) {
            if (!field.getName().equals(name)) continue;
            if (!Modifier.isPublic(field.getModifiers())) {
                throw new IllegalArgumentException("field is not public: " + name + " in class: " + objectClass.getName());
            }
            try {
                Object value = field.get(this.object);
                this.append(name, value);
                return this;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("field not accessible: " + name + " in class: " + objectClass.getName(), e);
            }
        }
        throw new IllegalArgumentException("field does not exist: " + name + " in class: " + objectClass.getName());
    }

    public String toString() {
        if (this.object == null) {
            return "null";
        }
        StringBuilder b = new StringBuilder();
        String separator = ", ";
        for (Part part : this.parts) {
            b.append(part.name);
            b.append('=');
            b.append(this.stringify(part.value));
            b.append(separator);
        }
        if (b.length() > separator.length()) {
            b.setLength(b.length() - separator.length());
        }
        return DebugUtil.shortClassName(this.object) + "{ " + b.toString() + " }";
    }

    private Object stringify(Object value) {
        if (value == null) {
            return NULL_LITERAL;
        }
        if (value instanceof List) {
            return this.stringify((List)value);
        }
        if (value instanceof Set) {
            return this.stringify((Set)value);
        }
        if (value instanceof Map) {
            return this.stringify((Map)value);
        }
        if (value instanceof Collection) {
            return this.stringify((Collection)value);
        }
        if (value instanceof String) {
            return JavaLiteral.encodeString((String)value);
        }
        if (value instanceof Character) {
            return JavaLiteral.encodeChar(((Character)value).charValue());
        }
        return value.toString();
    }

    private String stringify(List<?> value) {
        return value.toString();
    }

    private String stringify(Set<?> value) {
        return value.toString();
    }

    private String stringify(Map<?, ?> value) {
        return value.toString();
    }

    private String stringify(Collection<?> value) {
        return value.toString();
    }

    private class Part {
        public final String name;
        public final Object value;

        public Part(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }
}

