/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

public final class JavaLiteral {
    private JavaLiteral() {
    }

    public static String encodeString(String in) {
        StringBuilder out = new StringBuilder();
        out.append('\"');
        int len = in.length();
        for (int i = 0; i < len; ++i) {
            int hl;
            char c = in.charAt(i);
            if (c == '\"') {
                out.append("\\\"");
                continue;
            }
            if (c == '\\') {
                out.append("\\\\");
                continue;
            }
            if (c >= ' ' && c < '\u007f') {
                out.append(c);
                continue;
            }
            if (c == '\r') {
                out.append("\\r");
                continue;
            }
            if (c == '\n') {
                out.append("\\n");
                continue;
            }
            if (c == '\t') {
                out.append("\\t");
                continue;
            }
            if (c == '\f') {
                out.append("\\f");
                continue;
            }
            if (c == '\b') {
                out.append("\\b");
                continue;
            }
            out.append("\\u");
            String hex = Integer.toHexString(c);
            for (int j = hl = hex.length(); j < 4; ++j) {
                out.append('0');
            }
            out.append(hex);
        }
        out.append('\"');
        return out.toString();
    }

    public static String decodeString(String in) {
        if (in.length() < 2) {
            throw new IllegalArgumentException("too short");
        }
        if (!in.startsWith("\"")) {
            throw new IllegalArgumentException("does not start with a double quote");
        }
        if (!in.endsWith("\"")) {
            throw new IllegalArgumentException("does not end with a double quote");
        }
        in = in.substring(1, in.length() - 1);
        StringBuilder out = new StringBuilder();
        int len = in.length();
        int i = 0;
        while (i < len) {
            int val;
            int c1 = in.charAt(i);
            ++i;
            if (c1 == 92) {
                if (i >= len) {
                    throw new IllegalArgumentException("unfinished escape sequence");
                }
                char c2 = in.charAt(i);
                ++i;
                switch (c2) {
                    case '\\': {
                        val = 92;
                        break;
                    }
                    case 't': {
                        val = 9;
                        break;
                    }
                    case 'r': {
                        val = 13;
                        break;
                    }
                    case 'n': {
                        val = 10;
                        break;
                    }
                    case 'b': {
                        val = 8;
                        break;
                    }
                    case 'f': {
                        val = 12;
                        break;
                    }
                    case 'u': {
                        if (i + 4 > len) {
                            throw new IllegalArgumentException("expected 4 hexdigits");
                        }
                        String c3 = in.substring(i, i + 4);
                        i += 4;
                        val = (char)Integer.parseInt(c3);
                        break;
                    }
                    default: {
                        val = c2;
                        break;
                    }
                }
            } else {
                val = c1;
            }
            out.append((char)val);
        }
        return out.toString();
    }

    public static String encodeChar(char in) {
        StringBuilder out = new StringBuilder();
        out.append('\'');
        if (in == '\'') {
            out.append("\\'");
        } else if (in == '\\') {
            out.append("\\\\");
        } else if (in >= ' ' && in < '\u007f') {
            out.append(in);
        } else if (in == '\r') {
            out.append("\\r");
        } else if (in == '\n') {
            out.append("\\n");
        } else if (in == '\t') {
            out.append("\\t");
        } else if (in == '\f') {
            out.append("\\f");
        } else if (in == '\b') {
            out.append("\\b");
        } else {
            int hl;
            out.append("\\u");
            String hex = Integer.toHexString(in);
            for (int j = hl = hex.length(); j < 4; ++j) {
                out.append('0');
            }
            out.append(hex);
        }
        out.append('\'');
        return out.toString();
    }

    public static char decodeChar(String in) {
        if (in.length() < 3) {
            throw new IllegalArgumentException("too short");
        }
        if (!in.startsWith("'")) {
            throw new IllegalArgumentException("does not start with a single quote");
        }
        if (!in.endsWith("'")) {
            throw new IllegalArgumentException("does not end with a single quote");
        }
        if (in.charAt(1) == '\\') {
            char desc = in.charAt(2);
            if (desc == 'u') {
                if (in.length() != 7) {
                    throw new IllegalArgumentException("not a single character");
                }
                String hex = in.substring(2, in.length() - 1);
                return (char)Integer.parseInt(hex);
            }
            if (in.length() != 4) {
                throw new IllegalArgumentException("not a single character");
            }
            switch (desc) {
                case '\\': {
                    return '\\';
                }
                case 't': {
                    return '\t';
                }
                case 'r': {
                    return '\r';
                }
                case 'n': {
                    return '\n';
                }
                case 'b': {
                    return '\b';
                }
                case 'f': {
                    return '\f';
                }
            }
            throw new IllegalArgumentException("not a single character");
        }
        if (in.length() != 3) {
            throw new IllegalArgumentException("not a single character");
        }
        return in.charAt(1);
    }
}

