/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import net.psammead.util.Logger;
import net.psammead.util.StringUtil;

public final class IOUtil {
    private static final Logger log = new Logger(IOUtil.class);

    private IOUtil() {
    }

    public static String readStringFromURL(URL url, String charSet) throws IOException {
        return IOUtil.readStringFromStream(url.openConnection().getInputStream(), charSet);
    }

    public static String readStringFromFile(File file, String charSet) throws IOException {
        return IOUtil.readStringFromStream(new FileInputStream(file), charSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStringFromStream(InputStream stream, String charSet) throws IOException {
        String string;
        char[] chars = new char[16384];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = null;
        try {
            int len;
            in = new InputStreamReader(stream, charSet);
            while ((len = in.read(chars)) >= 0) {
                out.append(chars, 0, len);
            }
            string = out.toString();
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(in);
            throw throwable;
        }
        IOUtil.closeSilent(in);
        return string;
    }

    public static void writeStringToFile(File target, String text, String charSet) throws IOException {
        IOUtil.writeStringToStream(new FileOutputStream(target), text, charSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToStream(OutputStream stream, String text, String charSet) throws IOException {
        OutputStreamWriter out = null;
        try {
            out = new OutputStreamWriter(stream, charSet);
            out.write(text);
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(out);
            throw throwable;
        }
        IOUtil.closeSilent(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytesToStream(byte[] bytes, OutputStream os) throws IOException {
        try {
            os.write(bytes);
        }
        finally {
            IOUtil.closeSilent(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytesFromStream(InputStream is) throws IOException {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try {
            IOUtil.copyStream(is, bs);
        }
        finally {
            IOUtil.closeSilent(is);
        }
        return bs.toByteArray();
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        int count;
        byte[] buffer = new byte[16384];
        while ((count = is.read(buffer, 0, buffer.length)) != -1) {
            os.write(buffer, 0, count);
        }
    }

    public static void closeSilent(InputStream st) {
        if (st == null) {
            return;
        }
        try {
            st.close();
        }
        catch (IOException e) {
            log.error("cannot close", e);
        }
    }

    public static void closeSilent(OutputStream st) {
        if (st == null) {
            return;
        }
        try {
            st.close();
        }
        catch (IOException e) {
            log.error("cannot close", e);
        }
    }

    public static void closeSilent(Reader st) {
        if (st == null) {
            return;
        }
        try {
            st.close();
        }
        catch (IOException e) {
            log.error("cannot close", e);
        }
    }

    public static void closeSilent(Writer st) {
        if (st == null) {
            return;
        }
        try {
            st.close();
        }
        catch (IOException e) {
            log.error("cannot close", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(from);
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(to);
                IOUtil.copyStream(is, os);
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(os);
                throw throwable;
            }
            IOUtil.closeSilent(os);
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(is);
            throw throwable;
        }
        IOUtil.closeSilent(is);
    }

    public static File backupFile(File file, int digits) {
        int i = 0;
        String suffix;
        while ((suffix = StringUtil.padLeft("" + i, '0', digits)).length() <= digits) {
            File backup = new File(file.getAbsolutePath() + "_" + suffix);
            if (!backup.exists()) {
                return backup;
            }
            ++i;
        }
        return null;
    }
}

