/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

import java.util.Stack;

public final class Glob {
    private Glob() {
    }

    public static boolean matches(String glob, String s) {
        return s.matches(Glob.globToRE(glob));
    }

    public static String globToRE(String glob) {
        Object NEG = new Object();
        Object GROUP = new Object();
        Stack<Object> state = new Stack<Object>();
        StringBuilder buf = new StringBuilder();
        boolean backslash = false;
        block10: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            if (backslash) {
                buf.append('\\');
                buf.append(c);
                backslash = false;
                continue;
            }
            switch (c) {
                case '\\': {
                    backslash = true;
                    continue block10;
                }
                case '?': {
                    buf.append('.');
                    continue block10;
                }
                case '(': 
                case ')': 
                case '+': 
                case '.': {
                    buf.append('\\');
                    buf.append(c);
                    continue block10;
                }
                case '*': {
                    buf.append(".*");
                    continue block10;
                }
                case '|': {
                    if (backslash) {
                        buf.append("\\|");
                        continue block10;
                    }
                    buf.append('|');
                    continue block10;
                }
                case '{': {
                    buf.append('(');
                    if (i + 1 != glob.length() && glob.charAt(i + 1) == '!') {
                        buf.append('?');
                        state.push(NEG);
                        continue block10;
                    }
                    state.push(GROUP);
                    continue block10;
                }
                case ',': {
                    if (!state.isEmpty() && state.peek() == GROUP) {
                        buf.append('|');
                        continue block10;
                    }
                    buf.append(',');
                    continue block10;
                }
                case '}': {
                    if (!state.isEmpty()) {
                        buf.append(")");
                        if (state.pop() != NEG) continue block10;
                        buf.append(".*");
                        continue block10;
                    }
                    buf.append('}');
                    continue block10;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }
}

