/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

import java.util.HashMap;
import java.util.Map;

public class Diff {
    private int equivMax = 1;
    public boolean heuristic = false;
    public boolean noDiscards = false;
    private int[] xVec;
    private int[] yVec;
    private int[] fDiag;
    private int[] bDiag;
    private int fDiagOff;
    private int bDiagOff;
    private final FileData[] fileVec = new FileData[2];
    private int cost;
    private boolean inhibit = false;

    public Diff(Object[] a, Object[] b) {
        HashMap<Object, Integer> h = new HashMap<Object, Integer>(a.length + b.length);
        this.fileVec[0] = new FileData(a, h);
        this.fileVec[1] = new FileData(b, h);
    }

    private int diag(int xOff, int xLim, int yOff, int yLim) {
        int[] fd = this.fDiag;
        int[] bd = this.bDiag;
        int[] xv = this.xVec;
        int[] yv = this.yVec;
        int dMin = xOff - yLim;
        int dMax = xLim - yOff;
        int fMid = xOff - yOff;
        int bMid = xLim - yLim;
        int fMin = fMid;
        int fMax = fMid;
        int bMin = bMid;
        int bMax = bMid;
        boolean odd = (fMid - bMid & 1) != 0;
        fd[this.fDiagOff + fMid] = xOff;
        bd[this.bDiagOff + bMid] = xLim;
        int c = 1;
        while (true) {
            int y;
            int oldX;
            int x;
            int tHi;
            int tLo;
            int d;
            boolean bigSnake = false;
            if (fMin > dMin) {
                fd[this.fDiagOff + --fMin - 1] = -1;
            } else {
                ++fMin;
            }
            if (fMax < dMax) {
                fd[this.fDiagOff + ++fMax + 1] = -1;
            } else {
                --fMax;
            }
            for (d = fMax; d >= fMin; d -= 2) {
                tLo = fd[this.fDiagOff + d - 1];
                tHi = fd[this.fDiagOff + d + 1];
                x = tLo >= tHi ? tLo + 1 : tHi;
                oldX = x;
                for (y = x - d; x < xLim && y < yLim && xv[x] == yv[y]; ++x, ++y) {
                }
                if (x - oldX > 20) {
                    bigSnake = true;
                }
                fd[this.fDiagOff + d] = x;
                if (!odd || bMin > d || d > bMax || bd[this.bDiagOff + d] > fd[this.fDiagOff + d]) continue;
                this.cost = 2 * c - 1;
                return d;
            }
            if (bMin > dMin) {
                bd[this.bDiagOff + --bMin - 1] = Integer.MAX_VALUE;
            } else {
                ++bMin;
            }
            if (bMax < dMax) {
                bd[this.bDiagOff + ++bMax + 1] = Integer.MAX_VALUE;
            } else {
                --bMax;
            }
            for (d = bMax; d >= bMin; d -= 2) {
                tLo = bd[this.bDiagOff + d - 1];
                tHi = bd[this.bDiagOff + d + 1];
                x = tLo < tHi ? tLo : tHi - 1;
                oldX = x;
                for (y = x - d; x > xOff && y > yOff && xv[x - 1] == yv[y - 1]; --x, --y) {
                }
                if (oldX - x > 20) {
                    bigSnake = true;
                }
                bd[this.bDiagOff + d] = x;
                if (odd || fMin > d || d > fMax || bd[this.bDiagOff + d] > fd[this.fDiagOff + d]) continue;
                this.cost = 2 * c;
                return d;
            }
            if (c > 200 && bigSnake && this.heuristic) {
                int k;
                int x2;
                int dd;
                int best = 0;
                int bestPos = -1;
                for (d = fMax; d >= fMin; d -= 2) {
                    dd = d - fMid;
                    if ((fd[this.fDiagOff + d] - xOff) * 2 - dd <= 12 * (c + (dd > 0 ? dd : -dd)) || fd[this.fDiagOff + d] * 2 - dd <= best || fd[this.fDiagOff + d] - xOff <= 20 || fd[this.fDiagOff + d] - d - yOff <= 20) continue;
                    x2 = fd[this.fDiagOff + d];
                    for (k = 1; k <= 20 && this.xVec[x2 - k] == this.yVec[x2 - d - k]; ++k) {
                    }
                    if (k != 21) continue;
                    best = fd[this.fDiagOff + d] * 2 - dd;
                    bestPos = d;
                }
                if (best > 0) {
                    this.cost = 2 * c - 1;
                    return bestPos;
                }
                best = 0;
                for (d = bMax; d >= bMin; d -= 2) {
                    dd = d - bMid;
                    if ((xLim - bd[this.bDiagOff + d]) * 2 + dd <= 12 * (c + (dd > 0 ? dd : -dd)) || (xLim - bd[this.bDiagOff + d]) * 2 + dd <= best || xLim - bd[this.bDiagOff + d] <= 20 || yLim - (bd[this.bDiagOff + d] - d) <= 20) continue;
                    x2 = bd[this.bDiagOff + d];
                    for (k = 0; k < 20 && this.xVec[x2 + k] == this.yVec[x2 - d + k]; ++k) {
                    }
                    if (k != 20) continue;
                    best = (xLim - bd[this.bDiagOff + d]) * 2 + dd;
                    bestPos = d;
                }
                if (best > 0) {
                    this.cost = 2 * c - 1;
                    return bestPos;
                }
            }
            ++c;
        }
    }

    private void compareSeq(int xOff, int xLim, int yOff, int yLim) {
        while (xOff < xLim && yOff < yLim && this.xVec[xOff] == this.yVec[yOff]) {
            ++xOff;
            ++yOff;
        }
        while (xLim > xOff && yLim > yOff && this.xVec[xLim - 1] == this.yVec[yLim - 1]) {
            --xLim;
            --yLim;
        }
        if (xOff == xLim) {
            while (yOff < yLim) {
                this.fileVec[1].changedFlag[1 + this.fileVec[1].realIndexes[yOff++]] = true;
            }
        } else if (yOff == yLim) {
            while (xOff < xLim) {
                this.fileVec[0].changedFlag[1 + this.fileVec[0].realIndexes[xOff++]] = true;
            }
        } else {
            int d = this.diag(xOff, xLim, yOff, yLim);
            int c = this.cost;
            int b = this.bDiag[this.bDiagOff + d];
            if (c == 1) {
                throw new IllegalArgumentException("Empty subsequence");
            }
            this.compareSeq(xOff, b, yOff, b - d);
            this.compareSeq(b, xLim, b - d, yLim);
        }
    }

    private void discardConfusingLines() {
        this.fileVec[0].discardConfusingLines(this.fileVec[1]);
        this.fileVec[1].discardConfusingLines(this.fileVec[0]);
    }

    private void shiftBoundaries() {
        if (this.inhibit) {
            return;
        }
        this.fileVec[0].shiftBoundaries(this.fileVec[1]);
        this.fileVec[1].shiftBoundaries(this.fileVec[0]);
    }

    private Change buildScriptReverse() {
        Change script = null;
        boolean[] changed0 = this.fileVec[0].changedFlag;
        boolean[] changed1 = this.fileVec[1].changedFlag;
        int len0 = this.fileVec[0].bufferedLines;
        int len1 = this.fileVec[1].bufferedLines;
        int i0 = 0;
        for (int i1 = 0; i0 < len0 || i1 < len1; ++i0, ++i1) {
            if (!changed0[1 + i0] && !changed1[1 + i1]) continue;
            int line0 = i0;
            int line1 = i1;
            while (changed0[1 + i0]) {
                ++i0;
            }
            while (changed1[1 + i1]) {
                ++i1;
            }
            script = new Change(line0, line1, i0 - line0, i1 - line1, script);
        }
        return script;
    }

    private Change buildScript() {
        Change script = null;
        boolean[] changed0 = this.fileVec[0].changedFlag;
        boolean[] changed1 = this.fileVec[1].changedFlag;
        int len0 = this.fileVec[0].bufferedLines;
        int len1 = this.fileVec[1].bufferedLines;
        int i0 = len0;
        for (int i1 = len1; i0 >= 0 || i1 >= 0; --i0, --i1) {
            if (!changed0[i0] && !changed1[i1]) continue;
            int line0 = i0;
            int line1 = i1;
            while (changed0[i0]) {
                --i0;
            }
            while (changed1[i1]) {
                --i1;
            }
            script = new Change(i0, i1, line0 - i0, line1 - i1, script);
        }
        return script;
    }

    public Change diff2(boolean reverse) {
        this.discardConfusingLines();
        this.xVec = this.fileVec[0].unDiscarded;
        this.yVec = this.fileVec[1].unDiscarded;
        int diags = this.fileVec[0].nonDiscardedLines + this.fileVec[1].nonDiscardedLines + 3;
        this.fDiag = new int[diags];
        this.fDiagOff = this.fileVec[1].nonDiscardedLines + 1;
        this.bDiag = new int[diags];
        this.bDiagOff = this.fileVec[1].nonDiscardedLines + 1;
        this.compareSeq(0, this.fileVec[0].nonDiscardedLines, 0, this.fileVec[1].nonDiscardedLines);
        this.fDiag = null;
        this.bDiag = null;
        this.shiftBoundaries();
        if (reverse) {
            return this.buildScriptReverse();
        }
        return this.buildScript();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FileData {
        final int bufferedLines;
        private final int[] equivs;
        final int[] unDiscarded;
        final int[] realIndexes;
        int nonDiscardedLines;
        boolean[] changedFlag;

        FileData(Object[] data, Map<Object, Integer> h) {
            this.bufferedLines = data.length;
            this.equivs = new int[this.bufferedLines];
            this.unDiscarded = new int[this.bufferedLines];
            this.realIndexes = new int[this.bufferedLines];
            for (int i = 0; i < data.length; ++i) {
                Integer ir = h.get(data[i]);
                if (ir == null) {
                    this.equivs[i] = Diff.this.equivMax++;
                    h.put(data[i], new Integer(this.equivs[i]));
                    continue;
                }
                this.equivs[i] = ir;
            }
        }

        void clear() {
            this.changedFlag = new boolean[this.bufferedLines + 2];
        }

        int[] equivCount() {
            int[] equivCount = new int[Diff.this.equivMax];
            for (int i = 0; i < this.bufferedLines; ++i) {
                int n = this.equivs[i];
                equivCount[n] = equivCount[n] + 1;
            }
            return equivCount;
        }

        void discardConfusingLines(FileData f) {
            this.clear();
            byte[] discarded = this.discardable(f.equivCount());
            this.filterDiscards(discarded);
            this.discard(discarded);
        }

        private byte[] discardable(int[] counts) {
            int end = this.bufferedLines;
            byte[] discards = new byte[end];
            int many = 5;
            int tem = end / 64;
            while ((tem >>= 2) > 0) {
                many *= 2;
            }
            for (int i = 0; i < end; ++i) {
                if (this.equivs[i] == 0) continue;
                int nMatch = counts[this.equivs[i]];
                if (nMatch == 0) {
                    discards[i] = 1;
                    continue;
                }
                if (nMatch <= many) continue;
                discards[i] = 2;
            }
            return discards;
        }

        private void filterDiscards(byte[] discards) {
            int end = this.bufferedLines;
            block0: for (int i = 0; i < end; ++i) {
                int j;
                if (discards[i] == 2) {
                    discards[i] = 0;
                    continue;
                }
                if (discards[i] == 0) continue;
                int provisional = 0;
                for (j = i; j < end && discards[j] != 0; ++j) {
                    if (discards[j] != 2) continue;
                    ++provisional;
                }
                while (j > i && discards[j - 1] == 2) {
                    discards[--j] = 0;
                    --provisional;
                }
                int length = j - i;
                if (provisional * 4 > length) {
                    while (j > i) {
                        if (discards[--j] != 2) continue;
                        discards[j] = 0;
                    }
                    continue;
                }
                int minimum = 1;
                int tem = length / 4;
                while ((tem >>= 2) > 0) {
                    minimum *= 2;
                }
                ++minimum;
                int consec = 0;
                for (j = 0; j < length; ++j) {
                    if (discards[i + j] != 2) {
                        consec = 0;
                        continue;
                    }
                    if (minimum == ++consec) {
                        j -= consec;
                        continue;
                    }
                    if (minimum >= consec) continue;
                    discards[i + j] = 0;
                }
                consec = 0;
                for (j = 0; j < length && (j < 8 || discards[i + j] != 1); ++j) {
                    if (discards[i + j] == 2) {
                        consec = 0;
                        discards[i + j] = 0;
                    } else {
                        consec = discards[i + j] == 0 ? 0 : ++consec;
                    }
                    if (consec == 3) break;
                }
                i += length - 1;
                consec = 0;
                for (j = 0; j < length && (j < 8 || discards[i - j] != 1); ++j) {
                    if (discards[i - j] == 2) {
                        consec = 0;
                        discards[i - j] = 0;
                    } else {
                        consec = discards[i - j] == 0 ? 0 : ++consec;
                    }
                    if (consec == 3) continue block0;
                }
            }
        }

        private void discard(byte[] discards) {
            int end = this.bufferedLines;
            int j = 0;
            for (int i = 0; i < end; ++i) {
                if (Diff.this.noDiscards || discards[i] == 0) {
                    this.unDiscarded[j] = this.equivs[i];
                    this.realIndexes[j++] = i;
                    continue;
                }
                this.changedFlag[1 + i] = true;
            }
            this.nonDiscardedLines = j;
        }

        void shiftBoundaries(FileData f) {
            boolean[] changed = this.changedFlag;
            boolean[] otherChanged = f.changedFlag;
            int i = 0;
            int j = 0;
            int iEnd = this.bufferedLines;
            int preceding = -1;
            int otherPreceding = -1;
            while (true) {
                if (i < iEnd && !changed[1 + i]) {
                    while (otherChanged[1 + j++]) {
                        otherPreceding = j;
                    }
                    ++i;
                    continue;
                }
                if (i == iEnd) break;
                int start = i;
                int otherStart = j;
                while (true) {
                    if (i < iEnd && changed[1 + i]) {
                        ++i;
                        continue;
                    }
                    int end = i;
                    if (end == iEnd || this.equivs[start] != this.equivs[end] || otherChanged[1 + j] || end == iEnd || preceding >= 0 && start == preceding || otherPreceding >= 0 && otherStart == otherPreceding) break;
                    changed[1 + end++] = true;
                    changed[1 + start++] = false;
                    ++i;
                    ++j;
                }
                preceding = i;
                otherPreceding = j;
            }
        }
    }

    public static class Change {
        public Change link;
        public final int inserted;
        public final int deleted;
        public final int line0;
        public final int line1;

        Change(int line0, int line1, int deleted, int inserted, Change old) {
            this.line0 = line0;
            this.line1 = line1;
            this.inserted = inserted;
            this.deleted = deleted;
            this.link = old;
        }
    }
}

