/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Announcer<LISTENER extends EventListener> {
    public final LISTENER send;
    private final List<LISTENER> listeners = new ArrayList<LISTENER>();

    public static <T extends EventListener> Announcer<T> to(Class<? extends T> listenerType) {
        return new Announcer<T>(listenerType);
    }

    public Announcer(Class<? extends LISTENER> listenerType) {
        this.send = (EventListener)listenerType.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{listenerType}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Announcer.this.announce(method, args);
                return null;
            }
        }));
    }

    public synchronized void addListener(LISTENER listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(LISTENER listener) {
        this.listeners.remove(listener);
    }

    private synchronized List<LISTENER> clonedListeners() {
        return new ArrayList<LISTENER>(this.listeners);
    }

    private void announce(Method m, Object[] args) {
        try {
            for (EventListener listener : this.clonedListeners()) {
                m.invoke((Object)listener, args);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("could not invoke listener", e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new UnsupportedOperationException("listener threw exception", cause);
        }
    }
}

