/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.ClassWriter;

public final class LineNumberTableWriter
extends ClassWriter.Element {
    private final int attrID;
    private int[] rawTable = emptyTable;
    private static final int[] emptyTable = new int[0];

    public LineNumberTableWriter(ClassWriter classWriter) {
        if (classWriter == null) {
            throw new IllegalArgumentException("w is null");
        }
        this.attrID = classWriter.addCPUtf8("LineNumberTable");
    }

    public void setRawTable(int[] nArray) {
        if (nArray == null) {
            nArray = emptyTable;
        }
        if (nArray.length % 2 != 0) {
            throw new IllegalArgumentException("Line number table has bad length: " + nArray.length);
        }
        if (nArray.length / 2 > 65535) {
            throw new IllegalArgumentException("Too many line number table entries: " + nArray.length / 2);
        }
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            if (n2 < 0 || n2 > 65535) {
                throw new IllegalArgumentException("Bad line number table entry at " + n + ": " + n2);
            }
            ++n;
        }
        this.rawTable = nArray;
    }

    public int getSize() {
        return 8 + this.rawTable.length * 2;
    }

    public int copyInto(byte[] byArray, int n) throws IllegalArgumentException {
        ClassWriter.setUShort(byArray, n, this.attrID);
        ClassWriter.setInt(byArray, n + 2, 2 + this.rawTable.length * 2);
        ClassWriter.setUShort(byArray, n + 6, this.rawTable.length / 2);
        n += 8;
        int n2 = 0;
        while (n2 < this.rawTable.length) {
            ClassWriter.setUShort(byArray, n, this.rawTable[n2]);
            n += 2;
            ++n2;
        }
        return n;
    }

    public static int[] makeRawTable(int[] nArray) throws IllegalArgumentException {
        int n;
        if (nArray == null) {
            throw new IllegalArgumentException("newLineMap == null");
        }
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        while (n4 < nArray.length) {
            n = nArray[n4];
            if (n != n3) {
                ++n2;
            }
            ++n4;
        }
        int[] nArray2 = new int[n2 * 2];
        n3 = -1;
        n = 0;
        int n5 = 0;
        while (n5 < nArray.length) {
            int n6 = nArray[n5];
            if (n6 != n3) {
                nArray2[n] = n5;
                nArray2[n + 1] = n6;
                n += 2;
            }
            ++n5;
        }
        return nArray2;
    }
}

