/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.ClassWriter;

public final class InnerClassesWriter
extends ClassWriter.Element {
    private final int attrID;
    private int[] table;

    public InnerClassesWriter(ClassWriter classWriter) {
        if (classWriter == null) {
            throw new IllegalArgumentException("w is null");
        }
        this.attrID = classWriter.addCPUtf8("InnerClasses");
    }

    public int getSize() {
        return this.table == null ? 8 : 8 + this.table.length * 2;
    }

    public int copyInto(byte[] byArray, int n) throws IllegalArgumentException {
        ClassWriter.setUShort(byArray, n, this.attrID);
        ClassWriter.setInt(byArray, n + 2, this.getSize() - 6);
        ClassWriter.setUShort(byArray, n + 6, this.table == null ? 0 : this.table.length);
        n += 8;
        if (this.table != null) {
            int n2 = 0;
            while (n2 < this.table.length) {
                ClassWriter.setUShort(byArray, n, this.table[n2]);
                n += 2;
                ++n2;
            }
        }
        return n;
    }

    public void setRawTable(int[] nArray) throws NullPointerException {
        if (nArray == null) {
            throw new IllegalArgumentException("classes is null");
        }
        if (nArray.length % 4 != 0) {
            throw new IllegalArgumentException("Invalid raw table length: " + nArray.length);
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] < 1 || nArray[n] > 65535) {
                throw new IllegalArgumentException("Invalid CP index: " + nArray[n]);
            }
            if (nArray[n + 1] < 0 || nArray[n + 1] > 65535) {
                throw new IllegalArgumentException("Invalid CP index: " + nArray[n]);
            }
            if (nArray[n + 2] < 0 || nArray[n + 2] > 65535) {
                throw new IllegalArgumentException("Invalid CP index: " + nArray[n]);
            }
            n += 4;
        }
        this.table = nArray;
    }
}

