/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.AttributeReader;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;

public final class CodeReader
extends AttributeReader {
    private final int codeLen;
    private final int exnTableLen;

    public CodeReader(ClassReader.AttrIterator attrIterator) throws InvalidClassFileException {
        super(attrIterator, "Code");
        int n = this.attr + 6;
        this.checkSize(n, 8);
        this.codeLen = this.cr.getInt(n + 4);
        this.checkSize(n += 8, this.codeLen + 2);
        this.exnTableLen = this.cr.getUShort(n += this.codeLen);
        this.checkSize(n += 2, this.exnTableLen * 8 + 2);
        int n2 = this.cr.getUShort(n += this.exnTableLen * 8);
        n += 2;
        int n3 = 0;
        while (n3 < n2) {
            this.checkSize(n, 6);
            int n4 = this.cr.getInt(n + 2);
            this.checkSize(n += 6, n4);
            n += n4;
            ++n3;
        }
    }

    public int getMaxStack() {
        return this.cr.getUShort(this.attr + 6);
    }

    public int getMaxLocals() {
        return this.cr.getUShort(this.attr + 8);
    }

    public int getBytecodeLength() {
        return this.codeLen;
    }

    public byte[] getBytecode() {
        byte[] byArray = new byte[this.codeLen];
        System.arraycopy(this.cr.getBytes(), this.attr + 14, byArray, 0, byArray.length);
        return byArray;
    }

    public int[] getRawHandlers() {
        int[] nArray = new int[this.exnTableLen * 4];
        int n = this.attr + 14 + this.codeLen + 2;
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = this.cr.getUShort(n);
            n += 2;
            ++n2;
        }
        return nArray;
    }

    public void initAttributeIterator(ClassReader.AttrIterator attrIterator) {
        if (attrIterator == null) {
            throw new IllegalArgumentException("iter is null");
        }
        attrIterator.init(this.cr, this.attr + 14 + this.codeLen + 2 + this.exnTableLen * 8);
    }
}

