/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.ClassConstants;
import com.ibm.wala.shrikeCT.ConstantPoolParser;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import java.util.ArrayList;
import java.util.HashMap;

public final class ClassWriter
implements ClassConstants {
    private int majorVersion = 46;
    private int minorVersion = 0;
    private ConstantPoolParser rawCP;
    private HashMap<Object, Integer> cachedCPEntries = new HashMap(1);
    private final ArrayList<Object> newCPEntries = new ArrayList(1);
    private int nextCPIndex = 1;
    private final ArrayList<Element> fields = new ArrayList(1);
    private final ArrayList<Element> methods = new ArrayList(1);
    private final ArrayList<Element> classAttributes = new ArrayList(1);
    private int thisClass;
    private int superClass;
    private int[] superInterfaces;
    private int accessFlags;
    private boolean forceAddCPEntries = false;
    private byte[] buf;
    private int bufLen;
    private static final char[] noChars = new char[0];

    public void setMajorVersion(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Major version out of range: " + n);
        }
        this.majorVersion = n;
    }

    public void setMinorVersion(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Major version out of range: " + n);
        }
        this.minorVersion = n;
    }

    public void setRawCP(ConstantPoolParser constantPoolParser, boolean bl) throws InvalidClassFileException, IllegalArgumentException {
        if (constantPoolParser == null) {
            throw new IllegalArgumentException();
        }
        if (this.rawCP != null) {
            throw new IllegalArgumentException("Cannot set raw constant pool twice");
        }
        if (this.nextCPIndex != 1) {
            throw new IllegalArgumentException("Cannot set raw constant pool after allocating new entries");
        }
        this.rawCP = constantPoolParser;
        this.nextCPIndex = constantPoolParser.getItemCount();
        if (bl) {
            int n = 1;
            while (n < this.nextCPIndex) {
                byte by = constantPoolParser.getItemType(n);
                switch (by) {
                    case 8: {
                        this.cachedCPEntries.put(new CWString(constantPoolParser.getCPString(n)), new Integer(n));
                        break;
                    }
                    case 7: {
                        this.cachedCPEntries.put(new CWClass(constantPoolParser.getCPClass(n)), new Integer(n));
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        this.cachedCPEntries.put(new CWRef(by, constantPoolParser.getCPRefClass(n), constantPoolParser.getCPRefName(n), constantPoolParser.getCPRefType(n)), new Integer(n));
                        break;
                    }
                    case 12: {
                        this.cachedCPEntries.put(new CWNAT(constantPoolParser.getCPNATName(n), constantPoolParser.getCPNATType(n)), new Integer(n));
                        break;
                    }
                    case 3: {
                        this.cachedCPEntries.put(new Integer(constantPoolParser.getCPInt(n)), new Integer(n));
                        break;
                    }
                    case 4: {
                        this.cachedCPEntries.put(new Float(constantPoolParser.getCPFloat(n)), new Integer(n));
                        break;
                    }
                    case 5: {
                        this.cachedCPEntries.put(new Long(constantPoolParser.getCPLong(n)), new Integer(n));
                        break;
                    }
                    case 6: {
                        this.cachedCPEntries.put(new Double(constantPoolParser.getCPDouble(n)), new Integer(n));
                        break;
                    }
                    case 1: {
                        this.cachedCPEntries.put(constantPoolParser.getCPUtf8(n), new Integer(n));
                    }
                }
                ++n;
            }
        }
    }

    public void setForceAddCPEntries(boolean bl) {
        this.forceAddCPEntries = bl;
    }

    private int addCPEntry(Object object, int n) {
        Integer n2;
        if (this.cachedCPEntries == null) {
            throw new IllegalArgumentException("Cannot add a new constant pool entry during makeBytes() processing!");
        }
        Integer n3 = n2 = this.forceAddCPEntries ? null : this.cachedCPEntries.get(object);
        if (n2 != null) {
            return n2;
        }
        int n4 = this.nextCPIndex;
        this.nextCPIndex += n;
        n2 = new Integer(n4);
        this.cachedCPEntries.put(object, n2);
        this.newCPEntries.add(object);
        if (this.nextCPIndex > 65535) {
            throw new IllegalArgumentException("Constant pool item count exceeded");
        }
        return n4;
    }

    public int addCPUtf8(String string) {
        return this.addCPEntry(string, 1);
    }

    public int addCPInt(int n) {
        return this.addCPEntry(new Integer(n), 1);
    }

    public int addCPFloat(float f) {
        return this.addCPEntry(new Float(f), 1);
    }

    public int addCPLong(long l) {
        return this.addCPEntry(new Long(l), 2);
    }

    public int addCPDouble(double d) {
        return this.addCPEntry(new Double(d), 2);
    }

    public int addCPString(String string) {
        return this.addCPEntry(new CWString(string), 1);
    }

    public int addCPClass(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null s: " + string);
        }
        return this.addCPEntry(new CWClass(string), 1);
    }

    public int addCPFieldRef(String string, String string2, String string3) {
        return this.addCPEntry(new CWRef(9, string, string2, string3), 1);
    }

    public int addCPMethodRef(String string, String string2, String string3) {
        return this.addCPEntry(new CWRef(10, string, string2, string3), 1);
    }

    public int addCPInterfaceMethodRef(String string, String string2, String string3) {
        return this.addCPEntry(new CWRef(11, string, string2, string3), 1);
    }

    public int addCPNAT(String string, String string2) {
        return this.addCPEntry(new CWNAT(string, string2), 1);
    }

    public void setAccessFlags(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Access flags out of range: " + n);
        }
        this.accessFlags = n;
    }

    public void setNameIndex(int n) throws IllegalArgumentException {
        if (n < 1 || n > 65535) {
            throw new IllegalArgumentException("Class name index out of range: " + n);
        }
        this.thisClass = n;
    }

    public void setSuperNameIndex(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Superclass name index out of range: " + n);
        }
        this.superClass = n;
    }

    public void setInterfaceNameIndices(int[] nArray) {
        if (nArray != null) {
            if (nArray.length > 65535) {
                throw new IllegalArgumentException("Too many interfaces implemented: " + nArray.length);
            }
            int n = 0;
            while (n < nArray.length) {
                int n2 = nArray[n];
                if (n2 < 1 || n2 > 65535) {
                    throw new IllegalArgumentException("Interface name index out of range: " + n2);
                }
                ++n;
            }
        }
        this.superInterfaces = nArray;
    }

    public void setName(String string) {
        this.setNameIndex(this.addCPClass(string));
    }

    public void setSuperName(String string) {
        this.setSuperNameIndex(string == null ? 0 : this.addCPClass(string));
    }

    public void setInterfaceNames(String[] stringArray) {
        if (stringArray == null) {
            this.setInterfaceNameIndices(null);
        } else {
            int[] nArray = new int[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                nArray[n] = this.addCPClass(stringArray[n]);
                ++n;
            }
            this.setInterfaceNameIndices(nArray);
        }
    }

    public void addRawMethod(Element element) {
        this.methods.add(element);
    }

    public void addRawField(Element element) {
        this.fields.add(element);
    }

    public void addMethod(int n, String string, String string2, Element[] elementArray) {
        this.addMethod(n, this.addCPUtf8(string), this.addCPUtf8(string2), elementArray);
    }

    public void addField(int n, String string, String string2, Element[] elementArray) {
        this.addField(n, this.addCPUtf8(string), this.addCPUtf8(string2), elementArray);
    }

    public void addMethod(int n, int n2, int n3, Element[] elementArray) {
        this.methods.add(new MemberElement(n, n2, n3, elementArray));
        if (this.methods.size() > 65535) {
            throw new IllegalArgumentException("Too many methods");
        }
    }

    public void addField(int n, int n2, int n3, Element[] elementArray) {
        this.fields.add(new MemberElement(n, n2, n3, elementArray));
        if (this.fields.size() > 65535) {
            throw new IllegalArgumentException("Too many fields");
        }
    }

    public void addClassAttribute(Element element) {
        this.classAttributes.add(element);
        if (this.classAttributes.size() > 65535) {
            throw new IllegalArgumentException("Too many class attributes: " + this.classAttributes.size());
        }
    }

    private int reserveBuf(int n) {
        if (this.buf == null) {
            this.buf = new byte[n];
        } else if (this.bufLen + n > this.buf.length) {
            byte[] byArray = new byte[Math.max(this.buf.length * 2, this.bufLen + n)];
            System.arraycopy(this.buf, 0, byArray, 0, this.bufLen);
            this.buf = byArray;
        }
        int n2 = this.bufLen;
        this.bufLen += n;
        return n2;
    }

    private void emitElement(Element element) {
        int n = element.getSize();
        int n2 = this.reserveBuf(n);
        int n3 = element.copyInto(this.buf, n2);
        if (n3 - n2 != n) {
            throw new Error("Element failed to output the promised bytes: promised " + n + ", got " + (n3 - n2));
        }
    }

    private void emitConstantPool() {
        int n;
        if (this.rawCP != null) {
            int n2 = this.rawCP.getRawSize();
            n = this.reserveBuf(n2);
            System.arraycopy(this.rawCP.getRawBytes(), this.rawCP.getRawOffset(), this.buf, n, n2);
        }
        char[] cArray = noChars;
        n = 0;
        while (n < this.newCPEntries.size()) {
            int n3;
            int n4;
            Object object = this.newCPEntries.get(n);
            if (object instanceof CWItem) {
                CWItem cWItem = (CWItem)object;
                n4 = cWItem.getType();
                switch (n4) {
                    case 7: {
                        n3 = this.reserveBuf(3);
                        ClassWriter.setUShort(this.buf, n3 + 1, this.addCPUtf8(((CWClass)cWItem).c));
                        break;
                    }
                    case 8: {
                        n3 = this.reserveBuf(3);
                        ClassWriter.setUShort(this.buf, n3 + 1, this.addCPUtf8(((CWString)cWItem).s));
                        break;
                    }
                    case 12: {
                        n3 = this.reserveBuf(5);
                        CWNAT cWNAT = (CWNAT)cWItem;
                        ClassWriter.setUShort(this.buf, n3 + 1, this.addCPUtf8(cWNAT.n));
                        ClassWriter.setUShort(this.buf, n3 + 3, this.addCPUtf8(cWNAT.t));
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        n3 = this.reserveBuf(5);
                        CWRef cWRef = (CWRef)cWItem;
                        ClassWriter.setUShort(this.buf, n3 + 1, this.addCPClass(cWRef.c));
                        ClassWriter.setUShort(this.buf, n3 + 3, this.addCPNAT(cWRef.n, cWRef.t));
                        break;
                    }
                    default: {
                        throw new Error("Invalid type: " + n4);
                    }
                }
                this.buf[n3] = n4;
            } else if (object instanceof String) {
                String string = (String)object;
                n4 = string.length();
                if (cArray.length < n4) {
                    cArray = new char[n4];
                }
                string.getChars(0, n4, cArray, 0);
                n3 = this.reserveBuf(3);
                this.buf[n3] = 1;
                int n5 = n4 * 3;
                int n6 = this.reserveBuf(n5);
                int n7 = 0;
                while (n7 < n4) {
                    char c = cArray[n7];
                    if (c == '\u0000') {
                        ClassWriter.setUShort(this.buf, n6, 49280);
                        n6 += 2;
                    } else if (c < '\u0080') {
                        this.buf[n6] = (byte)c;
                        ++n6;
                    } else if (c < '\u0800') {
                        this.buf[n6] = (byte)(c >> 6 | 0xC0);
                        this.buf[n6 + 1] = (byte)(c & 0x3F | 0x80);
                        n6 += 2;
                    } else {
                        this.buf[n6] = (byte)(c >> 12 | 0xE0);
                        this.buf[n6 + 1] = (byte)(c >> 6 & 0x3F | 0x80);
                        this.buf[n6 + 2] = (byte)(c & 0x3F | 0x80);
                        n6 += 3;
                    }
                    ++n7;
                }
                n7 = n6 - (n3 + 3);
                this.reserveBuf(n7 - n5);
                if (n7 > 65535) {
                    throw new IllegalArgumentException("String too long: " + n7 + " bytes");
                }
                ClassWriter.setUShort(this.buf, n3 + 1, n7);
            } else if (object instanceof Integer) {
                int n8 = this.reserveBuf(5);
                this.buf[n8] = 3;
                ClassWriter.setInt(this.buf, n8 + 1, (Integer)object);
            } else if (object instanceof Long) {
                int n9 = this.reserveBuf(9);
                this.buf[n9] = 5;
                ClassWriter.setLong(this.buf, n9 + 1, (Long)object);
            } else if (object instanceof Float) {
                int n10 = this.reserveBuf(5);
                this.buf[n10] = 4;
                ClassWriter.setFloat(this.buf, n10 + 1, ((Float)object).intValue());
            } else if (object instanceof Double) {
                int n11 = this.reserveBuf(9);
                this.buf[n11] = 6;
                ClassWriter.setDouble(this.buf, n11 + 1, ((Double)object).intValue());
            }
            ++n;
        }
    }

    public byte[] makeBytes() throws IllegalArgumentException {
        int n;
        if (this.buf != null) {
            throw new IllegalArgumentException("Can't call makeBytes() twice");
        }
        if (this.thisClass == 0) {
            throw new IllegalArgumentException("No class name set");
        }
        this.reserveBuf(10);
        ClassWriter.setInt(this.buf, 0, -889275714);
        ClassWriter.setUShort(this.buf, 4, this.minorVersion);
        ClassWriter.setUShort(this.buf, 6, this.majorVersion);
        this.emitConstantPool();
        ClassWriter.setUShort(this.buf, 8, this.nextCPIndex);
        this.cachedCPEntries = null;
        int n2 = this.reserveBuf(8);
        ClassWriter.setUShort(this.buf, n2, this.accessFlags);
        ClassWriter.setUShort(this.buf, n2 + 2, this.thisClass);
        ClassWriter.setUShort(this.buf, n2 + 4, this.superClass);
        if (this.superInterfaces != null) {
            ClassWriter.setUShort(this.buf, n2 + 6, this.superInterfaces.length);
            this.reserveBuf(this.superInterfaces.length * 2);
            n = 0;
            while (n < this.superInterfaces.length) {
                ClassWriter.setUShort(this.buf, n2 + 8 + n * 2, this.superInterfaces[n]);
                ++n;
            }
        } else {
            ClassWriter.setUShort(this.buf, n2 + 6, 0);
        }
        n2 = this.reserveBuf(2);
        n = this.fields.size();
        ClassWriter.setUShort(this.buf, n2, n);
        int n3 = 0;
        while (n3 < n) {
            this.emitElement(this.fields.get(n3));
            ++n3;
        }
        n2 = this.reserveBuf(2);
        n3 = this.methods.size();
        ClassWriter.setUShort(this.buf, n2, n3);
        int n4 = 0;
        while (n4 < n3) {
            this.emitElement(this.methods.get(n4));
            ++n4;
        }
        n2 = this.reserveBuf(2);
        n4 = this.classAttributes.size();
        ClassWriter.setUShort(this.buf, n2, n4);
        int n5 = 0;
        while (n5 < n4) {
            this.emitElement(this.classAttributes.get(n5));
            ++n5;
        }
        if (this.buf.length == this.bufLen) {
            return this.buf;
        }
        byte[] byArray = new byte[this.bufLen];
        System.arraycopy(this.buf, 0, byArray, 0, this.bufLen);
        return byArray;
    }

    public static void setUByte(byte[] byArray, int n, int n2) throws IllegalArgumentException {
        if (byArray == null) {
            throw new IllegalArgumentException("buf is null");
        }
        try {
            byArray[n] = (byte)n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid offset: " + n);
        }
    }

    public static void setInt(byte[] byArray, int n, int n2) throws IllegalArgumentException {
        if (byArray == null) {
            throw new IllegalArgumentException("buf is null");
        }
        try {
            byArray[n] = (byte)(n2 >> 24);
            byArray[n + 1] = (byte)(n2 >> 16);
            byArray[n + 2] = (byte)(n2 >> 8);
            byArray[n + 3] = (byte)n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("illegal offset " + n);
        }
    }

    public static void setLong(byte[] byArray, int n, long l) throws IllegalArgumentException {
        ClassWriter.setInt(byArray, n, (int)(l >> 32));
        ClassWriter.setInt(byArray, n + 4, (int)l);
    }

    public static void setFloat(byte[] byArray, int n, float f) throws IllegalArgumentException {
        ClassWriter.setInt(byArray, n, Float.floatToIntBits(f));
    }

    public static void setDouble(byte[] byArray, int n, double d) throws IllegalArgumentException {
        ClassWriter.setLong(byArray, n, Double.doubleToRawLongBits(d));
    }

    public static void setUShort(byte[] byArray, int n, int n2) throws IllegalArgumentException {
        if (byArray == null) {
            throw new IllegalArgumentException("buf is null");
        }
        if (n < 0 || n + 1 >= byArray.length) {
            throw new IllegalArgumentException("buf is too short " + byArray.length + " " + n);
        }
        try {
            byArray[n] = (byte)(n2 >> 8);
            byArray[n + 1] = (byte)n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid offset: " + n);
        }
    }

    static class CWClass
    extends CWItem {
        private final String c;

        CWClass(String string) {
            this.c = string;
        }

        public boolean equals(Object object) {
            return object instanceof CWClass && ((CWClass)object).c.equals(this.c);
        }

        public int hashCode() {
            return this.c.hashCode() + 1431;
        }

        byte getType() {
            return 7;
        }
    }

    static abstract class CWItem {
        CWItem() {
        }

        abstract byte getType();
    }

    static class CWNAT
    extends CWItem {
        private final String n;
        private final String t;

        CWNAT(String string, String string2) {
            this.n = string;
            this.t = string2;
        }

        public boolean equals(Object object) {
            if (object instanceof CWNAT) {
                CWNAT cWNAT = (CWNAT)object;
                return cWNAT.n.equals(this.n) && cWNAT.t.equals(this.t);
            }
            return false;
        }

        public int hashCode() {
            return (this.n.hashCode() << 3) + this.t.hashCode();
        }

        byte getType() {
            return 12;
        }
    }

    static class CWRef
    extends CWItem {
        private final String c;
        private final String n;
        private final String t;
        private final byte type;

        CWRef(byte by, String string, String string2, String string3) {
            this.type = by;
            this.c = string;
            this.n = string2;
            this.t = string3;
        }

        public boolean equals(Object object) {
            if (object instanceof CWRef) {
                CWRef cWRef = (CWRef)object;
                return cWRef.type == this.type && cWRef.c.equals(this.c) && cWRef.n.equals(this.n) && cWRef.t.equals(this.t);
            }
            return false;
        }

        public int hashCode() {
            return this.type + (this.c.hashCode() << 5) + (this.n.hashCode() << 3) + this.t.hashCode();
        }

        byte getType() {
            return this.type;
        }
    }

    static class CWString
    extends CWItem {
        private final String s;

        CWString(String string) {
            this.s = string;
        }

        public boolean equals(Object object) {
            return object instanceof CWString && ((CWString)object).s.equals(this.s);
        }

        public int hashCode() {
            return this.s.hashCode() + 3901;
        }

        byte getType() {
            return 8;
        }
    }

    public static abstract class Element {
        public abstract int getSize();

        public abstract int copyInto(byte[] var1, int var2);
    }

    static final class MemberElement
    extends Element {
        private final int access;
        private final int name;
        private final int type;
        private final Element[] attributes;

        public MemberElement(int n, int n2, int n3, Element[] elementArray) {
            if (n < 0 || n > 65535) {
                throw new IllegalArgumentException("Access flags out of range: " + n);
            }
            if (n2 < 1 || n2 > 65535) {
                throw new IllegalArgumentException("Name constant pool index out of range: " + n2);
            }
            if (n3 < 1 || n3 > 65535) {
                throw new IllegalArgumentException("Type constant pool index out of range: " + n2);
            }
            if (elementArray == null) {
                throw new IllegalArgumentException("Atrtributes are null");
            }
            if (elementArray.length > 65535) {
                throw new IllegalArgumentException("Too many attributes: " + elementArray.length);
            }
            this.access = n;
            this.name = n2;
            this.type = n3;
            this.attributes = elementArray;
        }

        public int getSize() {
            int n = 8;
            if (this.attributes != null) {
                int n2 = 0;
                while (n2 < this.attributes.length) {
                    n += this.attributes[n2].getSize();
                    ++n2;
                }
            }
            return n;
        }

        public int copyInto(byte[] byArray, int n) {
            ClassWriter.setUShort(byArray, n, this.access);
            ClassWriter.setUShort(byArray, n + 2, this.name);
            ClassWriter.setUShort(byArray, n + 4, this.type);
            if (this.attributes != null) {
                ClassWriter.setUShort(byArray, n + 6, this.attributes.length);
                n += 8;
                int n2 = 0;
                while (n2 < this.attributes.length) {
                    n = this.attributes[n2].copyInto(byArray, n);
                    ++n2;
                }
            } else {
                ClassWriter.setUShort(byArray, n + 6, 0);
                n += 8;
            }
            return n;
        }
    }

    public static final class RawElement
    extends Element {
        private final byte[] buf;
        private final int offset;
        private final int len;

        public RawElement(byte[] byArray, int n, int n2) {
            this.buf = byArray;
            this.offset = n;
            this.len = n2;
        }

        public int getSize() {
            return this.len;
        }

        public int copyInto(byte[] byArray, int n) {
            System.arraycopy(this.buf, this.offset, byArray, n, this.len);
            return n + this.len;
        }
    }
}

