/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;

public abstract class AttributeReader {
    protected final ClassReader cr;
    protected final int attr;
    protected final int length;

    protected AttributeReader(ClassReader.AttrIterator attrIterator, String string) throws InvalidClassFileException {
        if (attrIterator == null) {
            throw new IllegalArgumentException("attr cannot be null");
        }
        attrIterator.verifyValid();
        this.cr = attrIterator.cr;
        this.attr = attrIterator.offset;
        this.length = attrIterator.size;
        String string2 = attrIterator.getName();
        if (string != string2 && !string.equals(string2)) {
            throw new IllegalArgumentException("Attribute " + string2 + " is not a " + string + " attribute");
        }
    }

    public final ClassReader getClassReader() {
        return this.cr;
    }

    public final int getRawOffset() {
        return this.attr;
    }

    public final int getRawSize() {
        return this.length;
    }

    protected final void checkSize(int n, int n2) throws InvalidClassFileException {
        if (this.length < n - this.attr + n2) {
            throw new InvalidClassFileException(n, "Attribute data too short, expected " + n2 + " bytes, got " + (this.length + this.attr - n));
        }
    }

    protected final void checkSizeEquals(int n, int n2) throws InvalidClassFileException {
        if (this.length != n - this.attr + n2) {
            throw new InvalidClassFileException(n, "Attribute data invalid length, expected " + n2 + " bytes, got " + (this.length + this.attr - n));
        }
    }
}

