/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

public abstract class OfflineInstrumenterBase {
    private int inputIndex;
    private final HashSet<String> entryNames = new HashSet();
    private final ArrayList<Input> inputs = new ArrayList();
    private final BitSet ignoringInputs = new BitSet();
    private File outputFile;
    private boolean passUnmodifiedClasses = false;
    private JarOutputStream outputJar;
    private JarFile cachedJar;
    private File cachedJarFile;
    private ManifestBuilder manifestBuilder;
    private static byte[] cachedBuf;

    public void setManifestBuilder(ManifestBuilder manifestBuilder) {
        this.manifestBuilder = manifestBuilder;
    }

    private JarFile openCachedJar(File file) throws IOException {
        if (this.cachedJarFile != null && this.cachedJarFile.equals(file)) {
            return this.cachedJar;
        }
        if (this.cachedJar != null) {
            this.cachedJar.close();
        }
        this.cachedJarFile = file;
        this.cachedJar = new JarFile(file);
        return this.cachedJar;
    }

    protected OfflineInstrumenterBase() {
    }

    public final void setOutputJar(File file) {
        this.outputFile = file;
    }

    public final void setPassUnmodifiedClasses(boolean bl) {
        this.passUnmodifiedClasses = bl;
    }

    public final void addInputJar(File file) throws IOException {
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (jarEntry.isDirectory()) continue;
            String string = jarEntry.getName();
            this.inputs.add(new JarInput(file, string));
        }
        jarFile.close();
    }

    public final void addInputJarEntry(File file, String string) throws IOException {
        this.inputs.add(new JarInput(file, string));
    }

    public final void addInputClass(File file) {
        this.inputs.add(new ClassInput(file));
    }

    public final void addInputDirectory(File file) throws IOException, IllegalArgumentException {
        if (file == null) {
            throw new IllegalArgumentException("d is null");
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".class");
            }
        });
        if (fileArray == null) {
            throw new IllegalArgumentException("bad directory " + file.getAbsolutePath());
        }
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            if (file2.isDirectory()) {
                this.addInputDirectory(file2);
            } else {
                this.addInputClass(file2);
            }
            ++n;
        }
    }

    public final boolean addInputElement(String string) throws IOException {
        block9: {
            block10: {
                File file;
                block8: {
                    block7: {
                        if (string == null) {
                            throw new IllegalArgumentException("a is null");
                        }
                        try {
                            int n = string.indexOf(35);
                            if (n <= 0) break block7;
                            this.addInputJarEntry(new File(string.substring(0, n)), string.substring(n + 1));
                            return true;
                        }
                        catch (IOException iOException) {
                            throw new IOException("Error reading input element '" + string + "': " + iOException.getMessage());
                        }
                    }
                    file = new File(string);
                    if (!file.isDirectory()) break block8;
                    this.addInputDirectory(file);
                    return true;
                }
                if (!file.exists()) break block9;
                if (!string.endsWith(".class")) break block10;
                this.addInputClass(file);
                return true;
            }
            if (string.endsWith(".jar") || string.endsWith(".zip")) {
                this.addInputJar(new File(string));
                return true;
            }
        }
        return false;
    }

    public final String[] parseStandardArgs(String[] stringArray) throws IllegalArgumentException, IOException {
        if (stringArray == null) {
            throw new IllegalArgumentException("args == null");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            block6: {
                String string;
                block8: {
                    block7: {
                        block5: {
                            string = stringArray[n];
                            if (string == null) {
                                throw new IllegalArgumentException("args[" + n + "] is null");
                            }
                            if (!string.equals("-o") || n + 1 >= stringArray.length) break block5;
                            this.setOutputJar(new File(stringArray[n + 1]));
                            ++n;
                            break block6;
                        }
                        if (string.startsWith("-")) break block7;
                        if (!this.addInputElement(string)) break block8;
                        break block6;
                    }
                    if (string.startsWith("--")) {
                        int n2 = n;
                        while (n2 < stringArray.length) {
                            arrayList.add(stringArray[n2]);
                            ++n2;
                        }
                        break;
                    }
                }
                arrayList.add(string);
            }
            ++n;
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    public final int getNumInputClasses() {
        return this.inputs.size();
    }

    public final void readInputClasses(InputStream inputStream) throws IOException, IllegalArgumentException {
        String string;
        if (inputStream == null) {
            throw new IllegalArgumentException("illegal null inputStream");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            this.addInputElement(string);
        }
    }

    public final void beginTraversal() {
        this.inputIndex = 0;
    }

    protected abstract Object makeClassFromStream(BufferedInputStream var1) throws IOException;

    protected abstract String getClassName(Object var1);

    protected abstract void writeClassTo(Object var1, Object var2, OutputStream var3) throws IOException;

    protected final Object internalNextClass() throws IOException {
        Input input;
        do {
            if (this.inputIndex >= this.inputs.size()) {
                return null;
            }
            input = this.inputs.get(this.inputIndex);
            ++this.inputIndex;
        } while (this.ignoringInputs.get(this.inputIndex - 1) || !input.isClass());
        BufferedInputStream bufferedInputStream = new BufferedInputStream(input.open());
        try {
            Object object = this.makeClassFromStream(bufferedInputStream);
            String string = this.getClassName(object);
            input.setClassName(string);
            Object object2 = object;
            return object2;
        }
        finally {
            bufferedInputStream.close();
        }
    }

    private static String toEntryName(String string) {
        return String.valueOf(string.replace('.', '/')) + ".class";
    }

    public final String getLastClassResourceName() {
        if (this.inputIndex < 1) {
            return null;
        }
        Input input = this.inputs.get(this.inputIndex - 1);
        return input.toString();
    }

    public final File getOutputFile() {
        return this.outputFile;
    }

    protected final boolean internalOutputModifiedClass(Object object, Object object2) throws IOException {
        this.makeOutputJar();
        String string = OfflineInstrumenterBase.toEntryName(this.getClassName(object));
        if (this.entryNames.contains(string)) {
            return false;
        }
        this.putNextEntry(new ZipEntry(string));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.outputJar);
        this.writeClassTo(object, object2, bufferedOutputStream);
        bufferedOutputStream.flush();
        this.outputJar.closeEntry();
        return true;
    }

    public final void setJARComment(String string) throws IOException, IllegalStateException {
        this.makeOutputJar();
        this.outputJar.setComment(string);
    }

    final void makeOutputJar() throws IOException, IllegalStateException {
        if (this.outputJar == null) {
            if (this.outputFile == null) {
                throw new IllegalStateException("Output file was not set");
            }
            this.outputJar = new JarOutputStream(new FileOutputStream(this.outputFile));
        }
    }

    public final void setIgnore(boolean bl) throws IllegalArgumentException {
        if (this.inputIndex == 0) {
            throw new IllegalArgumentException("Must get a class before ignoring it");
        }
        this.ignoringInputs.set(this.inputIndex - 1);
    }

    private static synchronized byte[] makeBuf() {
        if (cachedBuf != null) {
            byte[] byArray = cachedBuf;
            cachedBuf = null;
            return byArray;
        }
        return new byte[60000];
    }

    private static synchronized void releaseBuf(byte[] byArray) {
        cachedBuf = byArray;
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IllegalArgumentException, IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("in == null");
        }
        byte[] byArray = OfflineInstrumenterBase.makeBuf();
        try {
            while (true) {
                int n;
                if ((n = inputStream.read(byArray)) < 0) {
                    return;
                }
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            OfflineInstrumenterBase.releaseBuf(byArray);
        }
    }

    public final OutputStream addOutputJarEntry(ZipEntry zipEntry) throws IOException, IllegalStateException {
        if (this.outputJar == null) {
            throw new IllegalStateException("output jar is null");
        }
        this.putNextEntry(zipEntry);
        return this.outputJar;
    }

    public final void endOutputJarEntry() throws IOException, IllegalStateException {
        if (this.outputJar == null) {
            throw new IllegalStateException("output jar is null");
        }
        this.outputJar.closeEntry();
    }

    /*
     * Unable to fully structure code
     */
    public final void writeUnmodifiedClasses() throws IOException, IllegalStateException {
        this.passUnmodifiedClasses = false;
        this.makeOutputJar();
        var1_1 = 0;
        while (var1_1 < this.inputs.size()) {
            var2_2 = this.inputs.get(var1_1);
            if (!var2_2.isClass()) {
                if (var2_2 instanceof JarInput) {
                    var3_3 = (JarInput)var2_2;
                    var4_4 = var3_3.getEntry();
                    var5_5 = var3_3.open();
                    try {
                        var6_6 = new ZipEntry(var4_4.getName());
                        var6_6.setComment(var4_4.getComment());
                        var6_6.setExtra(var4_4.getExtra());
                        var6_6.setTime(var4_4.getTime());
                        this.putNextEntry((ZipEntry)var6_6);
                        OfflineInstrumenterBase.copyStream((InputStream)var5_5, this.outputJar);
                        this.outputJar.closeEntry();
                    }
                    finally {
                        var5_5.close();
                    }
                }
                throw new Error("Unknown non-class input: " + var2_2);
            }
            var3_3 = var2_2.getClassName();
            if (var3_3 == null) {
                var4_4 = new BufferedInputStream(var2_2.open(), 65536);
                try {
                    var5_5 = this.makeClassFromStream((BufferedInputStream)var4_4);
                    var6_6 = OfflineInstrumenterBase.toEntryName(this.getClassName(var5_5));
                    if (this.entryNames.contains(var6_6)) ** GOTO lbl53
                    this.putNextEntry(new ZipEntry((String)var6_6));
                    var7_7 = new BufferedOutputStream(this.outputJar);
                    this.writeClassTo(var5_5, null, var7_7);
                    var7_7.flush();
                    this.outputJar.closeEntry();
                }
                finally {
                    var4_4.close();
                }
            } else {
                var4_4 = OfflineInstrumenterBase.toEntryName((String)var3_3);
                if (!this.entryNames.contains(var4_4)) {
                    var5_5 = new BufferedInputStream(var2_2.open());
                    try {
                        this.putNextEntry(new ZipEntry((String)var4_4));
                        var6_6 = new BufferedOutputStream(this.outputJar);
                        OfflineInstrumenterBase.copyStream((InputStream)var5_5, (OutputStream)var6_6);
                        var6_6.flush();
                        this.outputJar.closeEntry();
                    }
                    finally {
                        var5_5.close();
                    }
                }
            }
            ++var1_1;
        }
    }

    public final void close() throws IOException, IllegalStateException {
        if (this.passUnmodifiedClasses) {
            this.writeUnmodifiedClasses();
        }
        if (this.outputJar != null) {
            this.outputJar.close();
        }
        if (this.cachedJar != null) {
            this.cachedJar.close();
        }
    }

    private void putNextEntry(ZipEntry zipEntry) throws IOException, IllegalStateException {
        if (this.outputJar == null) {
            throw new IllegalStateException();
        }
        this.outputJar.putNextEntry(zipEntry);
        this.entryNames.add(zipEntry.getName());
        if (this.manifestBuilder != null) {
            this.manifestBuilder.addEntry(zipEntry);
        }
    }

    final class ClassInput
    extends Input {
        private final File file;

        public ClassInput(File file) {
            this.file = file;
        }

        public InputStream open() throws IOException {
            return new FileInputStream(this.file);
        }

        public String toString() {
            return this.file.getPath();
        }
    }

    abstract class Input {
        private String className;

        Input() {
        }

        public final void setClassName(String string) {
            this.className = string.intern();
        }

        public final String getClassName() {
            return this.className;
        }

        public abstract InputStream open() throws IOException;

        public boolean isClass() {
            return true;
        }
    }

    final class JarInput
    extends Input {
        private final File file;
        private final String name;

        public JarInput(File file, String string) {
            this.file = file;
            this.name = string;
        }

        public InputStream open() throws IOException {
            JarFile jarFile = OfflineInstrumenterBase.this.openCachedJar(this.file);
            return jarFile.getInputStream(jarFile.getEntry(this.name));
        }

        public String toString() {
            return String.valueOf(this.file.getPath()) + "#" + this.name;
        }

        public boolean isClass() {
            return this.name.endsWith(".class");
        }

        public ZipEntry getEntry() throws IOException {
            JarFile jarFile = OfflineInstrumenterBase.this.openCachedJar(this.file);
            return jarFile.getEntry(this.name);
        }
    }

    public static interface ManifestBuilder {
        public void addEntry(ZipEntry var1);
    }
}

