/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.shrikeCT.tools;

import com.ibm.wala.shrikeBT.Constants;
import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeBT.Disassembler;
import com.ibm.wala.shrikeBT.shrikeCT.CTDecoder;
import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.CodeReader;
import com.ibm.wala.shrikeCT.ConstantPoolParser;
import com.ibm.wala.shrikeCT.ConstantValueReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrikeCT.LineNumberTableReader;
import com.ibm.wala.shrikeCT.LocalVariableTableReader;
import com.ibm.wala.shrikeCT.RuntimeInvisibleAnnotationsReader;
import com.ibm.wala.shrikeCT.RuntimeVisibleAnnotationsReader;
import com.ibm.wala.shrikeCT.SignatureReader;
import com.ibm.wala.shrikeCT.SourceFileReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;

public class ClassPrinter {
    private final PrintWriter w;
    private boolean printLineNumberInfo = true;
    private boolean printConstantPool = true;
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public ClassPrinter(PrintWriter printWriter) {
        this.w = printWriter;
    }

    public void setPrintLineNumberInfo(boolean bl) {
        this.printLineNumberInfo = bl;
    }

    public void setPrintConstantPool(boolean bl) {
        this.printConstantPool = bl;
    }

    public static void main(String[] stringArray) throws Exception {
        ClassInstrumenter classInstrumenter;
        OfflineInstrumenter offlineInstrumenter = new OfflineInstrumenter();
        stringArray = offlineInstrumenter.parseStandardArgs(stringArray);
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
        ClassPrinter classPrinter = new ClassPrinter(printWriter);
        offlineInstrumenter.beginTraversal();
        while ((classInstrumenter = offlineInstrumenter.nextClass()) != null) {
            try {
                classPrinter.doClass(classInstrumenter.getReader());
            }
            finally {
                printWriter.flush();
            }
        }
        offlineInstrumenter.close();
    }

    private static String makeHex(byte[] byArray, int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = n;
        while (n4 < n + n2) {
            byte by = byArray[n4];
            stringBuffer.append(hexChars[by >> 4 & 0xF]);
            stringBuffer.append(hexChars[by & 0xF]);
            ++n4;
        }
        while (stringBuffer.length() < n3) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private static String makeChars(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n;
        while (n3 < n + n2) {
            char c = (char)byArray[n3];
            if (c < ' ' || c > '\u007f') {
                stringBuffer.append('.');
            } else {
                stringBuffer.append(c);
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    private static String getClassName(ClassReader classReader, int n) throws InvalidClassFileException {
        if (n == 0) {
            return "any";
        }
        return classReader.getCP().getCPClass(n);
    }

    private static String dumpFlags(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        Class<Constants> clazz = Constants.class;
        Field[] fieldArray = clazz.getDeclaredFields();
        int n2 = 0;
        while (n2 < fieldArray.length) {
            String string = fieldArray[n2].getName();
            if (string.startsWith("ACC_")) {
                int n3;
                try {
                    n3 = fieldArray[n2].getInt(null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new Error(illegalArgumentException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new Error(illegalAccessException.getMessage());
                }
                if ((n & n3) != 0) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(string.substring(4).toLowerCase());
                }
            }
            ++n2;
        }
        return "0x" + Integer.toString(16, n) + "(" + stringBuffer.toString() + ")";
    }

    private void dumpAttributes(ClassReader classReader, int n, ClassReader.AttrIterator attrIterator) throws InvalidClassFileException, Decoder.InvalidBytecodeException, IOException {
        while (attrIterator.isValid()) {
            block34: {
                String string;
                block33: {
                    int n2;
                    block35: {
                        Object object;
                        int n3;
                        Object object2;
                        Object object3;
                        string = attrIterator.getName();
                        this.w.write("  " + string + ": @" + Integer.toString(attrIterator.getRawOffset(), 16) + "\n");
                        if (!string.equals("Code")) break block33;
                        CodeReader codeReader = new CodeReader(attrIterator);
                        this.w.write("    maxstack: " + codeReader.getMaxStack() + "\n");
                        this.w.write("    maxlocals: " + codeReader.getMaxLocals() + "\n");
                        this.w.write("    bytecode:\n");
                        int[] nArray = codeReader.getRawHandlers();
                        CTDecoder cTDecoder = new CTDecoder(codeReader);
                        cTDecoder.decode();
                        Disassembler disassembler = new Disassembler(cTDecoder.getInstructions(), cTDecoder.getHandlers(), cTDecoder.getInstructionsToBytecodes());
                        disassembler.disassembleTo("      ", this.w);
                        this.w.write("    exception handlers:\n");
                        int n4 = 0;
                        while (n4 < nArray.length) {
                            this.w.write("      " + nArray[n4] + " to " + nArray[n4 + 1] + " catch " + ClassPrinter.getClassName(classReader, nArray[n4 + 3]) + " at " + nArray[n4 + 2] + "\n");
                            n4 += 4;
                        }
                        ClassReader.AttrIterator attrIterator2 = new ClassReader.AttrIterator();
                        codeReader.initAttributeIterator(attrIterator2);
                        while (attrIterator2.isValid()) {
                            object3 = attrIterator2.getName();
                            this.w.write("    " + (String)object3 + ": " + Integer.toString(attrIterator2.getRawOffset(), 16) + "\n");
                            attrIterator2.advance();
                        }
                        if (this.printLineNumberInfo && (object3 = (Object)LineNumberTableReader.makeBytecodeToSourceMap(codeReader)) != null) {
                            this.w.write("    line number map:\n");
                            object2 = null;
                            n2 = 0;
                            n3 = 0;
                            while (n3 < ((Object)object3).length) {
                                object = "      " + n3 + ": " + (int)object3[n3];
                                if (object2 == null || object == null || !((String)object).substring(((String)object).indexOf(58)).equals(((String)object2).substring(((String)object2).indexOf(58)))) {
                                    if (n2 > 1) {
                                        this.w.write(" (" + n2 + " times)\n");
                                    } else if (n2 > 0) {
                                        this.w.write("\n");
                                    }
                                    n2 = 0;
                                    object2 = object;
                                    this.w.write((String)object2);
                                }
                                ++n2;
                                ++n3;
                            }
                            if (n2 > 1) {
                                this.w.write(" (" + n2 + " times)\n");
                            } else if (n2 > 0) {
                                this.w.write("\n");
                            }
                        }
                        if ((object3 = (Object)LocalVariableTableReader.makeVarMap(codeReader)) == null) break block34;
                        this.w.write("    local variable map:\n");
                        object2 = null;
                        n2 = 0;
                        n3 = 0;
                        while (n3 < ((Object)object3).length) {
                            object = object3[n3];
                            String string2 = null;
                            if (object != null) {
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("      " + n3 + ":");
                                int n5 = 0;
                                while (n5 < ((Object)object).length) {
                                    if (object[n5] != false) {
                                        String string3 = String.valueOf(classReader.getCP().getCPUtf8((int)object[n5])) + "(" + classReader.getCP().getCPUtf8((int)object[n5 + 1]) + ")";
                                        stringBuffer.append(" " + n5 / 2 + ":" + string3);
                                    }
                                    n5 += 2;
                                }
                                string2 = stringBuffer.toString();
                            }
                            if (object2 == null || string2 == null || !string2.substring(string2.indexOf(58)).equals(((String)object2).substring(((String)object2).indexOf(58)))) {
                                if (n2 > 1) {
                                    this.w.write(" (" + n2 + " times)\n");
                                } else if (n2 > 0) {
                                    this.w.write("\n");
                                }
                                n2 = 0;
                                object2 = string2;
                                if (object2 != null) {
                                    this.w.write((String)object2);
                                }
                            }
                            if (object2 != null) {
                                ++n2;
                            }
                            ++n3;
                        }
                        if (n2 <= true) break block35;
                        this.w.write(" (" + n2 + " times)\n");
                        break block34;
                    }
                    if (n2 <= 0) break block34;
                    this.w.write("\n");
                    break block34;
                }
                if (string.equals("ConstantValue")) {
                    ConstantValueReader constantValueReader = new ConstantValueReader(attrIterator);
                    this.w.write("    value: " + ClassPrinter.getCPItemString(classReader.getCP(), constantValueReader.getValueCPIndex()) + "\n");
                } else if (string.equals("SourceFile")) {
                    SourceFileReader sourceFileReader = new SourceFileReader(attrIterator);
                    this.w.write("    file: " + classReader.getCP().getCPUtf8(sourceFileReader.getSourceFileCPIndex()) + "\n");
                } else if (string.equals("Signature")) {
                    SignatureReader signatureReader = new SignatureReader(attrIterator);
                    this.w.write("    signature: " + classReader.getCP().getCPUtf8(signatureReader.getSignatureCPIndex()) + "\n");
                } else if (string.equals("RuntimeInvisibleAnnotations")) {
                    RuntimeInvisibleAnnotationsReader runtimeInvisibleAnnotationsReader = new RuntimeInvisibleAnnotationsReader(attrIterator);
                    this.printAnnotations(classReader, attrIterator, runtimeInvisibleAnnotationsReader);
                } else if (string.equals("RuntimeVisibleAnnotations")) {
                    RuntimeVisibleAnnotationsReader runtimeVisibleAnnotationsReader = new RuntimeVisibleAnnotationsReader(attrIterator);
                    this.printAnnotations(classReader, attrIterator, runtimeVisibleAnnotationsReader);
                } else {
                    int n6 = attrIterator.getDataSize();
                    int n7 = attrIterator.getDataOffset();
                    while (n6 > 0) {
                        int n8 = Math.min(16, n6);
                        this.w.write("    " + ClassPrinter.makeHex(classReader.getBytes(), n7, n8, 32) + " " + ClassPrinter.makeChars(classReader.getBytes(), n7, n8) + "\n");
                        n6 -= n8;
                        n7 += n8;
                    }
                }
            }
            attrIterator.advance();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void printAnnotations(ClassReader var1_1, ClassReader.AttrIterator var2_2, AnnotationsReader var3_3) throws InvalidClassFileException {
        block4: {
            try {
                var8_6 = var4_4 = var3_3.getAnnotationOffsets();
                var7_7 = var4_4.length;
                var6_8 = 0;
                while (var6_8 < var7_7) {
                    var5_10 = var8_6[var6_8];
                    this.w.write("    Annotation type: " + var3_3.getAnnotationType(var5_10) + "\n");
                    ++var6_8;
                }
                break block4;
            }
            catch (AnnotationsReader.UnimplementedException v0) {
                var4_5 = var2_2.getDataSize();
                var5_11 = var2_2.getDataOffset();
                ** while (var4_5 > 0)
            }
lbl-1000:
            // 1 sources

            {
                var6_9 = Math.min(16, var4_5);
                this.w.write("    " + ClassPrinter.makeHex(var1_1.getBytes(), var5_11, var6_9, 32) + " " + ClassPrinter.makeChars(var1_1.getBytes(), var5_11, var6_9) + "\n");
                var4_5 -= var6_9;
                var5_11 += var6_9;
                continue;
            }
        }
    }

    private static String getCPItemString(ConstantPoolParser constantPoolParser, int n) throws InvalidClassFileException {
        byte by = constantPoolParser.getItemType(n);
        switch (by) {
            case 1: {
                return "Utf8 " + ClassPrinter.quoteString(constantPoolParser.getCPUtf8(n));
            }
            case 7: {
                return "Class " + constantPoolParser.getCPClass(n);
            }
            case 8: {
                return "String " + ClassPrinter.quoteString(constantPoolParser.getCPString(n));
            }
            case 3: {
                return "Integer " + constantPoolParser.getCPInt(n);
            }
            case 4: {
                return "Float " + constantPoolParser.getCPFloat(n);
            }
            case 6: {
                return "Double " + constantPoolParser.getCPDouble(n);
            }
            case 5: {
                return "Long " + constantPoolParser.getCPLong(n);
            }
            case 10: {
                return "Method " + constantPoolParser.getCPRefClass(n) + " " + constantPoolParser.getCPRefName(n) + " " + constantPoolParser.getCPRefType(n);
            }
            case 9: {
                return "Field " + constantPoolParser.getCPRefClass(n) + " " + constantPoolParser.getCPRefName(n) + " " + constantPoolParser.getCPRefType(n);
            }
            case 11: {
                return "InterfaceMethod " + constantPoolParser.getCPRefClass(n) + " " + constantPoolParser.getCPRefName(n) + " " + constantPoolParser.getCPRefType(n);
            }
            case 12: {
                return "NameAndType " + constantPoolParser.getCPNATType(n) + " " + constantPoolParser.getCPNATName(n);
            }
        }
        return "Unknown type " + by;
    }

    private static String quoteString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                default: {
                    if (c >= ' ' && c <= '\u007f') {
                        stringBuffer.append(c);
                        break;
                    }
                    stringBuffer.append("\\u");
                    String string2 = ClassPrinter.makeHex(new byte[]{(byte)(c >> 8), (byte)c}, 0, 2, 0);
                    int n2 = 4 - string2.length();
                    while (n2 > 0) {
                        stringBuffer.append('0');
                        --n2;
                    }
                    stringBuffer.append(string2);
                }
            }
            ++n;
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public void doClass(ClassReader classReader) throws InvalidClassFileException, Decoder.InvalidBytecodeException, IOException {
        int n;
        int n2;
        Object object;
        if (classReader == null) {
            throw new IllegalArgumentException("cr is null");
        }
        this.w.write("Class: " + classReader.getName() + "\n");
        if (this.printConstantPool) {
            object = classReader.getCP();
            n2 = 1;
            while (n2 < ((ConstantPoolParser)object).getItemCount()) {
                n = ((ConstantPoolParser)object).getItemType(n2);
                if (n > 0) {
                    this.w.write("  Constant pool item " + n2 + ": ");
                    this.w.write(ClassPrinter.getCPItemString((ConstantPoolParser)object, n2));
                    this.w.write("\n");
                }
                ++n2;
            }
        }
        object = new ClassReader.AttrIterator();
        classReader.initClassAttributeIterator((ClassReader.AttrIterator)object);
        this.dumpAttributes(classReader, 0, (ClassReader.AttrIterator)object);
        this.w.write("\n");
        n2 = classReader.getFieldCount();
        this.w.write(String.valueOf(n2) + " fields:\n");
        n = 0;
        while (n < n2) {
            this.w.write(String.valueOf(classReader.getFieldName(n)) + " " + classReader.getFieldType(n) + " " + ClassPrinter.dumpFlags(classReader.getFieldAccessFlags(n)) + "\n");
            classReader.initFieldAttributeIterator(n, (ClassReader.AttrIterator)object);
            this.dumpAttributes(classReader, n, (ClassReader.AttrIterator)object);
            ++n;
        }
        this.w.write("\n");
        n = classReader.getMethodCount();
        this.w.write(String.valueOf(n) + " methods:\n");
        int n3 = 0;
        while (n3 < n) {
            this.w.write(String.valueOf(classReader.getMethodName(n3)) + " " + classReader.getMethodType(n3) + " " + ClassPrinter.dumpFlags(classReader.getMethodAccessFlags(n3)) + "\n");
            classReader.initMethodAttributeIterator(n3, (ClassReader.AttrIterator)object);
            this.dumpAttributes(classReader, n3, (ClassReader.AttrIterator)object);
            ++n3;
        }
        this.w.write("\n");
    }
}

