/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.shrikeCT;

import com.ibm.wala.shrikeBT.ConstantPoolReader;
import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.CodeReader;
import com.ibm.wala.shrikeCT.ConstantPoolParser;
import com.ibm.wala.shrikeCT.InvalidClassFileException;

public final class CTDecoder
extends Decoder {
    public CTDecoder(CodeReader codeReader) throws NullPointerException {
        this(codeReader, CTDecoder.makeConstantPoolReader(codeReader.getClassReader()));
    }

    public CTDecoder(CodeReader codeReader, ConstantPoolReader constantPoolReader) throws NullPointerException {
        super(codeReader.getBytecode(), codeReader.getRawHandlers(), constantPoolReader);
    }

    public static String convertClassToType(String string) {
        if (string == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (string.length() > 0 && string.charAt(0) != '[') {
            return "L" + string + ";";
        }
        return string;
    }

    public static ConstantPoolReader makeConstantPoolReader(ClassReader classReader) throws IllegalArgumentException {
        if (classReader == null) {
            throw new IllegalArgumentException("illegal null cr");
        }
        return new CPReader(classReader.getCP());
    }

    static final class CPReader
    extends ConstantPoolReader {
        private final ConstantPoolParser cp;

        CPReader(ConstantPoolParser constantPoolParser) {
            this.cp = constantPoolParser;
        }

        public int getConstantPoolItemType(int n) {
            return this.cp.getItemType(n);
        }

        private Error convertToError(InvalidClassFileException invalidClassFileException) {
            invalidClassFileException.printStackTrace();
            return new Error("Invalid class file: " + invalidClassFileException.getMessage());
        }

        public int getConstantPoolInteger(int n) {
            try {
                return this.cp.getCPInt(n);
            }
            catch (InvalidClassFileException invalidClassFileException) {
                throw this.convertToError(invalidClassFileException);
            }
        }

        public float getConstantPoolFloat(int n) {
            try {
                return this.cp.getCPFloat(n);
            }
            catch (InvalidClassFileException invalidClassFileException) {
                throw this.convertToError(invalidClassFileException);
            }
        }

        public long getConstantPoolLong(int n) {
            try {
                return this.cp.getCPLong(n);
            }
            catch (InvalidClassFileException invalidClassFileException) {
                throw this.convertToError(invalidClassFileException);
            }
        }

        public double getConstantPoolDouble(int n) {
            try {
                return this.cp.getCPDouble(n);
            }
            catch (InvalidClassFileException invalidClassFileException) {
                throw this.convertToError(invalidClassFileException);
            }
        }

        public String getConstantPoolString(int n) {
            try {
                return this.cp.getCPString(n);
            }
            catch (InvalidClassFileException invalidClassFileException) {
                throw this.convertToError(invalidClassFileException);
            }
        }

        public String getConstantPoolClassType(int n) {
            try {
                return CTDecoder.convertClassToType(this.cp.getCPClass(n));
            }
            catch (InvalidClassFileException invalidClassFileException) {
                throw this.convertToError(invalidClassFileException);
            }
        }

        public String getConstantPoolMemberClassType(int n) {
            try {
                return CTDecoder.convertClassToType(this.cp.getCPRefClass(n));
            }
            catch (InvalidClassFileException invalidClassFileException) {
                throw this.convertToError(invalidClassFileException);
            }
        }

        public String getConstantPoolMemberName(int n) {
            try {
                return this.cp.getCPRefName(n);
            }
            catch (InvalidClassFileException invalidClassFileException) {
                throw this.convertToError(invalidClassFileException);
            }
        }

        public String getConstantPoolMemberType(int n) {
            try {
                return this.cp.getCPRefType(n);
            }
            catch (InvalidClassFileException invalidClassFileException) {
                throw this.convertToError(invalidClassFileException);
            }
        }
    }
}

