/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.shrikeCT;

import com.ibm.wala.shrikeBT.Compiler;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeCT.ClassWriter;
import java.util.Random;

public final class CTCompiler
extends Compiler {
    private final ClassWriter cw;
    private final Random random = new Random();

    private CTCompiler(ClassWriter classWriter, MethodData methodData) {
        super(methodData);
        this.cw = classWriter;
    }

    protected int allocateConstantPoolInteger(int n) {
        return this.cw.addCPInt(n);
    }

    protected int allocateConstantPoolFloat(float f) {
        return this.cw.addCPFloat(f);
    }

    protected int allocateConstantPoolLong(long l) {
        return this.cw.addCPLong(l);
    }

    protected int allocateConstantPoolDouble(double d) {
        return this.cw.addCPDouble(d);
    }

    protected int allocateConstantPoolString(String string) {
        return this.cw.addCPString(string);
    }

    protected int allocateConstantPoolClassType(String string) {
        return this.cw.addCPClass(CTCompiler.convertTypeToClass(string));
    }

    public static String convertTypeToClass(String string) {
        if (string == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (string.length() > 0 && string.charAt(0) == 'L') {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static CTCompiler make(ClassWriter classWriter, MethodData methodData) {
        if (methodData == null) {
            throw new IllegalArgumentException("md is null");
        }
        return new CTCompiler(classWriter, methodData);
    }

    protected int allocateConstantPoolField(String string, String string2, String string3) {
        return this.cw.addCPFieldRef(CTCompiler.convertTypeToClass(string), string2, string3);
    }

    protected int allocateConstantPoolMethod(String string, String string2, String string3) {
        return this.cw.addCPMethodRef(CTCompiler.convertTypeToClass(string), string2, string3);
    }

    protected int allocateConstantPoolInterfaceMethod(String string, String string2, String string3) {
        return this.cw.addCPInterfaceMethodRef(CTCompiler.convertTypeToClass(string), string2, string3);
    }

    protected String createHelperMethod(boolean bl, String string) {
        long l = Math.abs(this.random.nextLong());
        String string2 = "_helper_" + l;
        return string2;
    }
}

