/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.info;

import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.ILoadInstruction;
import com.ibm.wala.shrikeBT.IStoreInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.Util;

public class LocalAllocator
implements MethodData.Results {
    private static final String key = LocalAllocator.class.getName();
    private int nextLocal;

    LocalAllocator(MethodData methodData) {
        this.recalculateFrom(methodData);
    }

    private void recalculateFrom(MethodData methodData) {
        IInstruction[] iInstructionArray = methodData.getInstructions();
        final int[] nArray = new int[]{Util.getParamsWordSize(methodData.getSignature()) + (methodData.getIsStatic() ? 0 : 1)};
        IInstruction.Visitor visitor = new IInstruction.Visitor(){

            public void visitLocalLoad(ILoadInstruction iLoadInstruction) {
                int n = iLoadInstruction.getVarIndex() + Util.getWordSize(iLoadInstruction.getType());
                if (n > nArray[0]) {
                    nArray[0] = n;
                }
            }

            public void visitLocalStore(IStoreInstruction iStoreInstruction) {
                int n = iStoreInstruction.getVarIndex() + Util.getWordSize(iStoreInstruction.getType());
                if (n > nArray[0]) {
                    nArray[0] = n;
                }
            }
        };
        int n = 0;
        while (n < iInstructionArray.length) {
            iInstructionArray[n].visit(visitor);
            ++n;
        }
        this.nextLocal = nArray[0];
    }

    private int allocateLocals(int n) {
        int n2 = this.nextLocal;
        this.nextLocal += n;
        return n2;
    }

    public boolean notifyUpdate(MethodData methodData, IInstruction[] iInstructionArray, ExceptionHandler[][] exceptionHandlerArray, int[] nArray) {
        return false;
    }

    public static int allocate(MethodData methodData, int n) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        LocalAllocator localAllocator = (LocalAllocator)methodData.getInfo(key);
        if (localAllocator == null) {
            localAllocator = new LocalAllocator(methodData);
            methodData.putInfo(key, localAllocator);
        }
        return localAllocator.allocateLocals(n);
    }

    public static int allocate(MethodData methodData, String string) throws IllegalArgumentException {
        return LocalAllocator.allocate(methodData, string == null ? 2 : (int)Util.getWordSize(string));
    }

    public static int allocate(MethodData methodData) throws IllegalArgumentException {
        return LocalAllocator.allocate(methodData, null);
    }
}

