/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.info;

import com.ibm.wala.shrikeBT.ArrayLengthInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.GotoInstruction;
import com.ibm.wala.shrikeBT.IArrayLoadInstruction;
import com.ibm.wala.shrikeBT.IArrayStoreInstruction;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IComparisonInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IConversionInstruction;
import com.ibm.wala.shrikeBT.IGetInstruction;
import com.ibm.wala.shrikeBT.IInstanceofInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.ILoadInstruction;
import com.ibm.wala.shrikeBT.IPutInstruction;
import com.ibm.wala.shrikeBT.IShiftInstruction;
import com.ibm.wala.shrikeBT.IStoreInstruction;
import com.ibm.wala.shrikeBT.ITypeTestInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.MonitorInstruction;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeBT.PopInstruction;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeBT.SwapInstruction;
import com.ibm.wala.shrikeBT.SwitchInstruction;
import com.ibm.wala.shrikeBT.ThrowInstruction;

public class InstructionTypeCounter
implements MethodData.Results {
    private static final String key = InstructionTypeCounter.class.getName();
    private int countMonitors;
    private int countGets;
    private int countPuts;
    private int countArrayLoads;
    private int countArrayStores;
    private int countInvokes;
    private int countArrayLengths;
    private int countBinaryOps;
    private int countCheckCasts;
    private int countComparisons;
    private int countConditionalBranches;
    private int countConstants;
    private int countConversions;
    private int countDups;
    private int countGotos;
    private int countInstanceOfs;
    private int countLocalLoads;
    private int countLocalStores;
    private int countNews;
    private int countPops;
    private int countReturns;
    private int countShifts;
    private int countSwaps;
    private int countSwitches;
    private int countThrows;
    private int countUnaryOps;

    InstructionTypeCounter(MethodData methodData) {
        this.recalculateFrom(methodData.getInstructions());
    }

    private void recalculateFrom(IInstruction[] iInstructionArray) {
        this.countMonitors = 0;
        this.countGets = 0;
        this.countPuts = 0;
        this.countArrayLoads = 0;
        this.countArrayStores = 0;
        this.countInvokes = 0;
        this.countArrayLengths = 0;
        this.countBinaryOps = 0;
        this.countCheckCasts = 0;
        this.countComparisons = 0;
        this.countConditionalBranches = 0;
        this.countConstants = 0;
        this.countConversions = 0;
        this.countDups = 0;
        this.countGotos = 0;
        this.countInstanceOfs = 0;
        this.countLocalLoads = 0;
        this.countLocalStores = 0;
        this.countNews = 0;
        this.countPops = 0;
        this.countReturns = 0;
        this.countShifts = 0;
        this.countSwaps = 0;
        this.countSwitches = 0;
        this.countThrows = 0;
        this.countUnaryOps = 0;
        IInstruction.Visitor visitor = new IInstruction.Visitor(){

            public void visitArrayLength(ArrayLengthInstruction arrayLengthInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countArrayLengths = instructionTypeCounter.countArrayLengths + 1;
            }

            public void visitBinaryOp(IBinaryOpInstruction iBinaryOpInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countBinaryOps = instructionTypeCounter.countBinaryOps + 1;
            }

            public void visitCheckCast(ITypeTestInstruction iTypeTestInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countCheckCasts = instructionTypeCounter.countCheckCasts + 1;
            }

            public void visitComparison(IComparisonInstruction iComparisonInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countComparisons = instructionTypeCounter.countComparisons + 1;
            }

            public void visitConditionalBranch(IConditionalBranchInstruction iConditionalBranchInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countConditionalBranches = instructionTypeCounter.countConditionalBranches + 1;
            }

            public void visitConstant(ConstantInstruction constantInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countConstants = instructionTypeCounter.countConstants + 1;
            }

            public void visitConversion(IConversionInstruction iConversionInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countConversions = instructionTypeCounter.countConversions + 1;
            }

            public void visitDup(DupInstruction dupInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countDups = instructionTypeCounter.countDups + 1;
            }

            public void visitGoto(GotoInstruction gotoInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countGotos = instructionTypeCounter.countGotos + 1;
            }

            public void visitInstanceof(IInstanceofInstruction iInstanceofInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countInstanceOfs = instructionTypeCounter.countInstanceOfs + 1;
            }

            public void visitLocalLoad(ILoadInstruction iLoadInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countLocalLoads = instructionTypeCounter.countLocalLoads + 1;
            }

            public void visitLocalStore(IStoreInstruction iStoreInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countLocalStores = instructionTypeCounter.countLocalStores + 1;
            }

            public void visitNew(NewInstruction newInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countNews = instructionTypeCounter.countNews + 1;
            }

            public void visitPop(PopInstruction popInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countPops = instructionTypeCounter.countPops + 1;
            }

            public void visitReturn(ReturnInstruction returnInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countReturns = instructionTypeCounter.countReturns + 1;
            }

            public void visitShift(IShiftInstruction iShiftInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countShifts = instructionTypeCounter.countShifts + 1;
            }

            public void visitSwap(SwapInstruction swapInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countSwaps = instructionTypeCounter.countSwaps + 1;
            }

            public void visitSwitch(SwitchInstruction switchInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countSwitches = instructionTypeCounter.countSwitches + 1;
            }

            public void visitThrow(ThrowInstruction throwInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countThrows = instructionTypeCounter.countThrows + 1;
            }

            public void visitUnaryOp(IUnaryOpInstruction iUnaryOpInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countUnaryOps = instructionTypeCounter.countUnaryOps + 1;
            }

            public void visitArrayLoad(IArrayLoadInstruction iArrayLoadInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countArrayLoads = instructionTypeCounter.countArrayLoads + 1;
            }

            public void visitArrayStore(IArrayStoreInstruction iArrayStoreInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countArrayStores = instructionTypeCounter.countArrayStores + 1;
            }

            public void visitGet(IGetInstruction iGetInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countGets = instructionTypeCounter.countGets + 1;
            }

            public void visitPut(IPutInstruction iPutInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countPuts = instructionTypeCounter.countPuts + 1;
            }

            public void visitMonitor(MonitorInstruction monitorInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countMonitors = instructionTypeCounter.countMonitors + 1;
            }

            public void visitInvoke(IInvokeInstruction iInvokeInstruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countInvokes = instructionTypeCounter.countInvokes + 1;
            }
        };
        int n = 0;
        while (n < iInstructionArray.length) {
            iInstructionArray[n].visit(visitor);
            ++n;
        }
    }

    public boolean notifyUpdate(MethodData methodData, IInstruction[] iInstructionArray, ExceptionHandler[][] exceptionHandlerArray, int[] nArray) {
        return true;
    }

    public static int getArrayLoadCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countArrayLoads;
    }

    public static int getArrayStoreCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countArrayStores;
    }

    public static int getGetCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countGets;
    }

    public static int getPutCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countPuts;
    }

    public static int getMonitorCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countMonitors;
    }

    public static int getInvokeCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countInvokes;
    }

    public static int getComparisonCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countComparisons;
    }

    public static int getArrayLengthCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countArrayLengths;
    }

    public static int getConstantCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countConstants;
    }

    public static int getShiftCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countShifts;
    }

    public static int getSwitchesCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countSwitches;
    }

    public static int getSwapCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countSwaps;
    }

    public static int getBinaryOpCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countBinaryOps;
    }

    public static int getCheckCastCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countCheckCasts;
    }

    public static int getThrowCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countThrows;
    }

    public static int getConditionalBranchCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countConditionalBranches;
    }

    public static int getConversionCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countConversions;
    }

    public static int getDupCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countDups;
    }

    public static int getGotoCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countGotos;
    }

    public static int getReturnCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countReturns;
    }

    public static int getInstanceOfCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countInstanceOfs;
    }

    public static int getLocalLoadCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countLocalLoads;
    }

    public static int getLocalStoreCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countLocalStores;
    }

    public static int getNewCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countNews;
    }

    public static int getPopCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countPops;
    }

    public static int getUnaryOpCount(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)methodData).countUnaryOps;
    }

    private static InstructionTypeCounter getCounter(MethodData methodData) {
        InstructionTypeCounter instructionTypeCounter = (InstructionTypeCounter)methodData.getInfo(key);
        if (instructionTypeCounter == null) {
            instructionTypeCounter = new InstructionTypeCounter(methodData);
            methodData.putInfo(key, instructionTypeCounter);
        }
        return instructionTypeCounter;
    }
}

