/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.analysis;

import com.ibm.wala.shrikeBT.ArrayLengthInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.GotoInstruction;
import com.ibm.wala.shrikeBT.IArrayLoadInstruction;
import com.ibm.wala.shrikeBT.IArrayStoreInstruction;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IComparisonInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IConversionInstruction;
import com.ibm.wala.shrikeBT.IGetInstruction;
import com.ibm.wala.shrikeBT.IInstanceofInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.ILoadInstruction;
import com.ibm.wala.shrikeBT.IPutInstruction;
import com.ibm.wala.shrikeBT.IShiftInstruction;
import com.ibm.wala.shrikeBT.IStoreInstruction;
import com.ibm.wala.shrikeBT.ITypeTestInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.MonitorInstruction;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeBT.PopInstruction;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeBT.SwitchInstruction;
import com.ibm.wala.shrikeBT.ThrowInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.analysis.Analyzer;
import java.util.BitSet;
import java.util.List;

public final class Verifier
extends Analyzer {
    public Verifier(boolean bl, String string, String string2, IInstruction[] iInstructionArray, ExceptionHandler[][] exceptionHandlerArray) {
        super(bl, string, string2, iInstructionArray, exceptionHandlerArray);
    }

    public Verifier(MethodData methodData) throws NullPointerException {
        super(methodData);
    }

    public void verify() throws Analyzer.FailureException {
        VerifyVisitor verifyVisitor = new VerifyVisitor();
        this.computeTypes(verifyVisitor, this.getBasicBlockStarts(), true);
        verifyVisitor.checkError();
    }

    public void verifyCollectAll() throws Analyzer.FailureException {
        VerifyVisitor verifyVisitor = new VerifyVisitor();
        BitSet bitSet = new BitSet(this.instructions.length);
        bitSet.set(0, this.instructions.length);
        this.computeTypes(verifyVisitor, bitSet, true);
        verifyVisitor.checkError();
    }

    public void computeTypes() throws Analyzer.FailureException {
        this.computeTypes(null, this.getBasicBlockStarts(), false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class VerifyVisitor
    extends Analyzer.TypeVisitor {
        private int curIndex;
        private List<Analyzer.PathElement> curPath;
        private Analyzer.FailureException ex;
        private String[] curStack;
        private String[] curLocals;

        VerifyVisitor() {
        }

        @Override
        public void setState(int n, List<Analyzer.PathElement> list, String[] stringArray, String[] stringArray2) {
            this.curIndex = n;
            this.curPath = list;
            this.curStack = stringArray;
            this.curLocals = stringArray2;
        }

        @Override
        public boolean shouldContinue() {
            return this.ex == null;
        }

        void checkError() throws Analyzer.FailureException {
            if (this.ex != null) {
                throw this.ex;
            }
        }

        private void checkStackSubtype(int n, String string) {
            if (!Verifier.this.isSubtypeOf(this.curStack[n], Util.getStackType(string))) {
                this.ex = new Analyzer.FailureException(this.curIndex, "Expected type " + string + " at stack " + n + ", got " + this.curStack[n], this.curPath);
            }
        }

        private void checkArrayStackSubtype(int n, String string) {
            if (!string.equals("B") || !"[Z".equals(this.curStack[n])) {
                this.checkStackSubtype(n, Util.makeArray(string));
            }
        }

        @Override
        public void visitConstant(ConstantInstruction constantInstruction) {
            constantInstruction.getValue();
        }

        @Override
        public void visitGoto(GotoInstruction gotoInstruction) {
        }

        @Override
        public void visitLocalLoad(ILoadInstruction iLoadInstruction) {
            String string = this.curLocals[iLoadInstruction.getVarIndex()];
            if (string == null) {
                this.ex = new Analyzer.FailureException(this.curIndex, "Local variable " + iLoadInstruction.getVarIndex() + " is not defined", this.curPath);
            }
            if (!Verifier.this.isSubtypeOf(string, iLoadInstruction.getType())) {
                this.ex = new Analyzer.FailureException(this.curIndex, "Expected type " + iLoadInstruction.getType() + " for local " + iLoadInstruction.getVarIndex() + ", got " + string, this.curPath);
            }
        }

        @Override
        public void visitLocalStore(IStoreInstruction iStoreInstruction) {
            this.checkStackSubtype(0, iStoreInstruction.getType());
        }

        @Override
        public void visitArrayLoad(IArrayLoadInstruction iArrayLoadInstruction) {
            this.checkStackSubtype(0, "I");
            this.checkArrayStackSubtype(1, iArrayLoadInstruction.getType());
        }

        @Override
        public void visitArrayStore(IArrayStoreInstruction iArrayStoreInstruction) {
            this.checkStackSubtype(0, iArrayStoreInstruction.getType());
            this.checkStackSubtype(1, "I");
            this.checkArrayStackSubtype(2, iArrayStoreInstruction.getType());
        }

        @Override
        public void visitPop(PopInstruction popInstruction) {
        }

        @Override
        public void visitDup(DupInstruction dupInstruction) {
        }

        @Override
        public void visitBinaryOp(IBinaryOpInstruction iBinaryOpInstruction) {
            this.checkStackSubtype(0, iBinaryOpInstruction.getType());
            this.checkStackSubtype(1, iBinaryOpInstruction.getType());
        }

        @Override
        public void visitUnaryOp(IUnaryOpInstruction iUnaryOpInstruction) {
            this.checkStackSubtype(0, iUnaryOpInstruction.getType());
        }

        @Override
        public void visitShift(IShiftInstruction iShiftInstruction) {
            this.checkStackSubtype(0, "I");
            this.checkStackSubtype(1, iShiftInstruction.getType());
        }

        @Override
        public void visitConversion(IConversionInstruction iConversionInstruction) {
            this.checkStackSubtype(0, iConversionInstruction.getFromType());
        }

        @Override
        public void visitComparison(IComparisonInstruction iComparisonInstruction) {
            this.checkStackSubtype(0, iComparisonInstruction.getType());
            this.checkStackSubtype(1, iComparisonInstruction.getType());
        }

        @Override
        public void visitConditionalBranch(IConditionalBranchInstruction iConditionalBranchInstruction) {
            this.checkStackSubtype(0, iConditionalBranchInstruction.getType());
            this.checkStackSubtype(1, iConditionalBranchInstruction.getType());
        }

        @Override
        public void visitSwitch(SwitchInstruction switchInstruction) {
            this.checkStackSubtype(0, "I");
        }

        @Override
        public void visitReturn(ReturnInstruction returnInstruction) {
            if (returnInstruction.getType() != "V") {
                this.checkStackSubtype(0, returnInstruction.getType());
                this.checkStackSubtype(0, Util.getReturnType(Verifier.this.signature));
            }
        }

        @Override
        public void visitGet(IGetInstruction iGetInstruction) {
            String string = iGetInstruction.getClassType();
            if (!iGetInstruction.isStatic()) {
                this.checkStackSubtype(0, string);
            }
        }

        @Override
        public void visitPut(IPutInstruction iPutInstruction) {
            String string = iPutInstruction.getClassType();
            String string2 = iPutInstruction.getFieldType();
            this.checkStackSubtype(0, string2);
            if (!iPutInstruction.isStatic()) {
                this.checkStackSubtype(1, string);
            }
        }

        @Override
        public void visitInvoke(IInvokeInstruction iInvokeInstruction) {
            String string = iInvokeInstruction.getClassType();
            String string2 = iInvokeInstruction.getMethodSignature();
            String string3 = iInvokeInstruction.getInvocationCode() == IInvokeInstruction.Dispatch.STATIC ? null : string;
            String[] stringArray = Util.getParamsTypes(string3, string2);
            int n = 0;
            while (n < stringArray.length) {
                this.checkStackSubtype(n, stringArray[stringArray.length - 1 - n]);
                ++n;
            }
        }

        @Override
        public void visitNew(NewInstruction newInstruction) {
            int n = 0;
            while (n < newInstruction.getArrayBoundsCount()) {
                this.checkStackSubtype(n, "I");
                ++n;
            }
            newInstruction.getType();
        }

        @Override
        public void visitArrayLength(ArrayLengthInstruction arrayLengthInstruction) {
            if (!this.curStack[0].equals("L;") && !Util.isArrayType(this.curStack[0])) {
                this.ex = new Analyzer.FailureException(this.curIndex, "Expected array type at stack 0, got " + this.curStack[0], this.curPath);
            }
        }

        @Override
        public void visitThrow(ThrowInstruction throwInstruction) {
            this.checkStackSubtype(0, "Ljava/lang/Throwable;");
        }

        @Override
        public void visitMonitor(MonitorInstruction monitorInstruction) {
            this.checkStackSubtype(0, "Ljava/lang/Object;");
        }

        @Override
        public void visitCheckCast(ITypeTestInstruction iTypeTestInstruction) {
            this.checkStackSubtype(0, "Ljava/lang/Object;");
            iTypeTestInstruction.getTypes();
        }

        @Override
        public void visitInstanceof(IInstanceofInstruction iInstanceofInstruction) {
            this.checkStackSubtype(0, "Ljava/lang/Object;");
            iInstanceofInstruction.getType();
        }
    }
}

