/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.analysis;

import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.ILoadInstruction;
import com.ibm.wala.shrikeBT.IStoreInstruction;
import com.ibm.wala.shrikeBT.LoadInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.StoreInstruction;
import com.ibm.wala.shrikeBT.SwapInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.analysis.ClassHierarchy;
import com.ibm.wala.shrikeBT.analysis.ClassHierarchyProvider;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analyzer {
    protected final boolean isStatic;
    protected final String classType;
    protected final String signature;
    protected final IInstruction[] instructions;
    protected final ExceptionHandler[][] handlers;
    protected ClassHierarchyProvider hierarchy;
    protected int maxStack;
    protected int maxLocals;
    protected String[][] stacks;
    protected String[][] locals;
    protected int[] stackSizes;
    protected BitSet basicBlockStarts;
    protected int[][] backEdges;
    protected static final String[] noStrings = new String[0];
    protected static final int[] noEdges = new int[0];

    public Analyzer(boolean bl, String string, String string2, IInstruction[] iInstructionArray, ExceptionHandler[][] exceptionHandlerArray) {
        if (iInstructionArray == null) {
            throw new IllegalArgumentException("null instructions");
        }
        if (exceptionHandlerArray == null) {
            throw new IllegalArgumentException("null handlers");
        }
        IInstruction[] iInstructionArray2 = iInstructionArray;
        int n = iInstructionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IInstruction iInstruction = iInstructionArray2[n2];
            if (iInstruction == null) {
                throw new IllegalArgumentException("null instruction is illegal");
            }
            ++n2;
        }
        this.classType = string;
        this.isStatic = bl;
        this.signature = string2;
        this.instructions = iInstructionArray;
        this.handlers = exceptionHandlerArray;
    }

    public final void setClassHierarchy(ClassHierarchyProvider classHierarchyProvider) {
        this.hierarchy = classHierarchyProvider;
    }

    private void addBackEdge(int n, int n2) {
        int[] nArray = this.backEdges[n];
        if (nArray == null) {
            this.backEdges[n] = new int[]{n2};
        } else if (nArray[nArray.length - 1] < 0) {
            int n3 = 1;
            int n4 = nArray.length - 1;
            while (true) {
                if (n4 - n3 < 2) {
                    if (nArray[n3] < 0) break;
                    if (nArray[n4] >= 0) {
                        throw new Error("Failed binary search");
                    }
                    n3 = n4;
                    break;
                }
                int n5 = (n3 + n4) / 2;
                if (nArray[n5] < 0) {
                    n4 = n5;
                    continue;
                }
                n3 = n5 + 1;
            }
            nArray[n3] = n2;
        } else {
            int[] nArray2 = new int[nArray.length * 2];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray2[nArray.length] = n2;
            int n6 = nArray.length + 1;
            while (n6 < nArray2.length) {
                nArray2[n6] = -1;
                ++n6;
            }
            this.backEdges[n] = nArray2;
        }
    }

    public final int[][] getBackEdges() {
        Object[] objectArray;
        Object object;
        if (this.backEdges != null) {
            return this.backEdges;
        }
        this.backEdges = new int[this.instructions.length][];
        int n = 0;
        while (n < this.instructions.length) {
            object = this.instructions[n];
            int[] nArray = object.getBranchTargets();
            int n2 = 0;
            while (n2 < nArray.length) {
                this.addBackEdge(nArray[n2], n);
                ++n2;
            }
            objectArray = this.handlers[n];
            int n3 = 0;
            while (n3 < objectArray.length) {
                this.addBackEdge(objectArray[n3].getHandler(), n);
                ++n3;
            }
            ++n;
        }
        n = 0;
        while (n < this.backEdges.length) {
            object = this.backEdges[n];
            if (object == null) {
                this.backEdges[n] = noEdges;
            } else if (object[((Object)object).length - 1] < 0) {
                int n4 = ((Object)object).length;
                while (object[n4 - 1] < 0) {
                    --n4;
                }
                objectArray = new int[n4];
                System.arraycopy(object, 0, objectArray, 0, objectArray.length);
                this.backEdges[n] = (int[])objectArray;
            }
            ++n;
        }
        return this.backEdges;
    }

    public final boolean isSubtypeOf(String string, String string2) {
        return ClassHierarchy.isSubtypeOf(this.hierarchy, string, string2) != 1;
    }

    public final String findCommonSupertype(String string, String string2) {
        return ClassHierarchy.findCommonSupertype(this.hierarchy, string, string2);
    }

    public final BitSet getBasicBlockStarts() {
        int n;
        Object[] objectArray;
        if (this.basicBlockStarts != null) {
            return this.basicBlockStarts;
        }
        BitSet bitSet = new BitSet(this.instructions.length);
        bitSet.set(0);
        int n2 = 0;
        while (n2 < this.instructions.length) {
            objectArray = this.instructions[n2].getBranchTargets();
            n = 0;
            while (n < objectArray.length) {
                bitSet.set(objectArray[n]);
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.handlers.length) {
            objectArray = this.handlers[n2];
            if (objectArray != null) {
                n = 0;
                while (n < objectArray.length) {
                    bitSet.set(objectArray[n].getHandler());
                    ++n;
                }
            }
            ++n2;
        }
        this.basicBlockStarts = bitSet;
        return bitSet;
    }

    public final IInstruction[] getInstructions() {
        return this.instructions;
    }

    private void getReachableRecursive(int n, BitSet bitSet, boolean bl, BitSet bitSet2) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("from < 0");
        }
        while (true) {
            if (bitSet.get(n) || bitSet2 != null && !bitSet2.get(n)) {
                return;
            }
            bitSet.set(n);
            IInstruction iInstruction = this.instructions[n];
            int[] nArray = iInstruction.getBranchTargets();
            int n2 = 0;
            while (n2 < nArray.length) {
                this.getReachableRecursive(nArray[n2], bitSet, bl, bitSet2);
                ++n2;
            }
            if (bl) {
                ExceptionHandler[] exceptionHandlerArray = this.handlers[n];
                int n3 = 0;
                while (n3 < exceptionHandlerArray.length) {
                    this.getReachableRecursive(exceptionHandlerArray[n3].getHandler(), bitSet, bl, bitSet2);
                    ++n3;
                }
            }
            if (!iInstruction.isFallThrough()) break;
            ++n;
        }
    }

    public final BitSet getReachableFrom(int n) {
        return this.getReachableFrom(n, true, null);
    }

    public final void getReachableFromUpdate(int n, BitSet bitSet, boolean bl, BitSet bitSet2) {
        if (bitSet == null) {
            throw new IllegalArgumentException("reachable is null");
        }
        bitSet.clear();
        this.getReachableRecursive(n, bitSet, bl, bitSet2);
    }

    public final BitSet getReachableFrom(int n, boolean bl, BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        this.getReachableRecursive(n, bitSet2, bl, bitSet);
        return bitSet2;
    }

    private void getReachingRecursive(int n, BitSet bitSet, BitSet bitSet2) {
        while (true) {
            if (bitSet.get(n) || bitSet2 != null && !bitSet2.get(n)) {
                return;
            }
            bitSet.set(n);
            int[] nArray = this.backEdges[n];
            int n2 = 0;
            while (n2 < nArray.length) {
                this.getReachingRecursive(nArray[n2], bitSet, bitSet2);
                ++n2;
            }
            if (n <= 0 || !this.instructions[n - 1].isFallThrough()) break;
            --n;
        }
    }

    private void getReachingBase(int n, BitSet bitSet, BitSet bitSet2) {
        int[] nArray = this.backEdges[n];
        int n2 = 0;
        while (n2 < nArray.length) {
            this.getReachingRecursive(nArray[n2], bitSet, bitSet2);
            ++n2;
        }
        if (n > 0 && this.instructions[n - 1].isFallThrough()) {
            this.getReachingRecursive(n - 1, bitSet, bitSet2);
        }
    }

    public final void getReachingToUpdate(int n, BitSet bitSet, BitSet bitSet2) {
        if (bitSet == null) {
            throw new IllegalArgumentException("reaching is null");
        }
        this.getBackEdges();
        bitSet.clear();
        this.getReachingBase(n, bitSet, bitSet2);
    }

    final BitSet getReachingTo(int n, BitSet bitSet) {
        this.getBackEdges();
        BitSet bitSet2 = new BitSet();
        this.getReachingBase(n, bitSet2, bitSet);
        return bitSet2;
    }

    final BitSet getReachingTo(int n) {
        return this.getReachingTo(n, null);
    }

    private void computeStackSizesAt(int[] nArray, int n, int n2) throws FailureException {
        while (true) {
            if (nArray[n] >= 0) {
                if (n2 != nArray[n]) {
                    throw new FailureException(n, "Stack size mismatch", null);
                }
                return;
            }
            nArray[n] = n2;
            IInstruction iInstruction = this.instructions[n];
            if (iInstruction instanceof DupInstruction) {
                n2 += ((DupInstruction)iInstruction).getSize();
            } else if (!(iInstruction instanceof SwapInstruction)) {
                n2 -= iInstruction.getPoppedCount();
                if (iInstruction.getPushedWordSize() > 0) {
                    ++n2;
                }
            }
            int[] nArray2 = iInstruction.getBranchTargets();
            int n3 = 0;
            while (n3 < nArray2.length) {
                this.computeStackSizesAt(nArray, nArray2[n3], n2);
                ++n3;
            }
            ExceptionHandler[] exceptionHandlerArray = this.handlers[n];
            int n4 = 0;
            while (n4 < exceptionHandlerArray.length) {
                this.computeStackSizesAt(nArray, exceptionHandlerArray[n4].getHandler(), 1);
                ++n4;
            }
            if (!iInstruction.isFallThrough()) {
                return;
            }
            ++n;
        }
    }

    private String[] cutArray(String[] stringArray, int n) {
        if (n == 0) {
            return noStrings;
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        return stringArray2;
    }

    private boolean mergeTypes(int n, String[] stringArray, int n2, String[] stringArray2, int n3, List<PathElement> list) throws FailureException {
        String string;
        int n4;
        String[] stringArray3;
        boolean bl = false;
        if (this.stacks[n] == null) {
            this.stacks[n] = this.cutArray(stringArray, n2);
            bl = true;
        } else {
            stringArray3 = this.stacks[n];
            if (stringArray3.length != n2) {
                throw new FailureException(n, "Stack size mismatch: " + stringArray3.length + ", " + n2, list);
            }
            n4 = 0;
            while (n4 < n2) {
                string = this.findCommonSupertype(stringArray3[n4], stringArray[n4]);
                if (string != stringArray3[n4]) {
                    if (string == null) {
                        throw new FailureException(n, "Stack type mismatch at " + n4 + " (" + stringArray3[n4] + " vs " + stringArray[n4] + ")", list);
                    }
                    stringArray3[n4] = string;
                    bl = true;
                }
                ++n4;
            }
        }
        if (this.locals[n] == null) {
            this.locals[n] = this.cutArray(stringArray2, n3);
            bl = true;
        } else {
            stringArray3 = this.locals[n];
            n4 = 0;
            while (n4 < stringArray3.length) {
                string = this.findCommonSupertype(stringArray3[n4], stringArray2[n4]);
                if (string != stringArray3[n4]) {
                    stringArray3[n4] = string;
                    bl = true;
                }
                ++n4;
            }
        }
        return bl;
    }

    private void computeTypes(int n, TypeVisitor typeVisitor, BitSet bitSet, List<PathElement> list) throws FailureException {
        boolean bl;
        final String[] stringArray = new String[this.maxStack];
        final String[] stringArray2 = new String[this.maxLocals];
        block0: do {
            if (list != null) {
                list.add(new PathElement(n, this.stacks[n], this.locals[n]));
            }
            int n2 = this.stacks[n].length;
            System.arraycopy(this.stacks[n], 0, stringArray, 0, n2);
            final int[] nArray = new int[]{this.locals[n].length};
            System.arraycopy(this.locals[n], 0, stringArray2, 0, nArray[0]);
            IInstruction.Visitor visitor = new IInstruction.Visitor(){

                public void visitLocalLoad(ILoadInstruction iLoadInstruction) {
                    String string;
                    stringArray[0] = string = stringArray2[iLoadInstruction.getVarIndex()];
                }

                public void visitLocalStore(IStoreInstruction iStoreInstruction) {
                    int n = iStoreInstruction.getVarIndex();
                    stringArray2[n] = stringArray[0];
                    if (n >= nArray[0]) {
                        nArray[0] = n + 1;
                    }
                }
            };
            bl = false;
            do {
                int n3;
                Object object;
                IInstruction iInstruction;
                int n4;
                if (n2 < (n4 = (iInstruction = this.instructions[n]).getPoppedCount())) {
                    throw new FailureException(n, "Stack underflow", list);
                }
                if (typeVisitor != null) {
                    typeVisitor.setState(n, list, stringArray, stringArray2);
                    iInstruction.visit(typeVisitor);
                    if (!typeVisitor.shouldContinue()) {
                        return;
                    }
                }
                if (iInstruction instanceof DupInstruction) {
                    object = (DupInstruction)iInstruction;
                    n3 = ((DupInstruction)object).getSize();
                    System.arraycopy(stringArray, n4, stringArray, n4 + n3, n2 - n4);
                    System.arraycopy(stringArray, 0, stringArray, n4, n3);
                    n2 += n3;
                } else if (iInstruction instanceof SwapInstruction) {
                    object = stringArray[0];
                    stringArray[0] = stringArray[1];
                    stringArray[1] = object;
                } else {
                    object = iInstruction.getPushedType(stringArray);
                    if (object != null) {
                        System.arraycopy(stringArray, n4, stringArray, 1, n2 - n4);
                        stringArray[0] = Util.getStackType((String)object);
                        iInstruction.visit(visitor);
                        n2 -= n4 - 1;
                    } else {
                        iInstruction.visit(visitor);
                        System.arraycopy(stringArray, n4, stringArray, 0, n2 - n4);
                        n2 -= n4;
                    }
                }
                object = iInstruction.getBranchTargets();
                n3 = 0;
                while (n3 < ((Object)object).length) {
                    if (this.mergeTypes((int)object[n3], stringArray, n2, stringArray2, nArray[0], list)) {
                        this.computeTypes((int)object[n3], typeVisitor, bitSet, list);
                    }
                    ++n3;
                }
                if (!iInstruction.isFallThrough()) continue block0;
            } while (!bitSet.get(++n));
            if (this.mergeTypes(n, stringArray, n2, stringArray2, nArray[0], list)) {
                bl = true;
                continue;
            }
            if (list != null) {
                list.remove(list.size() - 1);
            }
            return;
        } while (bl);
        if (list != null) {
            list.remove(list.size() - 1);
        }
    }

    public int[] getStackSizes() throws FailureException {
        if (this.stackSizes != null) {
            return this.stackSizes;
        }
        this.stackSizes = new int[this.instructions.length];
        int n = 0;
        while (n < this.stackSizes.length) {
            this.stackSizes[n] = -1;
            ++n;
        }
        this.computeStackSizesAt(this.stackSizes, 0, 0);
        return this.stackSizes;
    }

    private void computeMaxLocals() {
        this.maxLocals = this.locals[0].length;
        int n = 0;
        while (n < this.instructions.length) {
            IInstruction iInstruction = this.instructions[n];
            if (iInstruction instanceof LoadInstruction) {
                this.maxLocals = Math.max(this.maxLocals, ((LoadInstruction)iInstruction).getVarIndex() + 1);
            } else if (iInstruction instanceof StoreInstruction) {
                this.maxLocals = Math.max(this.maxLocals, ((StoreInstruction)iInstruction).getVarIndex() + 1);
            }
            ++n;
        }
    }

    protected final void initTypeInfo() throws FailureException {
        this.stacks = new String[this.instructions.length][];
        this.locals = new String[this.instructions.length][];
        this.stacks[0] = noStrings;
        this.locals[0] = Util.getParamsTypesInLocals(this.isStatic ? null : this.classType, this.signature);
        int[] nArray = this.getStackSizes();
        this.maxStack = 0;
        int n = 0;
        while (n < nArray.length) {
            this.maxStack = Math.max(this.maxStack, nArray[n]);
            ++n;
        }
        this.computeMaxLocals();
    }

    public final void computeTypes(TypeVisitor typeVisitor, BitSet bitSet, boolean bl) throws FailureException {
        this.initTypeInfo();
        this.computeTypes(0, typeVisitor, bitSet, bl ? new ArrayList() : null);
    }

    public final String[][] getLocalTypes() {
        return this.locals;
    }

    public final String[][] getStackTypes() {
        return this.stacks;
    }

    protected Analyzer(MethodData methodData) {
        this(methodData.getIsStatic(), methodData.getClassType(), methodData.getSignature(), methodData.getInstructions(), methodData.getHandlers());
    }

    public static Analyzer createAnalyzer(MethodData methodData) {
        if (methodData == null) {
            throw new IllegalArgumentException("info is null");
        }
        return new Analyzer(methodData);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FailureException
    extends Exception {
        private static final long serialVersionUID = -7663520961403117526L;
        private final int offset;
        private final String reason;
        private List<PathElement> path;

        FailureException(int n, String string, List<PathElement> list) {
            super(String.valueOf(string) + " at offset " + n);
            this.offset = n;
            this.reason = string;
            this.path = list;
        }

        public int getOffset() {
            return this.offset;
        }

        public String getReason() {
            return this.reason;
        }

        public List<PathElement> getPath() {
            return this.path;
        }

        void setPath(List<PathElement> list) {
            this.path = list;
        }

        public void printPath(Writer writer) throws IOException {
            if (this.path != null) {
                int n = 0;
                while (n < this.path.size()) {
                    PathElement pathElement = this.path.get(n);
                    String[] stringArray = pathElement.stack;
                    String[] stringArray2 = pathElement.locals;
                    writer.write("Offset " + pathElement.index + ": [");
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        if (n2 > 0) {
                            writer.write(",");
                        }
                        writer.write(stringArray[n2]);
                        ++n2;
                    }
                    writer.write("], [");
                    n2 = 0;
                    while (n2 < stringArray2.length) {
                        if (n2 > 0) {
                            writer.write(",");
                        }
                        writer.write(stringArray2[n2] == null ? "?" : stringArray2[n2]);
                        ++n2;
                    }
                    writer.write("]\n");
                    ++n;
                }
            }
        }
    }

    public static final class PathElement {
        final int index;
        final String[] stack;
        final String[] locals;

        PathElement(int n, String[] stringArray, String[] stringArray2) {
            this.stack = (String[])stringArray.clone();
            this.locals = (String[])stringArray2.clone();
            this.index = n;
        }

        public int getIndex() {
            return this.index;
        }

        public String[] getLocals() {
            return this.locals;
        }

        public String[] getStack() {
            return this.stack;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class TypeVisitor
    extends IInstruction.Visitor {
        public abstract void setState(int var1, List<PathElement> var2, String[] var3, String[] var4);

        public abstract boolean shouldContinue();
    }
}

