/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.GetInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.InvokeInstruction;
import com.ibm.wala.shrikeBT.PutInstruction;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    private static final HashMap<String, String> classAliases;
    private static final HashMap<String, String> typeAliases;
    private static final byte[] typeIndices;

    static {
        typeAliases = new HashMap();
        classAliases = new HashMap();
        Util.addAlias("void", "V");
        Util.addAlias("int", "I");
        Util.addAlias("long", "J");
        Util.addAlias("float", "F");
        Util.addAlias("double", "D");
        Util.addAlias("byte", "B");
        Util.addAlias("char", "C");
        Util.addAlias("short", "S");
        Util.addAlias("boolean", "Z");
        typeIndices = Util.makeTypeIndices();
    }

    private Util() {
    }

    public static byte getWordSize(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("invalid s: " + string);
        }
        return Util.getWordSize(string, 0);
    }

    static byte getWordSize(String string, int n) {
        switch (string.charAt(n)) {
            case 'V': {
                return 0;
            }
            case 'D': 
            case 'J': {
                return 2;
            }
        }
        return 1;
    }

    private static int getTypeLength(String string, int n) {
        switch (string.charAt(n)) {
            case 'L': {
                return string.indexOf(59, n) - n + 1;
            }
            case '[': {
                return Util.getTypeLength(string, n + 1) + 1;
            }
        }
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    public static int getParamsWordSize(String var0) throws IllegalArgumentException {
        if (var0 == null) {
            throw new IllegalArgumentException("type is null");
        }
        var1_1 = 1;
        var2_2 = 0;
        if (var0.indexOf(41, 1) >= 0) ** GOTO lbl9
        throw new IllegalArgumentException("Invalid method descriptor (missing ')'): " + var0);
lbl-1000:
        // 1 sources

        {
            var2_2 += Util.getWordSize(var0, var1_1);
            var1_1 += Util.getTypeLength(var0, var1_1);
lbl9:
            // 2 sources

            ** while (var0.charAt((int)var1_1) != ')')
        }
lbl10:
        // 1 sources

        return var2_2;
    }

    public static String makeType(String string) {
        if (string == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (string.startsWith("[")) {
            return string.replace('.', '/');
        }
        if (!string.endsWith(";")) {
            return "L" + string.replace('.', '/') + ";";
        }
        return string;
    }

    public static String makeTypeAll(String string) {
        String string2 = typeAliases.get(string);
        if (string2 != null) {
            return string2;
        }
        return Util.makeType(string);
    }

    public static String makeClass(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("t is null");
        }
        if (string.startsWith("[")) {
            return string;
        }
        if (!string.startsWith("L")) {
            throw new IllegalArgumentException(String.valueOf(string) + " is not a valid class type");
        }
        return string.substring(1, string.length() - 1).replace('/', '.');
    }

    static String makeClassAll(String string) {
        String string2 = classAliases.get(string);
        if (string2 != null) {
            return string2;
        }
        return Util.makeClass(string);
    }

    private static void addAlias(String string, String string2) {
        typeAliases.put(string, string2);
        classAliases.put(string2, string);
    }

    public static String makeType(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("c is null");
        }
        String string = clazz.getName();
        String string2 = typeAliases.get(string);
        if (string2 != null) {
            return string2;
        }
        return Util.makeType(string);
    }

    static int getParamsCount(String string) throws IllegalArgumentException {
        if (string == null || string.length() < 2) {
            throw new IllegalArgumentException("invalid type: " + string);
        }
        int n = 1;
        int n2 = 0;
        try {
            while (string.charAt(n) != ')') {
                ++n2;
                n += Util.getTypeLength(string, n);
            }
            return n2;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid type: " + string);
        }
    }

    public static String[] getParamsTypes(String string, String string2) throws IllegalArgumentException {
        if (string2 == null) {
            throw new IllegalArgumentException("type == null");
        }
        int n = string != null ? 1 : 0;
        String[] stringArray = new String[Util.getParamsCount(string2) + n];
        int n2 = 1;
        if (string != null) {
            stringArray[0] = string;
        }
        while (string2.charAt(n2) != ')') {
            int n3 = Util.getTypeLength(string2, n2);
            stringArray[n] = string2.substring(n2, n2 + n3);
            ++n;
            n2 += n3;
        }
        return stringArray;
    }

    public static String[] getParamsTypesInLocals(String string, String string2) throws IllegalArgumentException {
        if (string2 == null) {
            throw new IllegalArgumentException("type == null");
        }
        int n = string != null ? 1 : 0;
        String[] stringArray = new String[Util.getParamsWordSize(string2) + n];
        int n2 = 1;
        if (string != null) {
            stringArray[0] = string;
        }
        while (string2.charAt(n2) != ')') {
            String string3;
            int n3 = Util.getTypeLength(string2, n2);
            stringArray[n] = string3 = Util.getStackType(string2.substring(n2, n2 + n3));
            n += Util.getWordSize(string3);
            n2 += n3;
        }
        return stringArray;
    }

    public static String getStackType(String string) {
        if (string == null || string.length() < 1) {
            throw new IllegalArgumentException("invalid t: " + string);
        }
        switch (string.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'S': 
            case 'Z': {
                return "I";
            }
        }
        return string;
    }

    public static String makeArray(String string) {
        return ("[" + string).intern();
    }

    public static boolean isArrayType(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        switch (string.charAt(0)) {
            case '[': {
                return true;
            }
        }
        return false;
    }

    public static boolean isPrimitiveType(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        switch (string.charAt(0)) {
            case 'L': 
            case '[': {
                return false;
            }
        }
        return true;
    }

    public static String getReturnType(String string) {
        if (string == null) {
            throw new IllegalArgumentException("s is null");
        }
        return string.substring(string.lastIndexOf(41) + 1);
    }

    public static void error(String string) {
        System.err.println(string);
        new Error("Stack Trace").printStackTrace();
    }

    public static String computeSignature(Class<?>[] classArray, Class<?> clazz) throws IllegalArgumentException {
        if (classArray == null) {
            throw new IllegalArgumentException("params == null");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(Util.makeType(classArray[n]));
            ++n;
        }
        stringBuffer.append(")");
        stringBuffer.append(Util.makeType(clazz));
        return stringBuffer.toString();
    }

    public static GetInstruction makeGet(Class<?> clazz, String string) {
        if (clazz == null) {
            throw new IllegalArgumentException("c is null");
        }
        try {
            Field field = clazz.getField(string);
            return GetInstruction.make(Util.makeType(field.getType()), Util.makeType(clazz), string, (field.getModifiers() & 8) != 0);
        }
        catch (SecurityException securityException) {
            throw new IllegalArgumentException(securityException.getMessage());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException(noSuchFieldException.getMessage());
        }
    }

    public static PutInstruction makePut(Class<?> clazz, String string) {
        if (clazz == null) {
            throw new IllegalArgumentException("c is null");
        }
        try {
            Field field = clazz.getField(string);
            return PutInstruction.make(Util.makeType(field.getType()), Util.makeType(clazz), string, (field.getModifiers() & 8) != 0);
        }
        catch (SecurityException securityException) {
            throw new IllegalArgumentException(securityException.getMessage());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException(noSuchFieldException.getMessage());
        }
    }

    private static String makeName(String string, Class<?>[] classArray) {
        if (classArray == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("(");
        int n = 0;
        while (n < classArray.length) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(classArray[n].getName());
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static Method findMethod(Class<?> clazz, String string) {
        return Util.findMethod(clazz, string, null);
    }

    public static Method findMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        if (clazz == null) {
            throw new IllegalArgumentException("c is null");
        }
        Method[] methodArray = clazz.getMethods();
        Method method = null;
        int n = 0;
        while (n < methodArray.length) {
            Method method2 = methodArray[n];
            if (method2.getName().equals(string) && (classArray == null || Arrays.equals(method2.getParameterTypes(), classArray))) {
                if (method != null) {
                    throw new IllegalArgumentException("Method " + Util.makeName(string, classArray) + " is ambiguous in class " + clazz);
                }
                method = method2;
            }
            ++n;
        }
        return method;
    }

    public static InvokeInstruction makeInvoke(Class<?> clazz, String string, Class<?>[] classArray) {
        if (string == null) {
            throw new IllegalArgumentException("name is null");
        }
        InvokeInstruction invokeInstruction = null;
        if (string.equals("<init>")) {
            Constructor<?>[] constructorArray = clazz.getConstructors();
            int n = 0;
            while (n < constructorArray.length) {
                Constructor<?> constructor = constructorArray[n];
                if (classArray == null || Arrays.equals(constructor.getParameterTypes(), classArray)) {
                    if (invokeInstruction != null) {
                        throw new IllegalArgumentException("Constructor " + Util.makeName(string, classArray) + " is ambiguous in class " + clazz);
                    }
                    invokeInstruction = InvokeInstruction.make(Util.computeSignature(constructor.getParameterTypes(), Void.TYPE), Util.makeType(clazz), string, IInvokeInstruction.Dispatch.SPECIAL);
                }
                ++n;
            }
        } else {
            Method method = Util.findMethod(clazz, string, classArray);
            if (method != null) {
                IInvokeInstruction.Dispatch dispatch = IInvokeInstruction.Dispatch.VIRTUAL;
                if ((method.getModifiers() & 8) != 0) {
                    dispatch = IInvokeInstruction.Dispatch.STATIC;
                } else if (method.getDeclaringClass().isInterface()) {
                    dispatch = IInvokeInstruction.Dispatch.INTERFACE;
                }
                invokeInstruction = InvokeInstruction.make(Util.computeSignature(method.getParameterTypes(), method.getReturnType()), Util.makeType(clazz), string, dispatch);
            }
        }
        if (invokeInstruction == null) {
            throw new IllegalArgumentException("Method " + Util.makeName(string, classArray) + " is not present in class " + clazz);
        }
        return invokeInstruction;
    }

    public static InvokeInstruction makeInvoke(Class<?> clazz, String string) {
        return Util.makeInvoke(clazz, string, null);
    }

    static int getTypeIndex(String string) {
        if (string == null) {
            return -1;
        }
        int n = string.length();
        if (n < 1) {
            return -1;
        }
        char c = string.charAt(0);
        if (c < typeIndices.length) {
            byte by = typeIndices[c];
            if (by != 4) {
                if (n > 1) {
                    return -1;
                }
                return by;
            }
            return by;
        }
        return -1;
    }

    private static byte[] makeTypeIndices() {
        byte[] byArray = new byte[128];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = -1;
            ++n;
        }
        byArray[73] = 0;
        byArray[74] = 1;
        byArray[70] = 2;
        byArray[68] = 3;
        byArray[76] = 4;
        byArray[91] = 4;
        byArray[66] = 5;
        byArray[67] = 6;
        byArray[83] = 7;
        byArray[90] = 8;
        return byArray;
    }

    public static void readFully(InputStream inputStream, byte[] byArray) throws IllegalArgumentException, IllegalArgumentException, IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("s == null");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("bytes == null");
        }
        int n = 0;
        while (n < byArray.length) {
            int n2 = inputStream.read(byArray, n, byArray.length - n);
            if (n2 < 0) {
                throw new IOException("Class truncated");
            }
            n += n2;
        }
    }

    public static byte[] readFully(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("s is null");
        }
        byte[] byArray = new byte[inputStream.available()];
        Util.readFully(inputStream, byArray);
        int n = inputStream.read();
        if (n < 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length * 2 + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = (byte)n;
        int n2 = byArray.length + 1;
        while (true) {
            int n3;
            if (byArray2.length == n2) {
                byArray = new byte[n2 * 2];
                System.arraycopy(byArray2, 0, byArray, 0, n2);
                byArray2 = byArray;
            }
            if ((n3 = inputStream.read(byArray2, n2, byArray2.length - n2)) < 0) {
                byArray = new byte[n2];
                System.arraycopy(byArray2, 0, byArray, 0, n2);
                return byArray;
            }
            n2 += n3;
        }
    }
}

