/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public final class UnaryOpInstruction
extends Instruction
implements IUnaryOpInstruction {
    private static final UnaryOpInstruction[] preallocated = UnaryOpInstruction.preallocate();

    protected UnaryOpInstruction(short s) {
        super(s);
    }

    private static UnaryOpInstruction[] preallocate() {
        UnaryOpInstruction[] unaryOpInstructionArray = new UnaryOpInstruction[4];
        int n = 0;
        while (n < unaryOpInstructionArray.length) {
            unaryOpInstructionArray[n] = new UnaryOpInstruction((short)(116 + n));
            ++n;
        }
        return unaryOpInstructionArray;
    }

    public static UnaryOpInstruction make(String string, IUnaryOpInstruction.Operator operator) throws IllegalArgumentException {
        int n = Util.getTypeIndex(string);
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Type " + string + " cannot have a unary operator applied");
        }
        return preallocated[n];
    }

    public boolean equals(Object object) {
        if (object instanceof UnaryOpInstruction) {
            UnaryOpInstruction unaryOpInstruction = (UnaryOpInstruction)object;
            return unaryOpInstruction.opcode == this.opcode;
        }
        return false;
    }

    public IUnaryOpInstruction.Operator getOperator() {
        return IUnaryOpInstruction.Operator.NEG;
    }

    public int hashCode() {
        return this.opcode;
    }

    public int getPoppedCount() {
        return 1;
    }

    public String getPushedType(String[] stringArray) {
        return this.getType();
    }

    public byte getPushedWordSize() {
        return Util.getWordSize(this.getType());
    }

    public String getType() {
        return indexedTypes[this.opcode - 116];
    }

    public void visit(IInstruction.Visitor visitor) throws NullPointerException {
        visitor.visitUnaryOp(this);
    }

    public String toString() {
        return "UnaryOp(" + this.getType() + "," + this.getOperator() + ")";
    }

    public boolean isPEI() {
        return false;
    }
}

