/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import java.util.Arrays;

public final class SwitchInstruction
extends Instruction {
    private final int[] casesAndLabels;
    private final int defaultLabel;

    protected SwitchInstruction(short s, int[] nArray, int n) {
        super(s);
        this.casesAndLabels = nArray;
        this.defaultLabel = n;
    }

    public int getDefaultLabel() {
        return this.defaultLabel;
    }

    public int[] getCasesAndLabels() {
        return this.casesAndLabels;
    }

    public static SwitchInstruction make(int[] nArray, int n) {
        if (nArray == null) {
            throw new IllegalArgumentException("casesAndLabels is null");
        }
        int n2 = 170;
        int n3 = 2;
        while (n3 < nArray.length) {
            int n4 = nArray[n3];
            int n5 = nArray[n3 - 2];
            if (n4 <= n5) {
                throw new IllegalArgumentException("Cases and labels array must be sorted by case");
            }
            if (n4 != n5 + 1) {
                n2 = 171;
            }
            n3 += 2;
        }
        if (nArray.length == 0) {
            n2 = 171;
        }
        return new SwitchInstruction((short)n2, nArray, n);
    }

    public boolean isFallThrough() {
        return false;
    }

    public int[] getBranchTargets() {
        int[] nArray = new int[this.casesAndLabels.length / 2 + 1];
        nArray[0] = this.defaultLabel;
        int n = 1;
        while (n < nArray.length) {
            nArray[n] = this.casesAndLabels[(n - 1) * 2 + 1];
            ++n;
        }
        return nArray;
    }

    public IInstruction redirectTargets(int[] nArray) throws IllegalArgumentException {
        if (nArray == null) {
            throw new IllegalArgumentException("targetMap is null");
        }
        try {
            int[] nArray2 = new int[this.casesAndLabels.length];
            int n = 0;
            while (n < nArray2.length) {
                nArray2[n] = this.casesAndLabels[n];
                nArray2[n + 1] = nArray[this.casesAndLabels[n + 1]];
                n += 2;
            }
            return SwitchInstruction.make(nArray2, nArray[this.defaultLabel]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Illegal target map", arrayIndexOutOfBoundsException);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof SwitchInstruction) {
            SwitchInstruction switchInstruction = (SwitchInstruction)object;
            return switchInstruction.defaultLabel == this.defaultLabel && Arrays.equals(switchInstruction.casesAndLabels, this.casesAndLabels);
        }
        return false;
    }

    public int hashCode() {
        int n = this.defaultLabel * 1348091 + 111311;
        int n2 = 0;
        while (n2 < this.casesAndLabels.length) {
            n += (n2 * 9301 + 38101) * this.casesAndLabels[n2];
            ++n2;
        }
        return n;
    }

    public int getPoppedCount() {
        return 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Switch(");
        stringBuffer.append(this.defaultLabel);
        int n = 0;
        while (n < this.casesAndLabels.length) {
            stringBuffer.append(',');
            stringBuffer.append(this.casesAndLabels[n]);
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void visit(IInstruction.Visitor visitor) throws IllegalArgumentException {
        if (visitor == null) {
            throw new IllegalArgumentException();
        }
        visitor.visitSwitch(this);
    }

    public boolean isPEI() {
        return false;
    }
}

