/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public final class ReturnInstruction
extends Instruction {
    private static final ReturnInstruction[] preallocated = ReturnInstruction.preallocate();
    private static final ReturnInstruction preallocatedVoid = new ReturnInstruction(177);

    protected ReturnInstruction(short s) {
        super(s);
    }

    private static ReturnInstruction[] preallocate() {
        ReturnInstruction[] returnInstructionArray = new ReturnInstruction[5];
        int n = 0;
        while (n < returnInstructionArray.length) {
            returnInstructionArray[n] = new ReturnInstruction((short)(172 + n));
            ++n;
        }
        return returnInstructionArray;
    }

    public static ReturnInstruction make(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (string.equals("V")) {
            return preallocatedVoid;
        }
        int n = Util.getTypeIndex(string);
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("Cannot return type " + string);
        }
        return preallocated[n];
    }

    public boolean equals(Object object) {
        if (object instanceof ReturnInstruction) {
            ReturnInstruction returnInstruction = (ReturnInstruction)object;
            return returnInstruction.opcode == this.opcode;
        }
        return false;
    }

    public boolean isFallThrough() {
        return false;
    }

    public int hashCode() {
        return this.opcode + 31111;
    }

    public int getPoppedCount() {
        return this.opcode == 177 ? 0 : 1;
    }

    public String getType() {
        return this.opcode == 177 ? "V" : indexedTypes[this.opcode - 172];
    }

    public void visit(IInstruction.Visitor visitor) throws NullPointerException {
        visitor.visitReturn(this);
    }

    public String toString() {
        return "Return(" + this.getType() + ")";
    }

    public boolean isPEI() {
        return false;
    }
}

