/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.GotoInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.MethodData;
import java.util.ArrayList;
import java.util.IdentityHashMap;

public final class MethodEditor {
    private static final ExceptionHandler[] noHandlers = new ExceptionHandler[0];
    private int[] instructionsToBytecodes;
    private IInstruction[] instructions;
    private ExceptionHandler[][] handlers;
    private final MethodData methodInfo;
    private static final int BEFORE_PASS = 1;
    private static final int DURING_PASS = 2;
    private static final int EMITTING_CODE = 4;
    private static final int BEFORE_END_PASS = 8;
    private int state = 1;
    private int patchCount;
    private Patch[] beforePatches;
    private Patch[] afterPatches;
    private Patch[] lastAfterPatches;
    private Patch[] replacementPatches;
    private Patch methodStartPatches;
    private Patch afterMethodPatches;
    private HandlerPatch[] instructionHandlerPatches;
    private HandlerPatch methodHandlerPatches;
    private int nextLabel;

    public MethodEditor(MethodData methodData) {
        if (methodData == null) {
            throw new IllegalArgumentException("info is null");
        }
        this.methodInfo = methodData;
        this.instructionsToBytecodes = methodData.getInstructionsToBytecodes();
        this.instructions = methodData.getInstructions();
        this.handlers = methodData.getHandlers();
    }

    public MethodEditor(Instruction[] instructionArray, ExceptionHandler[][] exceptionHandlerArray, int[] nArray) {
        if (instructionArray == null) {
            throw new IllegalArgumentException("null instructions");
        }
        if (exceptionHandlerArray == null) {
            throw new IllegalArgumentException("null handlers");
        }
        this.methodInfo = null;
        this.instructionsToBytecodes = nArray;
        this.instructions = instructionArray;
        this.handlers = exceptionHandlerArray;
    }

    private void verifyState(int n) {
        if ((n & this.state) == 0) {
            throw new IllegalArgumentException(this.getStateMessage(n));
        }
    }

    private String getStateMessage(int n) {
        switch (n) {
            case 1: {
                return "This operation can only be performed before or after an editing pass";
            }
            case 2: {
                return "This operation can only be performed during an editing pass";
            }
            case 4: {
                return "This operation can only be performed while applying patches and emitting code";
            }
            case 8: {
                return "This operation can only be performed after applying patches";
            }
        }
        return "This operation cannot be performed in this state";
    }

    public ExceptionHandler[][] getHandlers() {
        this.verifyState(3);
        return this.handlers;
    }

    public IInstruction[] getInstructions() {
        this.verifyState(3);
        return this.instructions;
    }

    public int[] getInstructionsToBytecodes() {
        this.verifyState(3);
        return this.instructionsToBytecodes;
    }

    static ExceptionHandler[] mergeHandlers(ExceptionHandler[] exceptionHandlerArray, ExceptionHandler[] exceptionHandlerArray2) {
        if (exceptionHandlerArray.length == 0) {
            return exceptionHandlerArray2;
        }
        if (exceptionHandlerArray2.length == 0) {
            return exceptionHandlerArray;
        }
        ExceptionHandler[] exceptionHandlerArray3 = new ExceptionHandler[exceptionHandlerArray.length + exceptionHandlerArray2.length];
        System.arraycopy(exceptionHandlerArray, 0, exceptionHandlerArray3, 0, exceptionHandlerArray.length);
        System.arraycopy(exceptionHandlerArray2, 0, exceptionHandlerArray3, exceptionHandlerArray.length, exceptionHandlerArray2.length);
        return exceptionHandlerArray3;
    }

    public void beginPass() {
        this.verifyState(1);
        this.state = 2;
        this.nextLabel = this.instructions.length;
        this.beforePatches = new Patch[this.instructions.length];
        this.afterPatches = new Patch[this.instructions.length];
        this.lastAfterPatches = new Patch[this.instructions.length];
        this.replacementPatches = new Patch[this.instructions.length];
        this.instructionHandlerPatches = new HandlerPatch[this.instructions.length];
        this.methodStartPatches = null;
        this.afterMethodPatches = null;
        this.methodHandlerPatches = null;
        this.patchCount = 0;
    }

    public void endPass() {
        this.state = 1;
        this.beforePatches = null;
        this.afterPatches = null;
        this.lastAfterPatches = null;
        this.replacementPatches = null;
        this.instructionHandlerPatches = null;
        this.methodStartPatches = null;
        this.afterMethodPatches = null;
        this.methodHandlerPatches = null;
    }

    public int allocateLabel() throws IllegalArgumentException {
        this.verifyState(2);
        return this.nextLabel++;
    }

    public void insertAtStart(Patch patch) {
        if (patch == null) {
            throw new IllegalArgumentException("p is null");
        }
        this.verifyState(2);
        this.methodStartPatches = patch.insert(this.methodStartPatches);
        ++this.patchCount;
    }

    public void insertBefore(int n, Patch patch) {
        if (patch == null) {
            throw new IllegalArgumentException("p is null");
        }
        this.verifyState(2);
        this.beforePatches[n] = patch.insert(this.beforePatches[n]);
        ++this.patchCount;
    }

    public void insertAfter(int n, Patch patch) {
        this.verifyState(2);
        try {
            if (this.afterPatches[n] == null) {
                this.lastAfterPatches[n] = this.afterPatches[n] = patch.insert(null);
            } else {
                this.lastAfterPatches[n].next = patch;
                this.lastAfterPatches[n] = patch.insert(null);
            }
            ++this.patchCount;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid i");
        }
    }

    public void replaceWith(int n, Patch patch) throws NullPointerException {
        if (patch == null) {
            throw new IllegalArgumentException("p is null");
        }
        this.verifyState(2);
        if (this.replacementPatches[n] != null) {
            throw new IllegalArgumentException("Instruction " + n + " cannot be replaced more than once");
        }
        this.replacementPatches[n] = patch.insert(null);
        ++this.patchCount;
    }

    public void addInstructionExceptionHandler(int n, String string, Patch patch) {
        this.verifyState(2);
        try {
            this.instructionHandlerPatches[n] = new HandlerPatch(this.instructionHandlerPatches[n], string, this.allocateLabel(), patch);
            ++this.patchCount;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid i: " + n);
        }
    }

    public void addMethodExceptionHandler(String string, Patch patch) {
        this.verifyState(2);
        if (patch == null) {
            throw new IllegalArgumentException("null p");
        }
        this.methodHandlerPatches = new HandlerPatch(this.methodHandlerPatches, string, this.allocateLabel(), patch);
        ++this.patchCount;
    }

    public void insertAfterBody(Patch patch) {
        if (patch == null) {
            throw new IllegalArgumentException("p is null");
        }
        this.verifyState(2);
        this.afterMethodPatches = patch.insert(this.afterMethodPatches);
        ++this.patchCount;
    }

    public MethodData getData() {
        return this.methodInfo;
    }

    private static ExceptionHandler[] makeExceptionArray(HandlerPatch exceptionHandlerArray) {
        if (exceptionHandlerArray == null) {
            return noHandlers;
        }
        int n = 0;
        ExceptionHandler[] exceptionHandlerArray2 = exceptionHandlerArray;
        while (exceptionHandlerArray2 != null) {
            ++n;
            exceptionHandlerArray2 = exceptionHandlerArray2.next;
        }
        exceptionHandlerArray2 = new ExceptionHandler[n];
        n = 0;
        Object object = exceptionHandlerArray;
        while (object != null) {
            exceptionHandlerArray2[n] = new ExceptionHandler(object.label, object.catchClass);
            ++n;
            object = object.next;
        }
        return exceptionHandlerArray2;
    }

    public boolean applyPatches() throws IllegalArgumentException {
        ExceptionHandler[] exceptionHandlerArray;
        ExceptionHandler[] exceptionHandlerArray2;
        this.verifyState(2);
        this.state = 4;
        if (this.patchCount == 0) {
            this.state = 8;
            return false;
        }
        Output output = new Output(this.nextLabel);
        int[] nArray = new int[this.instructions.length];
        output.additionalHandlers = noHandlers;
        output.originalBytecode = 0;
        ExceptionHandler[] exceptionHandlerArray3 = this.methodStartPatches;
        while (exceptionHandlerArray3 != null) {
            exceptionHandlerArray3.emitTo(output);
            exceptionHandlerArray3 = exceptionHandlerArray3.next;
        }
        exceptionHandlerArray3 = MethodEditor.makeExceptionArray(this.methodHandlerPatches);
        if (exceptionHandlerArray3.length > 0) {
            output.codeChanged = true;
        }
        int n = 0;
        while (n < this.instructions.length) {
            exceptionHandlerArray2 = MethodEditor.mergeHandlers(this.handlers[n], exceptionHandlerArray3);
            HandlerPatch handlerPatch = this.instructionHandlerPatches[n];
            output.emitLabel(n);
            output.originalBytecode = this.instructionsToBytecodes[n];
            output.additionalHandlers = exceptionHandlerArray2;
            Patch patch = this.beforePatches[n];
            while (patch != null) {
                patch.emitTo(output);
                patch = patch.next;
            }
            output.additionalHandlers = MethodEditor.mergeHandlers(MethodEditor.makeExceptionArray(handlerPatch), exceptionHandlerArray2);
            patch = this.replacementPatches[n];
            if (patch == null) {
                nArray[n] = output.newInstructions.size();
                output.internalEmitInstruction(this.instructions[n]);
            } else {
                output.codeChanged = true;
                nArray[n] = -1;
                patch.emitTo(output);
            }
            output.additionalHandlers = exceptionHandlerArray2;
            exceptionHandlerArray = this.afterPatches[n];
            while (exceptionHandlerArray != null) {
                exceptionHandlerArray.emitTo(output);
                exceptionHandlerArray = exceptionHandlerArray.next;
            }
            if (handlerPatch != null) {
                output.codeChanged = true;
                exceptionHandlerArray = GotoInstruction.make(n + 1);
                output.internalEmitInstruction((IInstruction)exceptionHandlerArray);
                HandlerPatch handlerPatch2 = handlerPatch;
                while (handlerPatch2 != null) {
                    output.additionalHandlers = MethodEditor.mergeHandlers(MethodEditor.makeExceptionArray(handlerPatch2.next), exceptionHandlerArray2);
                    output.emitLabel(handlerPatch2.label);
                    handlerPatch2.patch.emitTo(output);
                    output.internalEmitInstruction((IInstruction)exceptionHandlerArray);
                    handlerPatch2 = handlerPatch2.next;
                }
            }
            ++n;
        }
        output.originalBytecode = 0;
        Object object = this.methodHandlerPatches;
        while (object != null) {
            output.additionalHandlers = MethodEditor.makeExceptionArray(((HandlerPatch)object).next);
            output.emitLabel(((HandlerPatch)object).label);
            ((HandlerPatch)object).patch.emitTo(output);
            object = ((HandlerPatch)object).next;
        }
        output.additionalHandlers = noHandlers;
        object = this.afterMethodPatches;
        while (object != null) {
            ((Patch)object).emitTo(output);
            object = ((Patch)object).next;
        }
        this.state = 8;
        if (!output.codeChanged) {
            return false;
        }
        this.instructions = new Instruction[output.newInstructions.size()];
        this.handlers = new ExceptionHandler[this.instructions.length][];
        this.instructionsToBytecodes = new int[this.instructions.length];
        output.newInstructions.toArray(this.instructions);
        output.newInstructionHandlers.toArray((T[])this.handlers);
        System.arraycopy(output.instructionsToBytecodes, 0, this.instructionsToBytecodes, 0, this.instructionsToBytecodes.length);
        object = output.labelDefs;
        exceptionHandlerArray2 = (ExceptionHandler[])new int[this.instructions.length];
        int n2 = 0;
        while (n2 < this.instructions.length) {
            this.instructions[n2] = this.instructions[n2].redirectTargets((int[])object);
            exceptionHandlerArray2[n2] = (ExceptionHandler)-1;
            ++n2;
        }
        IdentityHashMap identityHashMap = null;
        int n3 = 0;
        while (n3 < this.handlers.length) {
            exceptionHandlerArray = this.handlers[n3];
            if (exceptionHandlerArray.length > 0 && (n3 == 0 || exceptionHandlerArray != this.handlers[n3 - 1])) {
                if (identityHashMap == null) {
                    identityHashMap = new IdentityHashMap();
                }
                int n4 = 0;
                while (n4 < exceptionHandlerArray.length) {
                    ExceptionHandler exceptionHandler = exceptionHandlerArray[n4];
                    if (!identityHashMap.containsKey(exceptionHandler)) {
                        identityHashMap.put(exceptionHandler, null);
                        exceptionHandler.handler = (int)object[exceptionHandler.handler];
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        if (this.methodInfo != null) {
            n3 = 0;
            while (n3 < nArray.length) {
                if (nArray[n3] != -1) {
                    exceptionHandlerArray2[nArray[n3]] = (ExceptionHandler)n3;
                }
                ++n3;
            }
            this.methodInfo.update(this.instructions, this.handlers, (int[])exceptionHandlerArray2, this.instructionsToBytecodes);
        }
        return true;
    }

    public void visitInstructions(Visitor visitor) {
        this.verifyState(2);
        int n = 0;
        while (n < this.instructions.length) {
            visitor.setIndex(this, n);
            this.instructions[n].visit(visitor);
            ++n;
        }
    }

    private static class HandlerPatch {
        final HandlerPatch next;
        final String catchClass;
        final int label;
        final Patch patch;

        HandlerPatch(HandlerPatch handlerPatch, String string, int n, Patch patch) {
            this.next = handlerPatch;
            this.catchClass = string;
            this.label = n;
            this.patch = patch;
        }
    }

    public static final class Output {
        final ArrayList<IInstruction> newInstructions = new ArrayList();
        final ArrayList<ExceptionHandler[]> newInstructionHandlers = new ArrayList();
        int[] instructionsToBytecodes = new int[10];
        final int[] labelDefs;
        ExceptionHandler[] additionalHandlers;
        int originalBytecode;
        boolean codeChanged = false;

        Output(int n) {
            this.labelDefs = new int[n];
        }

        public void emitLabel(int n) {
            this.labelDefs[n] = this.newInstructions.size();
        }

        public void emit(Instruction instruction) {
            this.codeChanged = true;
            this.internalEmitInstruction(instruction);
        }

        public void emit(Instruction instruction, ExceptionHandler[] exceptionHandlerArray) {
            this.codeChanged = true;
            int n = this.newInstructions.size();
            if (n + 1 > this.instructionsToBytecodes.length) {
                int[] nArray = new int[this.instructionsToBytecodes.length * 2];
                System.arraycopy(this.instructionsToBytecodes, 0, nArray, 0, this.instructionsToBytecodes.length);
                this.instructionsToBytecodes = nArray;
            }
            this.instructionsToBytecodes[n] = this.originalBytecode;
            this.newInstructions.add(instruction);
            this.newInstructionHandlers.add(MethodEditor.mergeHandlers(exceptionHandlerArray, this.additionalHandlers));
        }

        void internalEmitInstruction(IInstruction iInstruction) {
            int n = this.newInstructions.size();
            if (n + 1 > this.instructionsToBytecodes.length) {
                int[] nArray = new int[this.instructionsToBytecodes.length * 2];
                System.arraycopy(this.instructionsToBytecodes, 0, nArray, 0, this.instructionsToBytecodes.length);
                this.instructionsToBytecodes = nArray;
            }
            this.instructionsToBytecodes[n] = this.originalBytecode;
            this.newInstructions.add(iInstruction);
            this.newInstructionHandlers.add(this.additionalHandlers);
        }

        public void emit(Instruction[] instructionArray) {
            this.emit(instructionArray, noHandlers);
        }

        public void emit(Instruction[] instructionArray, ExceptionHandler[] exceptionHandlerArray) {
            Object[] objectArray;
            if (instructionArray.length == 0) {
                return;
            }
            this.codeChanged = true;
            int n = this.newInstructions.size();
            if (n + instructionArray.length > this.instructionsToBytecodes.length) {
                objectArray = new int[this.instructionsToBytecodes.length * 2 + instructionArray.length];
                System.arraycopy(this.instructionsToBytecodes, 0, objectArray, 0, this.instructionsToBytecodes.length);
                this.instructionsToBytecodes = (int[])objectArray;
            }
            objectArray = MethodEditor.mergeHandlers(exceptionHandlerArray, this.additionalHandlers);
            int n2 = 0;
            while (n2 < instructionArray.length) {
                this.instructionsToBytecodes[n + n2] = this.originalBytecode;
                this.newInstructions.add(instructionArray[n2]);
                this.newInstructionHandlers.add((ExceptionHandler[])objectArray);
                ++n2;
            }
        }
    }

    public static abstract class Patch {
        Patch next;

        final Patch insert(Patch patch) {
            this.next = patch;
            return this;
        }

        public abstract void emitTo(Output var1);
    }

    public static class Visitor
    extends IInstruction.Visitor {
        private int index;
        private MethodEditor editor;

        public final void setIndex(MethodEditor methodEditor, int n) {
            this.index = n;
            this.editor = methodEditor;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void insertAfter(Patch patch) {
            this.editor.insertAfter(this.index, patch);
        }

        public final void insertBefore(Patch patch) {
            this.editor.insertBefore(this.index, patch);
        }

        public final void replaceWith(Patch patch) {
            this.editor.replaceWith(this.index, patch);
        }

        public final void addInstructionExceptionHandler(String string, Patch patch) {
            this.editor.addInstructionExceptionHandler(this.index, string, patch);
        }
    }
}

