/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.ConstantPoolReader;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public class InvokeInstruction
extends Instruction
implements IInvokeInstruction {
    protected String type;
    protected String classType;
    protected String methodName;

    InvokeInstruction(short s, String string, String string2, String string3) {
        super(s);
        this.type = string;
        this.classType = string2;
        this.methodName = string3;
    }

    public static InvokeInstruction make(String string, String string2, String string3, IInvokeInstruction.Dispatch dispatch) throws NullPointerException {
        if (string == null) {
            throw new NullPointerException("type must not be null");
        }
        if (string2 == null) {
            throw new NullPointerException("className must not be null");
        }
        if (string3 == null) {
            throw new NullPointerException("methodName must not be null");
        }
        if (dispatch == null) {
            throw new NullPointerException("mode must not be null");
        }
        short s = 0;
        switch (dispatch) {
            case VIRTUAL: {
                s = 182;
                break;
            }
            case SPECIAL: {
                s = 183;
                break;
            }
            case STATIC: {
                s = 184;
                break;
            }
            case INTERFACE: {
                s = 185;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return new InvokeInstruction(s, string, string2, string3);
    }

    ConstantPoolReader getLazyConstantPool() {
        return null;
    }

    static InvokeInstruction make(ConstantPoolReader constantPoolReader, int n, int n2) {
        if (n2 < 182 || n2 > 185) {
            throw new IllegalArgumentException("Unknown mode: " + n2);
        }
        return new Lazy((short)n2, constantPoolReader, n);
    }

    public final boolean equals(Object object) {
        if (object instanceof InvokeInstruction) {
            InvokeInstruction invokeInstruction = (InvokeInstruction)object;
            return invokeInstruction.getMethodSignature().equals(this.getMethodSignature()) && invokeInstruction.getClassType().equals(this.getClassType()) && invokeInstruction.getMethodName().equals(this.getMethodName()) && invokeInstruction.opcode == this.opcode;
        }
        return false;
    }

    public String getClassType() {
        return this.classType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodSignature() {
        return this.type;
    }

    public final int getInvocationMode() {
        return this.opcode;
    }

    public final String getInvocationModeString() {
        switch (this.opcode) {
            case 184: {
                return "STATIC";
            }
            case 185: {
                return "INTERFACE";
            }
            case 183: {
                return "SPECIAL";
            }
            case 182: {
                return "VIRTUAL";
            }
        }
        throw new Error("Unknown mode: " + this.opcode);
    }

    public final int hashCode() {
        return this.getMethodSignature().hashCode() + 9011 * this.getClassType().hashCode() + 317 * this.getMethodName().hashCode() + this.opcode * 3188;
    }

    public final int getPoppedCount() {
        return (this.opcode == 184 ? 0 : 1) + Util.getParamsCount(this.getMethodSignature());
    }

    public final String getPushedType(String[] stringArray) {
        String string = Util.getReturnType(this.getMethodSignature());
        if (string.equals("V")) {
            return null;
        }
        return string;
    }

    public final byte getPushedWordSize() {
        String string = this.getMethodSignature();
        int n = string.lastIndexOf(41);
        return Util.getWordSize(string, n + 1);
    }

    public final void visit(IInstruction.Visitor visitor) throws NullPointerException {
        visitor.visitInvoke(this);
    }

    public final String toString() {
        return "Invoke(" + this.getInvocationModeString() + "," + this.getClassType() + "," + this.getMethodName() + "," + this.getMethodSignature() + ")";
    }

    public boolean isPEI() {
        return true;
    }

    public IInvokeInstruction.Dispatch getInvocationCode() {
        switch (this.opcode) {
            case 184: {
                return IInvokeInstruction.Dispatch.STATIC;
            }
            case 185: {
                return IInvokeInstruction.Dispatch.INTERFACE;
            }
            case 183: {
                return IInvokeInstruction.Dispatch.SPECIAL;
            }
            case 182: {
                return IInvokeInstruction.Dispatch.VIRTUAL;
            }
        }
        throw new Error("Unknown mode: " + this.opcode);
    }

    static final class Lazy
    extends InvokeInstruction {
        private final ConstantPoolReader cp;
        private final int index;

        Lazy(short s, ConstantPoolReader constantPoolReader, int n) {
            super(s, null, null, null);
            this.index = n;
            this.cp = constantPoolReader;
        }

        ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        int getCPIndex() {
            return this.index;
        }

        public String getClassType() {
            if (this.classType == null) {
                this.classType = this.cp.getConstantPoolMemberClassType(this.index);
            }
            return this.classType;
        }

        public String getMethodName() {
            if (this.methodName == null) {
                this.methodName = this.cp.getConstantPoolMemberName(this.index);
            }
            return this.methodName;
        }

        public String getMethodSignature() {
            if (this.type == null) {
                this.type = this.cp.getConstantPoolMemberType(this.index);
            }
            return this.type;
        }
    }
}

