/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;

public final class GotoInstruction
extends Instruction {
    private final int[] label;
    private static final GotoInstruction[] preallocated = GotoInstruction.preallocate();

    protected GotoInstruction(int n) {
        super((short)167);
        int[] nArray = new int[]{n};
        this.label = nArray;
    }

    private static GotoInstruction[] preallocate() {
        GotoInstruction[] gotoInstructionArray = new GotoInstruction[256];
        int n = 0;
        while (n < gotoInstructionArray.length) {
            gotoInstructionArray[n] = new GotoInstruction(n);
            ++n;
        }
        return gotoInstructionArray;
    }

    public static GotoInstruction make(int n) {
        if (n >= 0 && n < preallocated.length) {
            return preallocated[n];
        }
        return new GotoInstruction(n);
    }

    public boolean isFallThrough() {
        return false;
    }

    public int[] getBranchTargets() {
        return this.label;
    }

    public int getLabel() {
        return this.label[0];
    }

    public IInstruction redirectTargets(int[] nArray) throws IllegalArgumentException {
        if (nArray == null) {
            throw new IllegalArgumentException("targetMap is null");
        }
        try {
            return GotoInstruction.make(nArray[this.label[0]]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Illegal target map", arrayIndexOutOfBoundsException);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof GotoInstruction) {
            GotoInstruction gotoInstruction = (GotoInstruction)object;
            return gotoInstruction.label == this.label;
        }
        return false;
    }

    public int hashCode() {
        return this.label[0] * 1348091 + 18301;
    }

    public String toString() {
        return "Goto(" + this.getLabel() + ")";
    }

    public void visit(IInstruction.Visitor visitor) throws IllegalArgumentException {
        if (visitor == null) {
            throw new IllegalArgumentException();
        }
        visitor.visitGoto(this);
    }

    public boolean isPEI() {
        return false;
    }
}

