/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.ConstantPoolReader;
import com.ibm.wala.shrikeBT.IGetInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public class GetInstruction
extends Instruction
implements IGetInstruction {
    protected String type;
    protected String classType;
    protected String fieldName;

    GetInstruction(short s, String string, String string2, String string3) {
        super(s);
        this.type = string;
        this.classType = string2;
        this.fieldName = string3;
    }

    ConstantPoolReader getLazyConstantPool() {
        return null;
    }

    static GetInstruction make(ConstantPoolReader constantPoolReader, int n, boolean bl) {
        return new Lazy(bl ? (short)178 : 180, constantPoolReader, n);
    }

    public static GetInstruction make(String string, String string2, String string3, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("className must not be null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        return new GetInstruction(bl ? (short)178 : 180, string, string2, string3);
    }

    public final boolean equals(Object object) {
        if (object instanceof GetInstruction) {
            GetInstruction getInstruction = (GetInstruction)object;
            return getInstruction.getFieldType().equals(this.getFieldType()) && getInstruction.getClassType().equals(this.getClassType()) && getInstruction.getFieldName().equals(this.getFieldName()) && getInstruction.opcode == this.opcode;
        }
        return false;
    }

    public String getClassType() {
        return this.classType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldType() {
        return this.type;
    }

    public final boolean isStatic() {
        return this.opcode == 178;
    }

    public final int hashCode() {
        return this.getClassType().hashCode() + 11113 * this.getFieldType().hashCode() + 398011 * this.getFieldName().hashCode() + this.opcode;
    }

    public final int getPoppedCount() {
        return this.isStatic() ? 0 : 1;
    }

    public final String getPushedType(String[] stringArray) {
        return this.getFieldType();
    }

    public final byte getPushedWordSize() {
        return Util.getWordSize(this.getFieldType());
    }

    public String toString() {
        return "Get(" + this.getFieldType() + "," + (this.isStatic() ? "STATIC" : "NONSTATIC") + "," + this.getClassType() + "," + this.getFieldName() + ")";
    }

    public void visit(IInstruction.Visitor visitor) throws IllegalArgumentException {
        if (visitor == null) {
            throw new IllegalArgumentException();
        }
        visitor.visitGet(this);
    }

    public boolean isPEI() {
        return !this.isStatic();
    }

    public boolean isAddressOf() {
        return false;
    }

    static final class Lazy
    extends GetInstruction {
        private final ConstantPoolReader cp;
        private final int index;

        Lazy(short s, ConstantPoolReader constantPoolReader, int n) {
            super(s, null, null, null);
            this.index = n;
            this.cp = constantPoolReader;
        }

        ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        int getCPIndex() {
            return this.index;
        }

        public String getClassType() {
            if (this.classType == null) {
                this.classType = this.cp.getConstantPoolMemberClassType(this.index);
            }
            return this.classType;
        }

        public String getFieldName() {
            if (this.fieldName == null) {
                this.fieldName = this.cp.getConstantPoolMemberName(this.index);
            }
            return this.fieldName;
        }

        public String getFieldType() {
            if (this.type == null) {
                this.type = this.cp.getConstantPoolMemberType(this.index);
            }
            return this.type;
        }
    }
}

