/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;

public final class DupInstruction
extends Instruction {
    private final int size;
    private final byte delta;
    private static final DupInstruction[] preallocated = DupInstruction.preallocate();

    protected DupInstruction(byte by, byte by2) {
        super((short)-1);
        this.size = by;
        this.delta = by2;
    }

    private static DupInstruction[] preallocate() {
        DupInstruction[] dupInstructionArray = new DupInstruction[9];
        int n = 0;
        while (n < dupInstructionArray.length) {
            dupInstructionArray[n] = new DupInstruction((byte)(n / 3), (byte)(n % 3));
            ++n;
        }
        return dupInstructionArray;
    }

    static DupInstruction make(int n, int n2) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Invalid dup size: " + n);
        }
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("Invalid dup delta: " + n2);
        }
        return preallocated[n * 3 + n2];
    }

    public static DupInstruction make(int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("Invalid dup delta: " + n);
        }
        return DupInstruction.make(1, n);
    }

    public boolean equals(Object object) {
        if (object instanceof DupInstruction) {
            DupInstruction dupInstruction = (DupInstruction)object;
            return dupInstruction.size == this.size && dupInstruction.delta == this.delta;
        }
        return false;
    }

    public int getSize() {
        return this.size;
    }

    public int getDelta() {
        return this.delta;
    }

    public int hashCode() {
        return this.size + 8431890 + 10 * this.delta;
    }

    public int getPoppedCount() {
        return this.size + this.delta;
    }

    public String toString() {
        return "Dup(" + this.size + "," + this.delta + ")";
    }

    public void visit(IInstruction.Visitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("illegal null visitor");
        }
        visitor.visitDup(this);
    }

    public boolean isPEI() {
        return false;
    }
}

