/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public final class ConditionalBranchInstruction
extends Instruction
implements IConditionalBranchInstruction {
    private final int label;

    protected ConditionalBranchInstruction(short s, int n) {
        super(s);
        this.label = n;
    }

    public static ConditionalBranchInstruction make(String string, IConditionalBranchInstruction.Operator operator, int n) throws IllegalArgumentException {
        short s;
        int n2 = Util.getTypeIndex(string);
        switch (n2) {
            case 0: {
                s = (short)(159 + (operator.ordinal() - IConditionalBranchInstruction.Operator.EQ.ordinal()));
                break;
            }
            case 4: {
                if (operator != IConditionalBranchInstruction.Operator.EQ && operator != IConditionalBranchInstruction.Operator.NE) {
                    throw new IllegalArgumentException("Cannot test for condition " + operator + " on a reference");
                }
                s = (short)(165 + (operator.ordinal() - IConditionalBranchInstruction.Operator.EQ.ordinal()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot conditionally branch on a value of type " + string);
            }
        }
        return ConditionalBranchInstruction.make(s, n);
    }

    public static ConditionalBranchInstruction make(short s, int n) throws IllegalArgumentException {
        if (s < 153 || s > 166) {
            throw new IllegalArgumentException("Illegal opcode: " + s);
        }
        return new ConditionalBranchInstruction(s, n);
    }

    public boolean equals(Object object) {
        if (object instanceof ConditionalBranchInstruction) {
            ConditionalBranchInstruction conditionalBranchInstruction = (ConditionalBranchInstruction)object;
            return conditionalBranchInstruction.opcode == this.opcode && conditionalBranchInstruction.label == this.label;
        }
        return false;
    }

    public String toString() {
        return "ConditionalBranch(" + this.getType() + "," + this.getOperator() + "," + this.label + ")";
    }

    public int[] getBranchTargets() {
        int[] nArray = new int[]{this.label};
        return nArray;
    }

    public int getTarget() {
        return this.label;
    }

    public IInstruction redirectTargets(int[] nArray) throws IllegalArgumentException {
        if (nArray == null) {
            throw new IllegalArgumentException("targetMap is null");
        }
        try {
            return ConditionalBranchInstruction.make(this.opcode, nArray[this.label]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("bad target map", arrayIndexOutOfBoundsException);
        }
    }

    public IConditionalBranchInstruction.Operator getOperator() {
        if (this.opcode < 165) {
            return IConditionalBranchInstruction.Operator.values()[this.opcode - 159];
        }
        return IConditionalBranchInstruction.Operator.values()[this.opcode - 165];
    }

    public String getType() {
        return this.opcode < 165 ? "I" : "Ljava/lang/Object;";
    }

    public int hashCode() {
        return 30190 * this.opcode + 384101 * this.label;
    }

    public int getPoppedCount() {
        if (this.opcode >= 153 && this.opcode <= 158) {
            return 1;
        }
        return 2;
    }

    public void visit(IInstruction.Visitor visitor) throws NullPointerException {
        visitor.visitConditionalBranch(this);
    }

    public boolean isPEI() {
        return false;
    }
}

