/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeBT.IArrayStoreInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public final class ArrayStoreInstruction
extends Instruction
implements IArrayStoreInstruction {
    private static final ArrayStoreInstruction[] preallocated = ArrayStoreInstruction.preallocate();

    protected ArrayStoreInstruction(short s) {
        super(s);
    }

    private static ArrayStoreInstruction[] preallocate() {
        ArrayStoreInstruction[] arrayStoreInstructionArray = new ArrayStoreInstruction[9];
        short s = 79;
        while (s <= 86) {
            arrayStoreInstructionArray[s - 79] = new ArrayStoreInstruction(s);
            s = (short)(s + 1);
        }
        arrayStoreInstructionArray[8] = arrayStoreInstructionArray[5];
        return arrayStoreInstructionArray;
    }

    public static ArrayStoreInstruction make(String string) throws IllegalArgumentException {
        int n = Util.getTypeIndex(string);
        if (n < 0 || n > 8) {
            throw new IllegalArgumentException("Invalid type " + string + " for ArrayStoreInstruction");
        }
        return preallocated[n];
    }

    public boolean equals(Object object) {
        if (object instanceof ArrayStoreInstruction) {
            ArrayStoreInstruction arrayStoreInstruction = (ArrayStoreInstruction)object;
            return arrayStoreInstruction.opcode == this.opcode;
        }
        return false;
    }

    public int hashCode() {
        return this.opcode + 148791;
    }

    public int getPoppedCount() {
        return 3;
    }

    public String getType() {
        return Decoder.indexedTypes[this.opcode - 79];
    }

    public String toString() {
        return "ArrayStore(" + this.getType() + ")";
    }

    public void visit(IInstruction.Visitor visitor) throws NullPointerException {
        visitor.visitArrayStore(this);
    }

    public boolean isPEI() {
        return true;
    }
}

