/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.Constants;
import com.ibm.wala.shrikeBT.IArrayLoadInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public final class ArrayLoadInstruction
extends Instruction
implements IArrayLoadInstruction {
    private static final ArrayLoadInstruction[] preallocated = ArrayLoadInstruction.preallocate();

    protected ArrayLoadInstruction(short s) {
        super(s);
    }

    private static ArrayLoadInstruction[] preallocate() {
        ArrayLoadInstruction[] arrayLoadInstructionArray = new ArrayLoadInstruction[9];
        short s = 46;
        while (s <= 53) {
            arrayLoadInstructionArray[s - 46] = new ArrayLoadInstruction(s);
            s = (short)(s + 1);
        }
        arrayLoadInstructionArray[8] = arrayLoadInstructionArray[5];
        return arrayLoadInstructionArray;
    }

    public static ArrayLoadInstruction make(String string) throws IllegalArgumentException {
        int n = Util.getTypeIndex(string);
        if (n < 0 || n > 8) {
            throw new IllegalArgumentException("Invalid type " + string + " for ArrayLoadInstruction");
        }
        return preallocated[n];
    }

    public boolean equals(Object object) {
        if (object instanceof ArrayLoadInstruction) {
            ArrayLoadInstruction arrayLoadInstruction = (ArrayLoadInstruction)object;
            return arrayLoadInstruction.opcode == this.opcode;
        }
        return false;
    }

    public int hashCode() {
        return this.opcode + 9109101;
    }

    public int getPoppedCount() {
        return 2;
    }

    public String toString() {
        return "ArrayLoad(" + this.getType() + ")";
    }

    public String getPushedType(String[] stringArray) throws IllegalArgumentException {
        if (stringArray == null) {
            return this.getType();
        }
        if (stringArray.length <= 1) {
            throw new IllegalArgumentException("types.length <= 1");
        }
        String string = stringArray[1];
        if (string == null) {
            throw new IllegalArgumentException("types[1] cannot be null");
        }
        if (string.startsWith("[")) {
            return string.substring(1);
        }
        if (string.equals("L;")) {
            return "L;";
        }
        return "L?;";
    }

    public byte getPushedWordSize() {
        return Util.getWordSize(this.getType());
    }

    public String getType() {
        return Constants.indexedTypes[this.opcode - 46];
    }

    public void visit(IInstruction.Visitor visitor) throws NullPointerException {
        visitor.visitArrayLoad(this);
    }

    public boolean isPEI() {
        return true;
    }

    public boolean isAddressOf() {
        return false;
    }
}

