/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.bench;

import com.ibm.wala.shrikeBT.ConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.Disassembler;
import com.ibm.wala.shrikeBT.GetInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.MethodEditor;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeBT.ThrowInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.analysis.Verifier;
import com.ibm.wala.shrikeBT.shrikeCT.CTDecoder;
import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrikeCT.ClassWriter;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.Writer;

public class Bench {
    private static final boolean disasm = true;
    private static final boolean verify = true;
    private static OfflineInstrumenter instrumenter;
    private static final boolean doEntry = true;
    private static boolean doExit;
    private static boolean doException;
    static final String fieldName = "_Bench_enable_trace";
    static final Instruction getSysErr;
    static final Instruction callPrintln;

    static {
        doExit = false;
        doException = false;
        getSysErr = Util.makeGet(System.class, "err");
        callPrintln = Util.makeInvoke(PrintStream.class, "println", new Class[]{String.class});
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        while (n < 1) {
            ClassInstrumenter classInstrumenter;
            instrumenter = new OfflineInstrumenter();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("report", false));
            if ((stringArray = instrumenter.parseStandardArgs(stringArray)).length > 0) {
                if (stringArray[0].equals("-doexit")) {
                    doExit = true;
                } else if (stringArray[0].equals("-doexception")) {
                    doExit = true;
                    doException = true;
                }
            }
            instrumenter.setPassUnmodifiedClasses(true);
            instrumenter.beginTraversal();
            while ((classInstrumenter = instrumenter.nextClass()) != null) {
                Bench.doClass(classInstrumenter, bufferedWriter);
            }
            instrumenter.close();
            ++n;
        }
    }

    private static void doClass(ClassInstrumenter classInstrumenter, Writer writer) throws Exception {
        final String string = classInstrumenter.getReader().getName();
        writer.write("Class: " + string + "\n");
        writer.flush();
        int n = 0;
        while (n < classInstrumenter.getReader().getMethodCount()) {
            MethodData methodData = classInstrumenter.visitMethod(n);
            if (methodData != null) {
                writer.write("Instrumenting " + classInstrumenter.getReader().getMethodName(n) + " " + classInstrumenter.getReader().getMethodType(n) + ":\n");
                writer.flush();
                writer.write("Initial ShrikeBT code:\n");
                new Disassembler(methodData).disassembleTo(writer);
                writer.flush();
                Object object = new Verifier(methodData);
                ((Verifier)object).verify();
                object = new MethodEditor(methodData);
                ((MethodEditor)object).beginPass();
                final String string2 = "Entering call to " + Util.makeClass("L" + classInstrumenter.getReader().getName() + ";") + "." + classInstrumenter.getReader().getMethodName(n);
                final int n2 = ((MethodEditor)object).allocateLabel();
                ((MethodEditor)object).insertAtStart(new MethodEditor.Patch(){

                    public void emitTo(MethodEditor.Output output) {
                        output.emit(GetInstruction.make("Z", CTDecoder.convertClassToType(string), Bench.fieldName, true));
                        output.emit(ConstantInstruction.make(0));
                        output.emit(ConditionalBranchInstruction.make("I", IConditionalBranchInstruction.Operator.EQ, n2));
                        output.emit(getSysErr);
                        output.emit(ConstantInstruction.makeString(string2));
                        output.emit(callPrintln);
                        output.emitLabel(n2);
                    }
                });
                if (doExit) {
                    string2 = "Exiting call to " + Util.makeClass("L" + classInstrumenter.getReader().getName() + ";") + "." + classInstrumenter.getReader().getMethodName(n);
                    IInstruction[] iInstructionArray = ((MethodEditor)object).getInstructions();
                    int n3 = 0;
                    while (n3 < iInstructionArray.length) {
                        if (iInstructionArray[n3] instanceof ReturnInstruction) {
                            final int n4 = ((MethodEditor)object).allocateLabel();
                            ((MethodEditor)object).insertBefore(n3, new MethodEditor.Patch(){

                                public void emitTo(MethodEditor.Output output) {
                                    output.emit(GetInstruction.make("Z", CTDecoder.convertClassToType(string), Bench.fieldName, true));
                                    output.emit(ConstantInstruction.make(0));
                                    output.emit(ConditionalBranchInstruction.make("I", IConditionalBranchInstruction.Operator.EQ, n4));
                                    output.emit(getSysErr);
                                    output.emit(ConstantInstruction.makeString(string2));
                                    output.emit(callPrintln);
                                    output.emitLabel(n4);
                                }
                            });
                        }
                        ++n3;
                    }
                }
                if (doException) {
                    string2 = "Exception exiting call to " + Util.makeClass("L" + classInstrumenter.getReader().getName() + ";") + "." + classInstrumenter.getReader().getMethodName(n);
                    n2 = ((MethodEditor)object).allocateLabel();
                    ((MethodEditor)object).addMethodExceptionHandler(null, new MethodEditor.Patch(){

                        public void emitTo(MethodEditor.Output output) {
                            output.emit(GetInstruction.make("Z", CTDecoder.convertClassToType(string), Bench.fieldName, true));
                            output.emit(ConstantInstruction.make(0));
                            output.emit(ConditionalBranchInstruction.make("I", IConditionalBranchInstruction.Operator.EQ, n2));
                            output.emit(getSysErr);
                            output.emit(ConstantInstruction.makeString(string2));
                            output.emit(callPrintln);
                            output.emitLabel(n2);
                            output.emit(ThrowInstruction.make(false));
                        }
                    });
                }
                ((MethodEditor)object).applyPatches();
                writer.write("Final ShrikeBT code:\n");
                new Disassembler(methodData).disassembleTo(writer);
                writer.flush();
            }
            ++n;
        }
        if (classInstrumenter.isChanged()) {
            ClassWriter classWriter = classInstrumenter.emitClass();
            classWriter.addField(9, fieldName, "Z", new ClassWriter.Element[0]);
            instrumenter.outputModifiedClass(classInstrumenter, classWriter);
        }
    }
}

