/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.viz.viewer;

import com.ibm.wala.analysis.pointers.HeapGraph;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceFieldPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.NodeKey;
import com.ibm.wala.ipa.callgraph.propagation.NormalAllocationInNode;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.util.intset.MutableMapping;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import com.ibm.wala.viz.viewer.DualTreeCellRenderer;
import com.ibm.wala.viz.viewer.IrAndSourceViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaPanel
extends JSplitPane {
    protected final PointerAnalysis pa;
    protected final CallGraph cg;
    private JTextField fullName;
    private IrAndSourceViewer irViewer;
    private MutableMapping<List<LocalPointerKey>> cgNodeIdToLocalPointers = MutableMapping.make();
    private MutableMapping<List<ReturnValueKey>> cgNodeIdToReturnValue = MutableMapping.make();
    private MutableMapping<List<InstanceFieldPointerKey>> instanceKeyIdToInstanceFieldPointers = MutableMapping.make();

    public PaPanel(CallGraph callGraph, PointerAnalysis pointerAnalysis) {
        super(1);
        this.pa = pointerAnalysis;
        this.cg = callGraph;
        this.initDataStructures(pointerAnalysis);
    }

    public void init() {
        Object object2;
        this.setDividerLocation(250);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        for (Object object2 : this.getRootNodes()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.expandNodeRec(defaultMutableTreeNode2, 1);
        }
        object2 = new JTree(defaultMutableTreeNode);
        ((JTree)object2).setCellRenderer(new DualTreeCellRenderer());
        this.setLeftComponent(new JScrollPane((Component)object2));
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setRightComponent(jPanel);
        this.fullName = new JTextField("");
        jPanel.add((Component)this.fullName, "First");
        this.irViewer = new IrAndSourceViewer(this.cg);
        jPanel.add(this.irViewer.getComponent(), "Center");
        ((JTree)object2).addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                TreePath treePath = treeExpansionEvent.getPath();
                if (treePath == null) {
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                PaPanel.this.expandNodeRec(defaultMutableTreeNode, 2);
            }

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }
        });
        ((JTree)object2).addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                if (treePath == null) {
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                Object object = defaultMutableTreeNode.getUserObject();
                PaPanel.this.fullName.setText(object.toString());
                if (object instanceof LocalPointerKey) {
                    LocalPointerKey localPointerKey = (LocalPointerKey)object;
                    IR iR = localPointerKey.getNode().getIR();
                    SSAInstruction sSAInstruction = localPointerKey.getNode().getDU().getDef(localPointerKey.getValueNumber());
                    int n = -1;
                    if (sSAInstruction != null) {
                        SSAInstruction[] sSAInstructionArray = iR.getInstructions();
                        int n2 = 0;
                        while (n2 < sSAInstructionArray.length) {
                            SSAInstruction sSAInstruction2 = sSAInstructionArray[n2];
                            if (sSAInstruction == sSAInstruction2) {
                                n = n2;
                            }
                            ++n2;
                        }
                    }
                    PaPanel.this.irViewer.setIRAndPc(iR, n);
                } else if (object instanceof InstanceFieldPointerKey) {
                    InstanceKey instanceKey = ((InstanceFieldPointerKey)object).getInstanceKey();
                    if (instanceKey instanceof NormalAllocationInNode) {
                        NormalAllocationInNode normalAllocationInNode = (NormalAllocationInNode)instanceKey;
                        IR iR = normalAllocationInNode.getNode().getIR();
                        int n = normalAllocationInNode.getSite().getProgramCounter();
                        PaPanel.this.irViewer.setIRAndPc(iR, n);
                    }
                } else if (object instanceof NormalAllocationInNode) {
                    NormalAllocationInNode normalAllocationInNode = (NormalAllocationInNode)object;
                    IR iR = normalAllocationInNode.getNode().getIR();
                    int n = normalAllocationInNode.getSite().getProgramCounter();
                    PaPanel.this.irViewer.setIRAndPc(iR, n);
                } else if (object instanceof CGNode) {
                    PaPanel.this.irViewer.setIR(((CGNode)object).getIR());
                }
            }
        });
    }

    private void initDataStructures(PointerAnalysis pointerAnalysis) {
        HeapGraph heapGraph = pointerAnalysis.getHeapGraph();
        OrdinalSetMapping<InstanceKey> ordinalSetMapping = pointerAnalysis.getInstanceKeyMapping();
        for (Object t : heapGraph) {
            if (heapGraph.getPredNodeCount(t) != 0) continue;
            if (t instanceof PointerKey) {
                int n;
                PointerKey pointerKey;
                if (t instanceof LocalPointerKey) {
                    pointerKey = (LocalPointerKey)t;
                    n = ((LocalPointerKey)pointerKey).getNode().getGraphNodeId();
                    PaPanel.mapUsingMutableMapping(this.cgNodeIdToLocalPointers, n, pointerKey);
                    continue;
                }
                if (t instanceof ReturnValueKey) {
                    pointerKey = (ReturnValueKey)t;
                    n = ((NodeKey)pointerKey).getNode().getGraphNodeId();
                    PaPanel.mapUsingMutableMapping(this.cgNodeIdToReturnValue, n, pointerKey);
                    continue;
                }
                if (!(t instanceof InstanceFieldPointerKey)) continue;
                pointerKey = (InstanceFieldPointerKey)t;
                n = ordinalSetMapping.getMappedIndex(pointerKey.getInstanceKey());
                PaPanel.mapUsingMutableMapping(this.instanceKeyIdToInstanceFieldPointers, n, pointerKey);
                continue;
            }
            System.err.println("Non Pointer key root: " + t);
        }
    }

    protected List<Object> getRootNodes() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (CGNode cGNode : this.cg) {
            arrayList.add(cGNode);
        }
        return arrayList;
    }

    private void expandNodeRec(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        if (n == 0) {
            return;
        }
        if (defaultMutableTreeNode.getChildCount() == 0) {
            List<Object> list = this.getChildrenFor(defaultMutableTreeNode.getUserObject());
            for (Object object : list) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(object));
            }
        }
        int n2 = 0;
        while (n2 < defaultMutableTreeNode.getChildCount()) {
            Object object;
            object = defaultMutableTreeNode.getChildAt(n2);
            this.expandNodeRec((DefaultMutableTreeNode)object, n - 1);
            ++n2;
        }
    }

    protected List<Object> getChildrenFor(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (object instanceof InstanceKey) {
            arrayList.addAll(this.getPointerKeysUnderInstanceKey((InstanceKey)object));
        } else if (object instanceof PointerKey) {
            for (InstanceKey instanceKey : this.pa.getPointsToSet((PointerKey)object)) {
                arrayList.add(instanceKey);
            }
        } else if (object instanceof CGNode) {
            int n = ((CGNode)object).getGraphNodeId();
            arrayList.addAll(this.nonNullList(this.cgNodeIdToLocalPointers.getMappedObject(n)));
            arrayList.addAll(this.nonNullList(this.cgNodeIdToReturnValue.getMappedObject(n)));
        } else assert (false) : "Unhandled Node : " + object;
        return arrayList;
    }

    protected List<? extends PointerKey> getPointerKeysUnderInstanceKey(InstanceKey instanceKey) {
        int n = this.pa.getInstanceKeyMapping().getMappedIndex(instanceKey);
        List<Object> list = n <= this.instanceKeyIdToInstanceFieldPointers.getMaximumIndex() ? this.nonNullList(this.instanceKeyIdToInstanceFieldPointers.getMappedObject(n)) : Collections.emptyList();
        return list;
    }

    protected static <T> void mapUsingMutableMapping(MutableMapping<List<T>> mutableMapping, int n, T t) {
        List<T> list = n <= mutableMapping.getMaximumIndex() ? mutableMapping.getMappedObject(n) : null;
        if (list == null) {
            list = new ArrayList<T>();
            mutableMapping.put(n, list);
        }
        list.add(t);
    }

    protected <T> List<T> nonNullList(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }
}

