/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.viz.viewer;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.util.collections.HashMapFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IrViewer
extends JPanel {
    private JTextField methodName;
    private DefaultListModel irLineList = new DefaultListModel();
    private JList irLines;
    private Map<Integer, Integer> lineToPosition = null;
    private Map<Integer, Integer> pcToLine = null;
    private Map<Integer, Integer> lineToPc = null;
    Set<SelectedPcListner> selectedPcListners = new HashSet<SelectedPcListner>();
    static final int NA = -1;

    public IrViewer() {
        super(new BorderLayout());
        this.irLines = new JList(this.irLineList);
        this.methodName = new JTextField("IR");
        this.add((Component)this.methodName, "First");
        this.add((Component)new JScrollPane(this.irLines, 20, 30), "Center");
        this.irLines.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = IrViewer.this.irLines.getSelectedIndex();
                Integer n2 = (Integer)IrViewer.this.lineToPc.get(n);
                if (n2 == null) {
                    n2 = -1;
                }
                for (SelectedPcListner selectedPcListner : IrViewer.this.selectedPcListners) {
                    selectedPcListner.valueChanged(n2);
                }
            }
        });
    }

    public void setIR(IR iR) {
        int n;
        block8: {
            this.lineToPosition = HashMapFactory.make();
            this.pcToLine = HashMapFactory.make();
            this.lineToPc = HashMapFactory.make();
            n = -1;
            try {
                String string;
                this.methodName.setText("IR: " + iR.getMethod());
                this.irLineList.clear();
                BufferedReader bufferedReader = new BufferedReader(new StringReader(iR.toString()));
                int n2 = 0;
                int n3 = -1;
                while ((string = bufferedReader.readLine()) != null) {
                    this.irLineList.addElement(string);
                    int n4 = this.parseIrLine(string);
                    if (n4 != -1) {
                        IMethod iMethod = iR.getMethod();
                        int n5 = iMethod.getLineNumber(n4);
                        if (n5 != -1) {
                            n3 = n5;
                        }
                        this.lineToPc.put(n2, n4);
                        this.pcToLine.put(n4, n2);
                        if (n3 != -1) {
                            this.lineToPosition.put(n2, n3);
                            if (n == -1) {
                                n = n2;
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
        if (n != -1) {
            this.irLines.setSelectedIndex(n);
            this.irLines.ensureIndexIsVisible(n);
        }
    }

    private int parseIrLine(String string) {
        int n = string.indexOf(32);
        if (n > 0) {
            String string2 = string.substring(0, n);
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return -1;
    }

    public void addSelectedPcListner(SelectedPcListner selectedPcListner) {
        this.selectedPcListners.add(selectedPcListner);
    }

    public void setPc(int n) {
        Integer n2 = this.pcToLine.get(n);
        if (n2 != null) {
            this.irLines.ensureIndexIsVisible(n2);
            this.irLines.setSelectedIndex(n2);
        } else {
            this.removeSelection();
        }
    }

    public void setIRAndPc(IR iR, int n) {
        this.setIR(iR);
        if (n != -1) {
            this.setPc(n);
        } else {
            this.removeSelection();
        }
    }

    private void removeSelection() {
        int n = this.irLines.getSelectedIndex();
        this.irLines.removeSelectionInterval(n, n);
    }

    public static interface SelectedPcListner {
        public void valueChanged(int var1);
    }
}

