/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.strings;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.ImmutableByteArray;
import java.io.UTFDataFormatException;

public abstract class UTF8Convert {
    static final boolean STRICTLY_CHECK_FORMAT = false;
    static final boolean ALLOW_NORMAL_UTF8 = false;
    static final boolean ALLOW_PSEUDO_UTF8 = true;
    static final boolean WRITE_PSEUDO_UTF8 = true;

    public static String fromUTF8(byte[] byArray) throws UTFDataFormatException {
        if (byArray == null) {
            throw new IllegalArgumentException("utf8 is null");
        }
        char[] cArray = new char[byArray.length];
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        while (n2 < n3) {
            byte by;
            if ((by = byArray[n2++]) >= 0) {
                cArray[n++] = (char)by;
                continue;
            }
            try {
                char c;
                byte by2 = byArray[n2++];
                if (by < -32) {
                    int n4 = n++;
                    char c2 = (char)((by & 0x1F) << 6 | by2 & 0x3F);
                    cArray[n4] = c2;
                    c = c2;
                    continue;
                }
                c = byArray[n2++];
                int n5 = n++;
                char c3 = (char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | c & 0x3F);
                cArray[n5] = c3;
                char c4 = c3;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new UTFDataFormatException("unexpected end at location " + n2);
            }
        }
        return new String(cArray, 0, n);
    }

    public static byte[] toUTF8(String string) {
        if (string == null) {
            throw new IllegalArgumentException("s is null");
        }
        byte[] byArray = new byte[UTF8Convert.utfLength(string)];
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            char c = string.charAt(n2);
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n++] = (byte)c;
            } else if (c > '\u07ff') {
                byArray[n++] = (byte)(0xE0 | (byte)(c >> 12));
                byArray[n++] = (byte)(0x80 | (c & 0xFC0) >> 6);
                byArray[n++] = (byte)(0x80 | c & 0x3F);
            } else {
                byArray[n++] = (byte)(0xC0 | (byte)(c >> 6));
                byArray[n++] = (byte)(0x80 | c & 0x3F);
            }
            ++n2;
        }
        return byArray;
    }

    public static int utfLength(String string) {
        if (string == null) {
            throw new IllegalArgumentException("s is null");
        }
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            char c = string.charAt(n2);
            n = c >= '\u0001' && c <= '\u007f' ? ++n : (c > '\u07ff' ? (n += 3) : (n += 2));
            ++n2;
        }
        return n;
    }

    public static boolean check(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes is null");
        }
        int n = 0;
        int n2 = byArray.length;
        while (n < n2) {
            char c;
            block12: {
                char c2;
                byte by;
                byte by2;
                block9: {
                    block11: {
                        block10: {
                            if ((by2 = byArray[n++]) == 0) {
                                return false;
                            }
                            if (by2 >= 0) continue;
                            try {
                                by = byArray[n++];
                                if (by2 >= -32) break block9;
                                c2 = (char)((by2 & 0x1F) << 6 | by & 0x3F);
                                if ((by2 & 0xE0) == 192 && (by & 0xC0) == 128) break block10;
                                return false;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                return false;
                            }
                        }
                        if (c2 >= '\u0080') break block11;
                        if (c2 == '\u0000') continue;
                        return false;
                    }
                    if (c2 <= '\u07ff') continue;
                    return false;
                }
                c2 = byArray[n++];
                c = (char)((by2 & 0xF) << 12 | (by & 0x3F) << 6 | c2 & 0x3F);
                if ((by2 & 0xF0) == 224 && (by & 0xC0) == 128 && (c2 & 0xC0) == 128) break block12;
                return false;
            }
            if (c >= '\u0800') continue;
            return false;
        }
        return true;
    }

    public static String fromUTF8(ImmutableByteArray immutableByteArray) {
        if (immutableByteArray == null) {
            throw new IllegalArgumentException("s is null");
        }
        try {
            return UTF8Convert.fromUTF8(immutableByteArray.b);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            uTFDataFormatException.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }
}

