/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.strings;

import com.ibm.wala.classLoader.Language;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.ImmutableByteArray;
import java.util.ArrayList;
import java.util.HashMap;

public class StringStuff {
    private static final HashMap<String, String> primitiveClassNames = HashMapFactory.make(10);

    static {
        primitiveClassNames.put("int", "I");
        primitiveClassNames.put("long", "J");
        primitiveClassNames.put("short", "S");
        primitiveClassNames.put("byte", "B");
        primitiveClassNames.put("char", "C");
        primitiveClassNames.put("double", "D");
        primitiveClassNames.put("float", "F");
        primitiveClassNames.put("boolean", "Z");
        primitiveClassNames.put("void", "V");
    }

    public static void padWithSpaces(StringBuffer stringBuffer, int n) {
        if (stringBuffer == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (stringBuffer.length() < n) {
            int n2 = stringBuffer.length();
            while (n2 < n) {
                stringBuffer.append(" ");
                ++n2;
            }
        }
    }

    public static String deployment2CanonicalTypeString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("dString is null");
        }
        int n = (string = string.replace('.', '/')).indexOf("[]");
        if (n > -1) {
            String string2 = string.substring(0, n);
            int n2 = (string.length() - n) / 2;
            string2 = StringStuff.deployment2CanonicalTypeString(string2);
            StringBuffer stringBuffer = new StringBuffer("[");
            int n3 = 1;
            while (n3 < n2) {
                stringBuffer.append("[");
                ++n3;
            }
            stringBuffer.append(string2);
            return stringBuffer.toString();
        }
        if (primitiveClassNames.get(string) != null) {
            return primitiveClassNames.get(string);
        }
        return "L" + string;
    }

    public static String deployment2CanonicalDescriptorTypeString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("dString is null");
        }
        int n = (string = string.replace('.', '/')).indexOf("[]");
        if (n > -1) {
            String string2 = string.substring(0, n);
            int n2 = (string.length() - n) / 2;
            string2 = StringStuff.deployment2CanonicalDescriptorTypeString(string2);
            StringBuffer stringBuffer = new StringBuffer("[");
            int n3 = 1;
            while (n3 < n2) {
                stringBuffer.append("[");
                ++n3;
            }
            stringBuffer.append(string2);
            return stringBuffer.toString();
        }
        if (primitiveClassNames.get(string) != null) {
            return primitiveClassNames.get(string);
        }
        return "L" + string + ";";
    }

    public static final TypeName parseForReturnTypeName(String string) throws IllegalArgumentException {
        return StringStuff.parseForReturnTypeName((Language)Language.JAVA, ImmutableByteArray.make(string));
    }

    public static final TypeName parseForReturnTypeName(Language language, String string) throws IllegalArgumentException {
        return StringStuff.parseForReturnTypeName(language, ImmutableByteArray.make(string));
    }

    public static final TypeName parseForReturnTypeName(Language language, ImmutableByteArray immutableByteArray) throws IllegalArgumentException {
        if (immutableByteArray == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (immutableByteArray.length() <= 2) {
            throw new IllegalArgumentException("invalid descriptor: " + immutableByteArray);
        }
        if (immutableByteArray.get(0) != 40) {
            throw new IllegalArgumentException("invalid descriptor: " + immutableByteArray);
        }
        int n = 0;
        while (immutableByteArray.get(n++) != 41) {
        }
        if (immutableByteArray.length() < n + 1) {
            throw new IllegalArgumentException("invalid descriptor: " + immutableByteArray);
        }
        switch (immutableByteArray.get(n)) {
            case 86: {
                return TypeReference.Void.getName();
            }
            case 90: {
                return TypeReference.Boolean.getName();
            }
            case 66: {
                return TypeReference.Byte.getName();
            }
            case 83: {
                return TypeReference.Short.getName();
            }
            case 73: {
                return TypeReference.Int.getName();
            }
            case 74: {
                return TypeReference.Long.getName();
            }
            case 70: {
                return TypeReference.Float.getName();
            }
            case 68: {
                return TypeReference.Double.getName();
            }
            case 67: {
                return TypeReference.Char.getName();
            }
            case 80: {
                if (immutableByteArray.get(immutableByteArray.length() - 1) == 59) {
                    return language.lookupPrimitiveType(new String(immutableByteArray.substring(n + 1, immutableByteArray.length() - n - 2)));
                }
                return language.lookupPrimitiveType(new String(immutableByteArray.substring(n + 1, immutableByteArray.length() - n - 1)));
            }
            case 76: 
            case 91: {
                if (immutableByteArray.get(immutableByteArray.length() - 1) == 59) {
                    return TypeName.findOrCreate(immutableByteArray, n, immutableByteArray.length() - n - 1);
                }
                return TypeName.findOrCreate(immutableByteArray, n, immutableByteArray.length() - n);
            }
        }
        throw new IllegalArgumentException("unexpected type in descriptor " + immutableByteArray);
    }

    public static final TypeName[] parseForParameterNames(String string) throws IllegalArgumentException {
        return StringStuff.parseForParameterNames((Language)Language.JAVA, ImmutableByteArray.make(string));
    }

    public static final TypeName[] parseForParameterNames(Language language, String string) throws IllegalArgumentException {
        return StringStuff.parseForParameterNames(language, ImmutableByteArray.make(string));
    }

    public static final TypeName[] parseForParameterNames(Language language, ImmutableByteArray immutableByteArray) throws IllegalArgumentException {
        if (immutableByteArray == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (immutableByteArray.length() <= 2) {
            throw new IllegalArgumentException("invalid descriptor: " + immutableByteArray);
        }
        if (immutableByteArray.get(0) != 40) {
            throw new IllegalArgumentException("invalid descriptor: " + immutableByteArray);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(10);
        int n = 1;
        block15: while (true) {
            switch (immutableByteArray.get(n++)) {
                case 86: {
                    arrayList.add(TypeReference.VoidName);
                    continue block15;
                }
                case 90: {
                    arrayList.add(TypeReference.BooleanName);
                    continue block15;
                }
                case 66: {
                    arrayList.add(TypeReference.ByteName);
                    continue block15;
                }
                case 83: {
                    arrayList.add(TypeReference.ShortName);
                    continue block15;
                }
                case 73: {
                    arrayList.add(TypeReference.IntName);
                    continue block15;
                }
                case 74: {
                    arrayList.add(TypeReference.LongName);
                    continue block15;
                }
                case 70: {
                    arrayList.add(TypeReference.FloatName);
                    continue block15;
                }
                case 68: {
                    arrayList.add(TypeReference.DoubleName);
                    continue block15;
                }
                case 67: {
                    arrayList.add(TypeReference.CharName);
                    continue block15;
                }
                case 80: {
                    int n2 = n - 1;
                    while (immutableByteArray.get(n++) != 59) {
                    }
                    arrayList.add(language.lookupPrimitiveType(new String(immutableByteArray.substring(n2 + 1, n - n2 - 2))));
                    continue block15;
                }
                case 76: {
                    int n2 = n - 1;
                    while (immutableByteArray.get(n++) != 59) {
                    }
                    arrayList.add(TypeName.findOrCreate(immutableByteArray, n2, n - n2 - 1));
                    continue block15;
                }
                case 91: {
                    int n3;
                    byte by;
                    int n2 = n - 1;
                    while (immutableByteArray.get(n) == 91) {
                        ++n;
                    }
                    Object object = null;
                    if ((by = immutableByteArray.get(n++)) == 76) {
                        while (immutableByteArray.get(n++) != 59) {
                        }
                        object = TypeName.findOrCreate(immutableByteArray, n2, n - n2 - 1);
                    } else if (by == 80) {
                        n3 = n;
                        while (immutableByteArray.get(n++) != 59) {
                        }
                        object = language.lookupPrimitiveType(new String(immutableByteArray.substring(n3, n - n3 - 1)));
                        while (--n3 > n2) {
                            object = ((TypeName)object).getArrayTypeForElementType();
                        }
                    } else {
                        object = TypeName.findOrCreate(immutableByteArray, n2, n - n2);
                    }
                    arrayList.add(object);
                    continue block15;
                }
                case 41: {
                    int n2 = arrayList.size();
                    if (n2 == 0) {
                        return null;
                    }
                    Object object = arrayList.iterator();
                    TypeName[] typeNameArray = new TypeName[n2];
                    int n3 = 0;
                    while (n3 < n2) {
                        typeNameArray[n3] = (TypeName)object.next();
                        ++n3;
                    }
                    return typeNameArray;
                }
            }
            if (!$assertionsDisabled) break;
        }
        throw new AssertionError((Object)("bad descriptor " + immutableByteArray));
    }

    public static ImmutableByteArray parseForPackage(ImmutableByteArray immutableByteArray, int n, int n2) throws IllegalArgumentException {
        int n3;
        int n4;
        block6: {
            try {
                if (immutableByteArray == null) {
                    throw new IllegalArgumentException("name == null");
                }
                n4 = -1;
                n3 = n;
                while (n3 < n + n2) {
                    if (immutableByteArray.b[n3] == 47) {
                        n4 = n3;
                    }
                    ++n3;
                }
                if (n4 != -1) break block6;
                return null;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalArgumentException("invalid name " + immutableByteArray + " start: " + n + " length: " + n2);
            }
        }
        n3 = StringStuff.parseForArrayDimensionality(immutableByteArray, n, n2);
        return new ImmutableByteArray(immutableByteArray.b, n + 1 + n3, n4 - n - 1 - n3);
    }

    public static ImmutableByteArray parseForPackage(ImmutableByteArray immutableByteArray) {
        if (immutableByteArray == null) {
            throw new IllegalArgumentException("name is null");
        }
        return StringStuff.parseForPackage(immutableByteArray, 0, immutableByteArray.length());
    }

    public static ImmutableByteArray parseForClass(ImmutableByteArray immutableByteArray, int n, int n2) throws IllegalArgumentException {
        if (immutableByteArray == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (immutableByteArray.length() == 0) {
            throw new IllegalArgumentException("invalid class name: zero length");
        }
        try {
            if (StringStuff.parseForPackage(immutableByteArray, n, n2) == null) {
                while (immutableByteArray.b[n] == 91) {
                    ++n;
                    --n2;
                }
                if (immutableByteArray.b[n] == 76) {
                    ++n;
                    --n2;
                }
                return new ImmutableByteArray(immutableByteArray.b, n, n2);
            }
            int n3 = 0;
            int n4 = n;
            while (n4 < n + n2) {
                if (immutableByteArray.b[n4] == 47) {
                    n3 = n4;
                }
                ++n4;
            }
            n4 = n2 - (n3 - n + 1);
            return new ImmutableByteArray(immutableByteArray.b, n3 + 1, n4);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Malformed name: " + immutableByteArray + " " + n + " " + n2);
        }
    }

    public static ImmutableByteArray parseForClass(ImmutableByteArray immutableByteArray) throws IllegalArgumentException {
        if (immutableByteArray == null) {
            throw new IllegalArgumentException("name is null");
        }
        return StringStuff.parseForClass(immutableByteArray, 0, immutableByteArray.length());
    }

    public static short parseForArrayDimensionality(ImmutableByteArray immutableByteArray, int n, int n2) throws IllegalArgumentException, IllegalArgumentException {
        if (immutableByteArray == null) {
            throw new IllegalArgumentException("b == null");
        }
        try {
            int n3 = n;
            while (n3 < n + n2) {
                if (immutableByteArray.b[n3] != 91) {
                    return (short)(n3 - n);
                }
                ++n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("ill-formed array descriptor " + immutableByteArray);
        }
        throw new IllegalArgumentException("ill-formed array descriptor " + immutableByteArray);
    }

    public static ImmutableByteArray parseForInnermostArrayElementDescriptor(ImmutableByteArray immutableByteArray, int n, int n2) {
        if (immutableByteArray == null) {
            throw new IllegalArgumentException("b is null");
        }
        try {
            int n3 = n;
            while (n3 < n + n2) {
                if (immutableByteArray.b[n3] != 91) break;
                ++n3;
            }
            return new ImmutableByteArray(immutableByteArray.b, n3, n2 - (n3 - n));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid element desciptor: " + immutableByteArray);
        }
    }

    public static ImmutableByteArray parseForInnermostArrayElementDescriptor(Atom atom) {
        if (atom == null) {
            throw new IllegalArgumentException("a is null");
        }
        ImmutableByteArray immutableByteArray = new ImmutableByteArray(atom.getValArray());
        return StringStuff.parseForInnermostArrayElementDescriptor(immutableByteArray, 0, immutableByteArray.length());
    }

    /*
     * Exception decompiling
     */
    public static boolean classIsPrimitive(ImmutableByteArray var0, int var1_1, int var2_2) throws IllegalArgumentException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static MethodReference makeMethodReference(String string) throws IllegalArgumentException {
        return StringStuff.makeMethodReference(Language.JAVA, string);
    }

    public static MethodReference makeMethodReference(Language language, String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("methodSig is null");
        }
        if (string.lastIndexOf(46) < 0) {
            throw new IllegalArgumentException("ill-formed sig " + string);
        }
        String string2 = string.substring(0, string.lastIndexOf(46));
        string2 = StringStuff.deployment2CanonicalTypeString(string2);
        TypeReference typeReference = TypeReference.findOrCreate(ClassLoaderReference.Application, string2);
        String string3 = string.substring(string.lastIndexOf(46) + 1, string.indexOf(40));
        String string4 = string.substring(string.indexOf(40));
        return MethodReference.findOrCreate(language, typeReference, string3, string4);
    }

    public static String jvmToReadableType(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("jvmType is null");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        if (string.length() == 0) {
            throw new IllegalArgumentException("ill-formed type : " + string);
        }
        char c = string.charAt(0);
        while (c == '[') {
            c = string.charAt(++n);
        }
        if (c == 'V') {
            stringBuffer.append("void");
        } else if (c == 'B') {
            stringBuffer.append("byte");
        } else if (c == 'C') {
            stringBuffer.append("char");
        } else if (c == 'D') {
            stringBuffer.append("double");
        } else if (c == 'F') {
            stringBuffer.append("float");
        } else if (c == 'I') {
            stringBuffer.append("int");
        } else if (c == 'J') {
            stringBuffer.append("long");
        } else if (c == 'S') {
            stringBuffer.append("short");
        } else if (c == 'Z') {
            stringBuffer.append("boolean");
        } else if (c == 'L') {
            stringBuffer.append(string.substring(n + 1, string.length()));
            stringBuffer = new StringBuffer(StringStuff.slashToDot(stringBuffer.toString()));
            stringBuffer = new StringBuffer(StringStuff.dollarToDot(stringBuffer.toString()));
        }
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("[]");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String jvmToBinaryName(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("jvmType is null");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        if (string.length() == 0) {
            throw new IllegalArgumentException("ill-formed type : " + string);
        }
        char c = string.charAt(0);
        while (c == '[') {
            c = string.charAt(++n);
        }
        if (c == 'V') {
            stringBuffer.append("void");
        } else if (c == 'B') {
            stringBuffer.append("byte");
        } else if (c == 'C') {
            stringBuffer.append("char");
        } else if (c == 'D') {
            stringBuffer.append("double");
        } else if (c == 'F') {
            stringBuffer.append("float");
        } else if (c == 'I') {
            stringBuffer.append("int");
        } else if (c == 'J') {
            stringBuffer.append("long");
        } else if (c == 'S') {
            stringBuffer.append("short");
        } else if (c == 'Z') {
            stringBuffer.append("boolean");
        } else if (c == 'L') {
            stringBuffer.append(string.substring(n + 1, string.length()));
            stringBuffer = new StringBuffer(StringStuff.slashToDot(stringBuffer.toString()));
        }
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("[]");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String slashToDot(String string) {
        if (string == null) {
            throw new IllegalArgumentException("path is null");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '/') {
                stringBuffer.setCharAt(n, '.');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String dollarToDot(String string) {
        if (string == null) {
            throw new IllegalArgumentException("path is null");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '$') {
                stringBuffer.setCharAt(n, '.');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String dotToDollar(String string) {
        if (string == null) {
            throw new IllegalArgumentException("path is null");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '.') {
                stringBuffer.setCharAt(n, '$');
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

