/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.shrike;

import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.ref.CacheReference;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ShrikeClassReaderHandle {
    private static final boolean DEBUG = false;
    private final ModuleEntry entry;
    private Object reader;
    private int hydrateCount = 0;

    public ShrikeClassReaderHandle(ModuleEntry moduleEntry) {
        if (moduleEntry == null) {
            throw new IllegalArgumentException("null entry");
        }
        this.entry = moduleEntry;
    }

    public ClassReader get() throws InvalidClassFileException {
        ClassReader classReader = (ClassReader)CacheReference.get(this.reader);
        if (classReader == null) {
            ++this.hydrateCount;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                InputStream inputStream = this.entry.getInputStream();
                this.readBytes(inputStream, byteArrayOutputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Assertions.UNREACHABLE();
            }
            classReader = new ClassReader(byteArrayOutputStream.toByteArray());
            this.reader = CacheReference.make(classReader);
        }
        return classReader;
    }

    private void readBytes(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        int n = 0;
        byte[] byArray = new byte[1024];
        while (n > -1) {
            n = inputStream.read(byArray, 0, 1024);
            if (n <= -1) continue;
            byteArrayOutputStream.write(byArray, 0, n);
        }
    }

    public String getFileName() {
        return this.entry.getName();
    }

    public void clear() {
        this.reader = null;
    }

    public ModuleEntry getModuleEntry() {
        return this.entry;
    }
}

