/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.ref;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import java.lang.ref.WeakReference;

public class ReferenceCleanser {
    private static final float OCCUPANCY_TRIGGER = 0.5f;
    private static WeakReference<IClassHierarchy> cha;
    private static WeakReference<AnalysisCache> cache;

    public static void registerClassHierarchy(IClassHierarchy iClassHierarchy) {
        cha = new WeakReference<IClassHierarchy>(iClassHierarchy);
    }

    private static IClassHierarchy getClassHierarchy() {
        IClassHierarchy iClassHierarchy = null;
        if (cha != null) {
            iClassHierarchy = (IClassHierarchy)cha.get();
        }
        return iClassHierarchy;
    }

    public static void registerCache(AnalysisCache analysisCache) {
        cache = new WeakReference<AnalysisCache>(analysisCache);
    }

    private static AnalysisCache getAnalysisCache() {
        AnalysisCache analysisCache = null;
        if (cache != null) {
            analysisCache = (AnalysisCache)cache.get();
        }
        return analysisCache;
    }

    public static void clearSoftCaches() {
        IClassHierarchy iClassHierarchy;
        float f = 1.0f - (float)Runtime.getRuntime().freeMemory() / (float)Runtime.getRuntime().totalMemory();
        if (f < 0.5f) {
            return;
        }
        AnalysisCache analysisCache = ReferenceCleanser.getAnalysisCache();
        if (analysisCache != null) {
            analysisCache.getSSACache().wipe();
        }
        if ((iClassHierarchy = ReferenceCleanser.getClassHierarchy()) != null) {
            for (IClass iClass : iClassHierarchy) {
                if (iClass instanceof ShrikeClass) {
                    ShrikeClass shrikeClass = (ShrikeClass)iClass;
                    shrikeClass.clearSoftCaches();
                    continue;
                }
                for (IMethod iMethod : iClass.getDeclaredMethods()) {
                    if (!(iMethod instanceof ShrikeCTMethod)) continue;
                    ((ShrikeCTMethod)iMethod).clearCaches();
                }
            }
        }
    }
}

