/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.io;

import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.warnings.WalaException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static Collection<File> listFiles(String string, String string2, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("dir is null");
        }
        File file = new File(string);
        Pattern pattern = null;
        if (string2 != null) {
            pattern = Pattern.compile(string2);
        }
        return FileUtil.listFiles(file, bl, pattern);
    }

    private static Collection<File> listFiles(File file, boolean bl, Pattern pattern) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return Collections.emptyList();
        }
        HashSet<File> hashSet = HashSetFactory.make();
        int n = 0;
        while (n < fileArray.length) {
            if (pattern == null || pattern.matcher(fileArray[n].getAbsolutePath()).matches()) {
                hashSet.add(fileArray[n]);
            }
            if (bl && fileArray[n].isDirectory()) {
                hashSet.addAll(FileUtil.listFiles(fileArray[n], bl, pattern));
            }
            ++n;
        }
        return hashSet;
    }

    public static void copy(String string, String string2) throws WalaException {
        if (string == null) {
            throw new IllegalArgumentException("srcFileName is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("destFileName is null");
        }
        FileChannel fileChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            try {
                fileChannel = new FileInputStream(string).getChannel();
                abstractInterruptibleChannel = new FileOutputStream(string2).getChannel();
                long l = fileChannel.size();
                MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, l);
                ((FileChannel)abstractInterruptibleChannel).write(mappedByteBuffer);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                throw new WalaException("Failed to copy " + string + " to " + string2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new WalaException("Failed to copy " + string + " to " + string2);
            }
        }
        catch (Throwable throwable) {
            if (abstractInterruptibleChannel != null) {
                try {
                    abstractInterruptibleChannel.close();
                }
                catch (IOException iOException) {}
            }
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (abstractInterruptibleChannel != null) {
            try {
                abstractInterruptibleChannel.close();
            }
            catch (IOException iOException) {}
        }
        if (fileChannel != null) {
            try {
                fileChannel.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void deleteContents(String string) throws IOException {
        Collection<File> collection = FileUtil.listFiles(string, null, true);
        for (File object : collection) {
            boolean bl;
            if (object.isDirectory() || (bl = object.delete())) continue;
            throw new IOException("Failed to delete " + object);
        }
        int n = Integer.MAX_VALUE;
        do {
            Collection<File> collection2;
            if ((collection2 = FileUtil.listFiles(string, null, true)).size() == n) {
                throw new IOException("got stuck deleting directories. Probably some other process is preventing deletion.");
            }
            n = collection2.size();
            for (File file : collection2) {
                file.delete();
            }
        } while (FileUtil.listFiles(string, null, true).size() > 0);
    }

    public static final FileOutputStream createFile(String string) throws IOException {
        boolean bl;
        if (string == null) {
            throw new IllegalArgumentException("null file");
        }
        File file = new File(string);
        if (file.getParentFile() != null && !file.getParentFile().exists() && !(bl = file.getParentFile().mkdirs())) {
            throw new IOException("failed to create " + file.getParentFile());
        }
        if (file.exists()) {
            file.delete();
        }
        if (!(bl = file.createNewFile())) {
            throw new IOException("failed to create " + file);
        }
        return new FileOutputStream(file);
    }

    public static byte[] readBytes(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("null s");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = inputStream.read(byArray);
        while (n != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }
}

