/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.io;

import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.NestedJarFileModule;
import com.ibm.wala.core.plugin.CorePlugin;
import com.ibm.wala.util.debug.Assertions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

public class FileProvider {
    private static final int DEBUG_LEVEL = 0;

    public static Module getJarFileModule(String string) throws IOException {
        return FileProvider.getJarFileModule(string, FileProvider.class.getClassLoader());
    }

    public static Module getJarFileModule(String string, ClassLoader classLoader) throws IOException {
        Module module;
        if (CorePlugin.getDefault() == null) {
            return FileProvider.getJarFileFromClassLoader(string, classLoader);
        }
        if (CorePlugin.IS_RESOURCES_BUNDLE_AVAILABLE && (module = EclipseUtil.getJarFileModule(string, classLoader)) != null) {
            return module;
        }
        return FileProvider.getFromPlugin(CorePlugin.getDefault(), string);
    }

    public static URL getResource(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("null fileName");
        }
        return FileProvider.getResource(string, FileProvider.class.getClassLoader());
    }

    public static URL getResource(String string, ClassLoader classLoader) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("null fileName");
        }
        if (CorePlugin.getDefault() == null && classLoader == null) {
            throw new IllegalArgumentException("null loader");
        }
        return CorePlugin.getDefault() == null ? classLoader.getResource(string) : FileLocator.find((Bundle)CorePlugin.getDefault().getBundle(), (IPath)new Path(string), null);
    }

    public static File getFile(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("null fileName");
        }
        return FileProvider.getFile(string, FileProvider.class.getClassLoader());
    }

    public static File getFile(String string, ClassLoader classLoader) throws IOException {
        return CorePlugin.getDefault() == null ? FileProvider.getFileFromClassLoader(string, classLoader) : FileProvider.getFileFromPlugin(CorePlugin.getDefault(), string);
    }

    public static File getFileFromPlugin(Plugin plugin, String string) throws IOException {
        if (plugin == null) {
            throw new IllegalArgumentException("p is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("null fileName");
        }
        URL uRL = FileProvider.getFileURLFromPlugin(plugin, string);
        if (uRL == null) {
            throw new FileNotFoundException(string);
        }
        return new File(FileProvider.filePathFromURL(uRL));
    }

    private static JarFileModule getFromPlugin(Plugin plugin, String string) throws IOException {
        URL uRL = FileProvider.getFileURLFromPlugin(plugin, string);
        return uRL == null ? null : new JarFileModule(new JarFile(FileProvider.filePathFromURL(uRL)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static URL getFileURLFromPlugin(Plugin plugin, String string) throws IOException {
        try {
            URL uRL = FileLocator.find((Bundle)plugin.getBundle(), (IPath)new Path(string), null);
            if (uRL == null) {
                String string2 = "lib/" + string;
                uRL = FileLocator.find((Bundle)plugin.getBundle(), (IPath)new Path(string2), null);
                if (uRL == null) {
                    String string3 = "bin/" + string;
                    uRL = FileLocator.find((Bundle)plugin.getBundle(), (IPath)new Path(string3), null);
                    if (uRL == null) {
                        File file = new File(string);
                        if (!file.exists()) {
                            return null;
                        }
                        uRL = file.toURI().toURL();
                    }
                }
            }
            uRL = FileLocator.toFileURL((URL)uRL);
            return FileProvider.fixupFileURLSpaces(uRL);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw new IOException("failure to get file URL for " + string);
        }
    }

    private static URL fixupFileURLSpaces(URL uRL) {
        String string = uRL.toExternalForm();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = string.indexOf(32, n)) < 0) break;
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append("%20");
            n = n2 + 1;
        }
        stringBuffer.append(string.substring(n));
        try {
            return new URL(stringBuffer.toString());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    public static File getFileFromClassLoader(String string, ClassLoader classLoader) throws FileNotFoundException {
        if (classLoader == null) {
            throw new IllegalArgumentException("null loader");
        }
        if (string == null) {
            throw new IllegalArgumentException("null fileName");
        }
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            File file = new File(string);
            if (file.exists()) {
                return file;
            }
            throw new FileNotFoundException(string);
        }
        return new File(FileProvider.filePathFromURL(uRL));
    }

    public static Module getJarFileFromClassLoader(String string, ClassLoader classLoader) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("null fileName");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("null loader");
        }
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            try {
                return new JarFileModule(new JarFile(string, false));
            }
            catch (ZipException zipException) {
                throw new IOException("Could not find file: " + string);
            }
        }
        if (uRL.getProtocol().equals("jar")) {
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            JarFile jarFile = jarURLConnection.getJarFile();
            JarEntry jarEntry = jarURLConnection.getJarEntry();
            JarFileModule jarFileModule = new JarFileModule(jarFile);
            return new NestedJarFileModule(jarFileModule, jarEntry);
        }
        String string2 = FileProvider.filePathFromURL(uRL);
        return new JarFileModule(new JarFile(string2, false));
    }

    public static String filePathFromURL(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("url is null");
        }
        URI uRI = null;
        try {
            uRI = new URI(uRL.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            Assertions.UNREACHABLE();
        }
        String string = uRI.getPath();
        return string;
    }

    private static final class EclipseUtil {
        private static Object workspaceRoot = null;
        private static Method workspaceRoot_getFile = null;

        private EclipseUtil() {
        }

        public static Module getJarFileModule(String string, ClassLoader classLoader) {
            try {
                Path path;
                if (workspaceRoot_getFile == null) {
                    path = Class.forName("org.eclipse.core.resources.ResourcesPlugin");
                    Method method = path.getDeclaredMethod("getWorkspace", new Class[0]);
                    Object object = method.invoke(null, new Object[0]);
                    Method method2 = object.getClass().getDeclaredMethod("getRoot", new Class[0]);
                    workspaceRoot = method2.invoke(object, new Object[0]);
                    workspaceRoot_getFile = workspaceRoot.getClass().getMethod("getFile", IPath.class);
                }
                path = new Path(string);
                if (workspaceRoot_getFile.invoke(workspaceRoot, path) != null) {
                    return new JarFileModule(new JarFile(string, false));
                }
            }
            catch (Exception exception) {}
            return null;
        }
    }
}

