/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.LongIterator;
import com.ibm.wala.util.intset.LongSet;
import com.ibm.wala.util.intset.LongSetAction;
import com.ibm.wala.util.intset.LongSetUtil;
import com.ibm.wala.util.intset.MutableSparseLongSet;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class SparseLongSet
implements LongSet {
    private static final int SINGLETON_CACHE_SIZE = 0;
    private static final SparseLongSet[] singletonCache = new SparseLongSet[0];
    protected long[] elements;
    protected int size = 0;

    static {
        int n = 0;
        while (n < 0) {
            SparseLongSet.singletonCache[n] = new SparseLongSet(new long[]{n});
            ++n;
        }
    }

    protected SparseLongSet(int n) {
        this.elements = new long[n];
        this.size = n;
    }

    protected SparseLongSet(long[] lArray) {
        if (lArray == null) {
            throw new IllegalArgumentException("backingArray is null");
        }
        this.elements = lArray;
        this.size = lArray.length;
    }

    public SparseLongSet() {
        this.elements = null;
        this.size = 0;
    }

    protected SparseLongSet(SparseLongSet sparseLongSet) {
        this.cloneState(sparseLongSet);
    }

    private void cloneState(SparseLongSet sparseLongSet) {
        this.elements = (long[])sparseLongSet.elements.clone();
        this.size = sparseLongSet.size;
    }

    public SparseLongSet(IntSet intSet) throws IllegalArgumentException {
        if (intSet == null) {
            throw new IllegalArgumentException("S == null");
        }
        if (intSet instanceof SparseLongSet) {
            this.cloneState((SparseLongSet)((Object)intSet));
        } else {
            this.elements = new long[intSet.size()];
            this.size = intSet.size();
            intSet.foreach(new IntSetAction(){
                private int index = 0;

                public void act(int n) {
                    SparseLongSet.this.elements[this.index++] = n;
                }
            });
        }
    }

    public final boolean contains(long l) {
        if (this.elements == null) {
            return false;
        }
        return LongSetUtil.binarySearch(this.elements, l, 0, this.size - 1) >= 0;
    }

    public final int getIndex(long l) {
        if (this.elements == null) {
            return -1;
        }
        return LongSetUtil.binarySearch(this.elements, l, 0, this.size - 1);
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final long elementAt(int n) throws NoSuchElementException {
        if (n < 0 || n >= this.size) {
            throw new NoSuchElementException();
        }
        return this.elements[n];
    }

    private boolean sameValueInternal(SparseLongSet sparseLongSet) {
        if (this.size != sparseLongSet.size) {
            return false;
        }
        int n = 0;
        while (n < this.size) {
            if (this.elements[n] != sparseLongSet.elements[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean sameValue(LongSet longSet) throws IllegalArgumentException, UnimplementedError {
        if (longSet == null) {
            throw new IllegalArgumentException("that == null");
        }
        if (longSet instanceof SparseLongSet) {
            return this.sameValueInternal((SparseLongSet)longSet);
        }
        Assertions.UNREACHABLE(longSet.getClass().toString());
        return false;
    }

    private boolean isSubsetInternal(SparseLongSet sparseLongSet) {
        if (this.elements == null) {
            return true;
        }
        if (sparseLongSet.elements == null) {
            return false;
        }
        if (this.equals(sparseLongSet)) {
            return true;
        }
        if (this.sameValue(sparseLongSet)) {
            return true;
        }
        long[] lArray = this.elements;
        int n = 0;
        int n2 = this.size;
        long[] lArray2 = sparseLongSet.elements;
        int n3 = 0;
        int n4 = sparseLongSet.size;
        while (n < n2 && n3 < n4) {
            long l = lArray[n] - lArray2[n3];
            if (l > 0L) {
                ++n3;
                continue;
            }
            if (l < 0L) {
                return false;
            }
            ++n;
            ++n3;
        }
        return n3 != n4 || n >= n2;
    }

    public static SparseLongSet diff(SparseLongSet sparseLongSet, SparseLongSet sparseLongSet2) {
        if (sparseLongSet == null) {
            throw new IllegalArgumentException("A is null");
        }
        if (sparseLongSet2 == null) {
            throw new IllegalArgumentException("B is null");
        }
        if (sparseLongSet.isEmpty()) {
            return new SparseLongSet(0);
        }
        if (sparseLongSet2.isEmpty()) {
            return new SparseLongSet(sparseLongSet);
        }
        if (sparseLongSet.equals(sparseLongSet2)) {
            return new SparseLongSet(0);
        }
        if (sparseLongSet.sameValue(sparseLongSet2)) {
            return new SparseLongSet(0);
        }
        long[] lArray = sparseLongSet.elements;
        int n = 0;
        int n2 = sparseLongSet.size;
        long[] lArray2 = sparseLongSet2.elements;
        int n3 = 0;
        int n4 = sparseLongSet2.size;
        long[] lArray3 = new long[n2];
        int n5 = 0;
        while (n < n2 && n3 < n4) {
            long l = lArray[n] - lArray2[n3];
            if (l > 0L) {
                ++n3;
                continue;
            }
            if (l < 0L) {
                lArray3[n5++] = lArray[n];
                ++n;
                continue;
            }
            ++n;
            ++n3;
        }
        if (n < n2) {
            int n6 = n2 - n;
            System.arraycopy(lArray, n, lArray3, n5, n6);
            n5 += n6;
        }
        lArray = new long[n5];
        System.arraycopy(lArray3, 0, lArray, 0, n5);
        return new SparseLongSet(lArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(6 * this.size);
        stringBuffer.append("{ ");
        if (this.elements != null) {
            int n = 0;
            while (n < this.size) {
                stringBuffer.append(this.elements[n]);
                stringBuffer.append(" ");
                ++n;
            }
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static long[] parseLongArray(String string) throws NumberFormatException, IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("str is null");
        }
        int n = string.length();
        if (n < 2) {
            throw new IllegalArgumentException("malformed input: " + string);
        }
        if (string.charAt(0) != '{' || string.charAt(n - 1) != '}') {
            throw new NumberFormatException(string);
        }
        string = string.substring(1, n - 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        TreeSet<Long> treeSet = new TreeSet<Long>();
        while (stringTokenizer.hasMoreTokens()) {
            treeSet.add(Long.decode(stringTokenizer.nextToken()));
        }
        long[] lArray = new long[treeSet.size()];
        int n2 = 0;
        for (Long l : treeSet) {
            lArray[n2++] = l;
        }
        return lArray;
    }

    public static SparseLongSet singleton(int n) {
        if (n >= 0 && n < 0) {
            return singletonCache[n];
        }
        return new SparseLongSet(new long[]{n});
    }

    public static SparseLongSet pair(long l, long l2) {
        if (l2 > l) {
            return new SparseLongSet(new long[]{l, l2});
        }
        return new SparseLongSet(new long[]{l2, l});
    }

    public LongSet intersection(LongSet longSet) throws IllegalArgumentException, UnimplementedError {
        if (longSet == null) {
            throw new IllegalArgumentException("that == null");
        }
        if (longSet instanceof SparseLongSet) {
            MutableSparseLongSet mutableSparseLongSet = MutableSparseLongSet.make(this);
            mutableSparseLongSet.intersectWith((SparseLongSet)longSet);
            return mutableSparseLongSet;
        }
        Assertions.UNREACHABLE("Unexpected: " + longSet.getClass());
        return null;
    }

    public LongIterator longIterator() {
        return new LongIterator(){
            int i = 0;

            public boolean hasNext() {
                return this.i < SparseLongSet.this.size;
            }

            public long next() throws NoSuchElementException {
                if (SparseLongSet.this.elements == null) {
                    throw new NoSuchElementException();
                }
                return SparseLongSet.this.elements[this.i++];
            }
        };
    }

    public void foreach(LongSetAction longSetAction) {
        if (longSetAction == null) {
            throw new IllegalArgumentException("null action");
        }
        int n = 0;
        while (n < this.size) {
            longSetAction.act(this.elements[n]);
            ++n;
        }
    }

    public void foreachExcluding(LongSet longSet, LongSetAction longSetAction) {
        if (longSet == null) {
            throw new IllegalArgumentException("null X");
        }
        if (longSetAction == null) {
            throw new IllegalArgumentException("null action");
        }
        int n = 0;
        while (n < this.size) {
            if (!longSet.contains(this.elements[n])) {
                longSetAction.act(this.elements[n]);
            }
            ++n;
        }
    }

    public final long max() throws IllegalStateException {
        if (this.elements == null) {
            throw new IllegalStateException("Illegal to ask max() on an empty int set");
        }
        return this.size > 0 ? this.elements[this.size - 1] : -1L;
    }

    public static SparseLongSet add(SparseLongSet sparseLongSet, int n) {
        if (sparseLongSet == null || sparseLongSet.elements == null) {
            return SparseLongSet.singleton(n);
        }
        SparseLongSet sparseLongSet2 = new SparseLongSet(sparseLongSet.size + 1);
        int n2 = 0;
        int n3 = 0;
        while (n2 < sparseLongSet.elements.length && sparseLongSet.elements[n2] < (long)n) {
            sparseLongSet2.elements[n2++] = sparseLongSet.elements[n3++];
        }
        if (n2 == sparseLongSet.size) {
            sparseLongSet2.elements[n2] = n;
        } else {
            if (sparseLongSet.elements[n2] == (long)n) {
                --sparseLongSet2.size;
            } else {
                sparseLongSet2.elements[n2++] = n;
            }
            while (n2 < sparseLongSet2.size) {
                sparseLongSet2.elements[n2++] = sparseLongSet.elements[n3++];
            }
        }
        return sparseLongSet2;
    }

    public boolean isSubset(LongSet longSet) throws IllegalArgumentException, UnimplementedError {
        if (longSet == null) {
            throw new IllegalArgumentException("that == null");
        }
        if (longSet instanceof SparseLongSet) {
            return this.isSubsetInternal((SparseLongSet)longSet);
        }
        Assertions.UNREACHABLE("Unexpected type " + longSet.getClass());
        return false;
    }

    public boolean containsAny(LongSet longSet) {
        if (longSet == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (longSet instanceof SparseLongSet) {
            return this.containsAny((SparseLongSet)longSet);
        }
        int n = 0;
        while (n < this.size) {
            if (longSet.contains(this.elements[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean containsAny(SparseLongSet sparseLongSet) throws IllegalArgumentException {
        if (sparseLongSet == null) {
            throw new IllegalArgumentException("set == null");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < sparseLongSet.size) {
            long l = sparseLongSet.elements[n2];
            while (n < this.size && this.elements[n] < l) {
                ++n;
            }
            if (n == this.size) {
                return false;
            }
            if (this.elements[n] == l) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

