/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.IntVector;
import com.ibm.wala.util.intset.MutableSparseIntSet;

public class SparseIntVector
implements IntVector {
    private static final int INITIAL_SIZE = 5;
    private final double EXPANSION = 1.5;
    int maxIndex = -1;
    private final MutableSparseIntSet indices = MutableSparseIntSet.makeEmpty();
    private int[] data = new int[5];
    private final int defaultValue;

    public SparseIntVector(int n) {
        this.defaultValue = n;
    }

    public int get(int n) {
        int n2 = this.indices.getIndex(n);
        if (n2 == -1) {
            return this.defaultValue;
        }
        return this.data[n2];
    }

    public void set(int n, int n2) {
        this.maxIndex = Math.max(this.maxIndex, n);
        int n3 = this.indices.getIndex(n);
        if (n3 == -1) {
            this.indices.add(n);
            n3 = this.indices.getIndex(n);
            this.ensureCapacity(this.indices.size() + 1);
            if (n3 < this.data.length - 1) {
                System.arraycopy(this.data, n3, this.data, n3 + 1, this.indices.size() - n3);
            }
        }
        this.data[n3] = n2;
    }

    private void ensureCapacity(int n) {
        if (this.data.length < n + 1) {
            int[] nArray = this.data;
            this.data = new int[1 + (int)((double)n * 1.5)];
            System.arraycopy(nArray, 0, this.data, 0, nArray.length);
        }
    }

    public void performVerboseAction() {
        System.err.println(this.getClass() + " stats: ");
        System.err.println("data.length " + this.data.length);
        System.err.println("indices.size() " + this.indices.size());
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }
}

