/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.collections.CompoundIntIterator;
import com.ibm.wala.util.collections.EmptyIntIterator;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.OffsetBitVector;

public class SemiSparseMutableIntSet
implements MutableIntSet {
    private static final boolean DEBUG = true;
    private static final double FIX_SPARSE_MOD = 12.0;
    private static final double FIX_SPARSE_RATIO = 0.05;
    private MutableSparseIntSet sparsePart;
    private OffsetBitVector densePart = null;

    public SemiSparseMutableIntSet() {
        this(MutableSparseIntSet.makeEmpty());
    }

    private SemiSparseMutableIntSet(MutableSparseIntSet mutableSparseIntSet) {
        this.sparsePart = mutableSparseIntSet;
    }

    private SemiSparseMutableIntSet(MutableSparseIntSet mutableSparseIntSet, OffsetBitVector offsetBitVector) {
        this.sparsePart = mutableSparseIntSet;
        this.densePart = offsetBitVector;
    }

    public SemiSparseMutableIntSet(SemiSparseMutableIntSet semiSparseMutableIntSet) throws IllegalArgumentException {
        if (semiSparseMutableIntSet == null) {
            throw new IllegalArgumentException("set == null");
        }
        this.copySet(semiSparseMutableIntSet);
    }

    private final boolean assertDisjoint() {
        if (this.densePart != null) {
            IntIterator intIterator = this.sparsePart.intIterator();
            while (intIterator.hasNext()) {
                int n = intIterator.next();
                if (this.densePart.contains(n)) {
                    return false;
                }
                if (!this.inDenseRange(n)) continue;
                return false;
            }
        }
        return true;
    }

    private void fixAfterSparseInsert() {
        if ((double)this.sparsePart.size() % 12.0 == 11.0 && (this.densePart == null || this.densePart != null && (double)this.sparsePart.size() > 0.05 * (double)this.densePart.getSize())) {
            assert (this.assertDisjoint()) : this.toString();
            if (this.densePart == null) {
                int n;
                int n2;
                IntIterator intIterator = this.sparsePart.intIterator();
                int n3 = -1;
                int n4 = -1;
                int n5 = -1;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                while (intIterator.hasNext()) {
                    int n10;
                    n2 = intIterator.next();
                    n = n7 + (n2 - n9);
                    if (n < 32 * (n10 = n8 + 1)) {
                        n8 = n10;
                        n7 = n;
                        if (n8 > n4) {
                            n3 = n6;
                            n5 = n2;
                            n4 = n8;
                        }
                    } else {
                        n6 = n2;
                        n8 = 1;
                        n7 = 32;
                    }
                    n9 = n2;
                }
                if (n3 != -1) {
                    this.densePart = new OffsetBitVector(n3, n5 - n3);
                    intIterator = this.sparsePart.intIterator();
                    while ((n2 = intIterator.next()) < n3) {
                    }
                    this.densePart.set(n2);
                    n = 1;
                    while (n < n4) {
                        this.densePart.set(intIterator.next());
                        ++n;
                    }
                    this.sparsePart.removeAll(this.densePart);
                }
                assert (this.assertDisjoint()) : String.valueOf(this.toString()) + ", maxOffset=" + n3 + ", maxMax=" + n5 + ", maxCount=" + n4;
            } else {
                int n;
                int n11;
                int n12;
                IntIterator intIterator = this.sparsePart.intIterator();
                int n13 = intIterator.next();
                int n14 = 0;
                int n15 = -1;
                int n16 = -1;
                int n17 = -1;
                if (n13 < this.densePart.getOffset()) {
                    n15 = n13;
                    n12 = 32;
                    n11 = 1;
                    while (intIterator.hasNext()) {
                        n = intIterator.next();
                        if (n >= this.densePart.getOffset() || !intIterator.hasNext()) {
                            if (n < this.densePart.getOffset() && !intIterator.hasNext()) {
                                ++n11;
                            }
                            if (this.densePart.getOffset() - n15 < 32 * n11) {
                                n14 += n11;
                            } else {
                                n15 = -1;
                            }
                            n13 = n;
                            break;
                        }
                        if ((n12 += n - n13) > 32 * ++n11) {
                            n15 = n;
                            n11 = 1;
                            n12 = 32;
                        }
                        n13 = n;
                    }
                }
                while (n13 < this.densePart.length() && intIterator.hasNext()) {
                    n13 = intIterator.next();
                }
                if (n13 >= this.densePart.length()) {
                    n12 = 1;
                    n11 = n13 + 1 - this.densePart.length();
                    if (32 * n12 > n11) {
                        n17 = n13;
                        n16 = 1;
                    }
                    while (intIterator.hasNext()) {
                        n13 = intIterator.next();
                        n11 = n13 + 1 - this.densePart.length();
                        if (32 * ++n12 <= n11) continue;
                        n17 = n13;
                        n16 = n12;
                    }
                    if (n17 > -1) {
                        n14 += n16;
                    }
                }
                if (n14 > 0) {
                    n12 = 0;
                    int[] nArray = new int[n14];
                    intIterator = this.sparsePart.intIterator();
                    while (intIterator.hasNext()) {
                        n = intIterator.next();
                        if (n15 != -1 && n >= n15 && n < this.densePart.getOffset()) {
                            nArray[n12++] = n;
                        }
                        if (n17 == -1 || n < this.densePart.length() || n > n17) continue;
                        nArray[n12++] = n;
                    }
                    if (n12 != n14) assert (n12 == n14) : "index is " + n12 + ", but moveCount is " + n14 + " for " + this;
                    if (n17 != -1 && nArray[n12 - 1] == this.sparsePart.max()) {
                        n = this.densePart.getOffset();
                        int n18 = this.densePart.length() - n;
                        float f = 1.1f * (float)(nArray[n12 - 1] - n);
                        float f2 = f / (float)n18;
                        assert (f2 > 1.0f);
                        this.densePart.growCapacity(f2);
                    }
                    n = n12 - 1;
                    while (n >= 0) {
                        this.sparsePart.remove(nArray[n]);
                        this.densePart.set(nArray[n]);
                        --n;
                    }
                }
                assert (this.assertDisjoint()) : String.valueOf(this.toString()) + ", densePart.length()=" + this.densePart.length() + ", newOffset=" + n15 + ", newLength=" + n17 + ", newCount=" + n16 + ", moveCount=" + n14;
            }
        }
    }

    public void clear() {
        this.sparsePart.clear();
        this.densePart = null;
    }

    public boolean contains(int n) {
        if (this.densePart != null && this.inDenseRange(n)) {
            return this.densePart.contains(n);
        }
        return this.sparsePart.contains(n);
    }

    public boolean containsAny(IntSet intSet) {
        if (intSet == null) {
            throw new IllegalArgumentException("null set");
        }
        if (!this.sparsePart.isEmpty() && this.sparsePart.containsAny(intSet)) {
            return true;
        }
        if (this.densePart != null) {
            int n = this.densePart.getOffset();
            IntIterator intIterator = intSet.intIterator();
            while (intIterator.hasNext()) {
                int n2 = intIterator.next();
                if (n2 < n || !this.densePart.get(n2)) continue;
                return true;
            }
        }
        return false;
    }

    public IntSet intersection(IntSet intSet) {
        if (intSet == null) {
            throw new IllegalArgumentException("null that");
        }
        SemiSparseMutableIntSet semiSparseMutableIntSet = new SemiSparseMutableIntSet();
        IntIterator intIterator = this.intIterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            if (!intSet.contains(n)) continue;
            semiSparseMutableIntSet.add(n);
        }
        return semiSparseMutableIntSet;
    }

    public IntSet union(IntSet intSet) {
        SemiSparseMutableIntSet semiSparseMutableIntSet = new SemiSparseMutableIntSet();
        semiSparseMutableIntSet.addAll(this);
        semiSparseMutableIntSet.addAll(intSet);
        return semiSparseMutableIntSet;
    }

    public boolean isEmpty() {
        return this.sparsePart.isEmpty() && (this.densePart == null || this.densePart.isZero());
    }

    public int size() {
        return this.sparsePart.size() + (this.densePart == null ? 0 : this.densePart.populationCount());
    }

    public IntIterator intIterator() {
        class DensePartIterator
        implements IntIterator {
            private int i = -1;

            DensePartIterator() {
            }

            public boolean hasNext() {
                return SemiSparseMutableIntSet.this.densePart.nextSetBit(this.i + 1) != -1;
            }

            public int next() {
                int n;
                this.i = n = SemiSparseMutableIntSet.this.densePart.nextSetBit(this.i + 1);
                return n;
            }
        }
        if (this.sparsePart.isEmpty()) {
            if (this.densePart == null || this.densePart.isZero()) {
                return EmptyIntIterator.instance();
            }
            return new DensePartIterator();
        }
        if (this.densePart == null || this.densePart.isZero()) {
            return this.sparsePart.intIterator();
        }
        return new CompoundIntIterator(this.sparsePart.intIterator(), new DensePartIterator());
    }

    public void foreach(IntSetAction intSetAction) {
        if (intSetAction == null) {
            throw new IllegalArgumentException("null action");
        }
        this.sparsePart.foreach(intSetAction);
        if (this.densePart != null) {
            int n = this.densePart.nextSetBit(0);
            while (n != -1) {
                intSetAction.act(n);
                n = this.densePart.nextSetBit(n + 1);
            }
        }
    }

    public void foreachExcluding(IntSet intSet, IntSetAction intSetAction) {
        this.sparsePart.foreachExcluding(intSet, intSetAction);
        if (this.densePart != null) {
            int n = this.densePart.nextSetBit(0);
            while (n != -1) {
                if (!intSet.contains(n)) {
                    intSetAction.act(n);
                }
                n = this.densePart.nextSetBit(n + 1);
            }
        }
    }

    public int max() throws IllegalStateException {
        if (this.densePart == null) {
            return this.sparsePart.max();
        }
        return Math.max(this.sparsePart.max(), this.densePart.max());
    }

    public boolean sameValue(IntSet intSet) {
        if (intSet == null) {
            throw new IllegalArgumentException("that is null");
        }
        if (this.size() != intSet.size()) {
            return false;
        }
        if (this.densePart != null) {
            int n = this.densePart.nextSetBit(0);
            while (n != -1) {
                if (!intSet.contains(n)) {
                    return false;
                }
                n = this.densePart.nextSetBit(n + 1);
            }
        }
        IntIterator intIterator = this.sparsePart.intIterator();
        while (intIterator.hasNext()) {
            if (intSet.contains(intIterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isSubset(IntSet intSet) {
        if (intSet == null) {
            throw new IllegalArgumentException("that is null");
        }
        if (this.size() > intSet.size()) {
            return false;
        }
        IntIterator intIterator = this.sparsePart.intIterator();
        while (intIterator.hasNext()) {
            if (intSet.contains(intIterator.next())) continue;
            return false;
        }
        if (this.densePart != null) {
            int n = this.densePart.nextSetBit(0);
            while (n != -1) {
                if (!intSet.contains(n)) {
                    return false;
                }
                n = this.densePart.nextSetBit(n + 1);
            }
        }
        return true;
    }

    public void copySet(IntSet intSet) throws IllegalArgumentException {
        if (intSet == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (intSet instanceof SemiSparseMutableIntSet) {
            SemiSparseMutableIntSet semiSparseMutableIntSet = (SemiSparseMutableIntSet)intSet;
            this.sparsePart = MutableSparseIntSet.make(semiSparseMutableIntSet.sparsePart);
            this.densePart = semiSparseMutableIntSet.densePart == null ? null : new OffsetBitVector(semiSparseMutableIntSet.densePart);
        } else {
            this.densePart = null;
            this.sparsePart = MutableSparseIntSet.makeEmpty();
            IntIterator intIterator = intSet.intIterator();
            while (intIterator.hasNext()) {
                this.add(intIterator.next());
            }
        }
    }

    private boolean inDenseRange(int n) {
        return this.densePart.getOffset() <= n && this.densePart.length() > n;
    }

    public boolean addAll(IntSet intSet) throws IllegalArgumentException {
        if (intSet == null) {
            throw new IllegalArgumentException("set == null");
        }
        boolean bl = false;
        if (intSet instanceof SemiSparseMutableIntSet) {
            SemiSparseMutableIntSet semiSparseMutableIntSet = (SemiSparseMutableIntSet)intSet;
            if (this.densePart == null) {
                if (semiSparseMutableIntSet.densePart != null) {
                    int n = this.size();
                    this.densePart = new OffsetBitVector(semiSparseMutableIntSet.densePart);
                    IntIterator intIterator = this.sparsePart.intIterator();
                    while (intIterator.hasNext()) {
                        int n2 = intIterator.next();
                        if (!this.inDenseRange(n2)) continue;
                        this.densePart.set(n2);
                    }
                    this.sparsePart.removeAll(this.densePart);
                    this.sparsePart.addAll(semiSparseMutableIntSet.sparsePart);
                    bl = this.size() != n;
                } else {
                    bl = this.sparsePart.addAll(semiSparseMutableIntSet.sparsePart);
                    this.fixAfterSparseInsert();
                }
            } else if (semiSparseMutableIntSet.densePart != null) {
                int n = this.size();
                this.densePart.or(semiSparseMutableIntSet.densePart);
                this.sparsePart.addAll(semiSparseMutableIntSet.sparsePart);
                IntIterator intIterator = this.sparsePart.intIterator();
                while (intIterator.hasNext()) {
                    int n3 = intIterator.next();
                    if (!this.inDenseRange(n3)) continue;
                    this.densePart.set(n3);
                }
                this.sparsePart.removeAll(this.densePart);
                bl = this.size() != n;
            } else {
                IntIterator intIterator = semiSparseMutableIntSet.sparsePart.intIterator();
                while (intIterator.hasNext()) {
                    bl |= this.add(intIterator.next());
                }
            }
        } else {
            IntIterator intIterator = intSet.intIterator();
            while (intIterator.hasNext()) {
                bl |= this.add(intIterator.next());
            }
        }
        assert (this.assertDisjoint()) : this.toString();
        return bl;
    }

    public boolean add(int n) {
        if (this.densePart != null && this.inDenseRange(n)) {
            if (!this.densePart.get(n)) {
                this.densePart.set(n);
                assert (this.assertDisjoint()) : this.toString();
                return true;
            }
        } else if (!this.sparsePart.contains(n)) {
            this.sparsePart.add(n);
            assert (this.assertDisjoint()) : this.toString();
            this.fixAfterSparseInsert();
            return true;
        }
        return false;
    }

    public boolean remove(int n) {
        if (this.densePart != null && this.densePart.get(n)) {
            this.densePart.clear(n);
            if (this.densePart.nextSetBit(0) == -1) {
                this.densePart = null;
            }
            return true;
        }
        if (this.sparsePart.contains(n)) {
            this.sparsePart.remove(n);
            return true;
        }
        return false;
    }

    public void intersectWith(IntSet intSet) {
        this.sparsePart.intersectWith(intSet);
        if (this.densePart != null) {
            int n = this.densePart.nextSetBit(0);
            while (n != -1) {
                if (!intSet.contains(n)) {
                    this.densePart.clear(n);
                }
                n = this.densePart.nextSetBit(n + 1);
            }
        }
    }

    public boolean addAllInIntersection(IntSet intSet, IntSet intSet2) {
        if (intSet == null) {
            throw new IllegalArgumentException("other is null");
        }
        if (intSet2 == null) {
            throw new IllegalArgumentException("null filter");
        }
        boolean bl = false;
        IntIterator intIterator = intSet.intIterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            if (!intSet2.contains(n)) continue;
            bl |= this.add(n);
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        if (this.densePart != null) {
            stringBuffer.append("densePart: ").append(this.densePart.toString()).append(" ");
        }
        stringBuffer.append("sparsePart: ").append(this.sparsePart.toString()).append("]");
        return stringBuffer.toString();
    }

    public SemiSparseMutableIntSet removeAll(SemiSparseMutableIntSet semiSparseMutableIntSet) {
        if (semiSparseMutableIntSet == null) {
            throw new IllegalArgumentException("B null");
        }
        if (this.densePart == null) {
            if (semiSparseMutableIntSet.densePart == null) {
                this.sparsePart = MutableSparseIntSet.diff(this.sparsePart, semiSparseMutableIntSet.sparsePart);
            } else {
                MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.diff(this.sparsePart, semiSparseMutableIntSet.sparsePart);
                IntIterator intIterator = this.sparsePart.intIterator();
                while (intIterator.hasNext()) {
                    int n = intIterator.next();
                    if (!semiSparseMutableIntSet.densePart.get(n)) continue;
                    mutableSparseIntSet.remove(n);
                }
                this.sparsePart = mutableSparseIntSet;
            }
        } else if (semiSparseMutableIntSet.densePart == null) {
            IntIterator intIterator = semiSparseMutableIntSet.sparsePart.intIterator();
            while (intIterator.hasNext()) {
                this.densePart.clear(intIterator.next());
            }
            this.sparsePart = MutableSparseIntSet.diff(this.sparsePart, semiSparseMutableIntSet.sparsePart);
        } else {
            this.densePart.andNot(semiSparseMutableIntSet.densePart);
            Object object = semiSparseMutableIntSet.sparsePart.intIterator();
            while (object.hasNext()) {
                this.densePart.clear(object.next());
            }
            object = MutableSparseIntSet.diff(this.sparsePart, semiSparseMutableIntSet.sparsePart);
            IntIterator intIterator = this.sparsePart.intIterator();
            while (intIterator.hasNext()) {
                int n = intIterator.next();
                if (!semiSparseMutableIntSet.densePart.get(n)) continue;
                ((MutableSparseIntSet)object).remove(n);
            }
            this.sparsePart = object;
        }
        return this;
    }

    public static SemiSparseMutableIntSet diff(SemiSparseMutableIntSet semiSparseMutableIntSet, SemiSparseMutableIntSet semiSparseMutableIntSet2) {
        if (semiSparseMutableIntSet == null) {
            throw new IllegalArgumentException("A is null");
        }
        if (semiSparseMutableIntSet2 == null) {
            throw new IllegalArgumentException("B is null");
        }
        if (semiSparseMutableIntSet.densePart == null) {
            if (semiSparseMutableIntSet2.densePart == null) {
                return new SemiSparseMutableIntSet(MutableSparseIntSet.diff(semiSparseMutableIntSet.sparsePart, semiSparseMutableIntSet2.sparsePart));
            }
            MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.diff(semiSparseMutableIntSet.sparsePart, semiSparseMutableIntSet2.sparsePart);
            IntIterator intIterator = semiSparseMutableIntSet.sparsePart.intIterator();
            while (intIterator.hasNext()) {
                int n = intIterator.next();
                if (!semiSparseMutableIntSet2.densePart.get(n)) continue;
                mutableSparseIntSet.remove(n);
            }
            return new SemiSparseMutableIntSet(mutableSparseIntSet);
        }
        if (semiSparseMutableIntSet2.densePart == null) {
            OffsetBitVector offsetBitVector = new OffsetBitVector(semiSparseMutableIntSet.densePart);
            IntIterator intIterator = semiSparseMutableIntSet2.sparsePart.intIterator();
            while (intIterator.hasNext()) {
                offsetBitVector.clear(intIterator.next());
            }
            return new SemiSparseMutableIntSet(MutableSparseIntSet.diff(semiSparseMutableIntSet.sparsePart, semiSparseMutableIntSet2.sparsePart), offsetBitVector);
        }
        OffsetBitVector offsetBitVector = new OffsetBitVector(semiSparseMutableIntSet.densePart);
        offsetBitVector.andNot(semiSparseMutableIntSet2.densePart);
        Object object = semiSparseMutableIntSet2.sparsePart.intIterator();
        while (object.hasNext()) {
            offsetBitVector.clear(object.next());
        }
        object = MutableSparseIntSet.diff(semiSparseMutableIntSet.sparsePart, semiSparseMutableIntSet2.sparsePart);
        IntIterator intIterator = semiSparseMutableIntSet.sparsePart.intIterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            if (!semiSparseMutableIntSet2.densePart.get(n)) continue;
            ((MutableSparseIntSet)object).remove(n);
        }
        return new SemiSparseMutableIntSet((MutableSparseIntSet)object, offsetBitVector);
    }
}

