/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrdinalSet<T>
implements Iterable<T> {
    private final IntSet S;
    private final OrdinalSetMapping<T> mapping;
    private static final OrdinalSet EMPTY = new OrdinalSet();

    public static <T> OrdinalSet<T> empty() {
        return EMPTY;
    }

    private OrdinalSet() {
        this.S = null;
        this.mapping = null;
    }

    public OrdinalSet(IntSet intSet, OrdinalSetMapping<T> ordinalSetMapping) {
        this.S = intSet;
        this.mapping = ordinalSetMapping;
    }

    public boolean containsAny(OrdinalSet<T> ordinalSet) {
        if (ordinalSet == null) {
            throw new IllegalArgumentException("null that");
        }
        if (this.S == null || ordinalSet.S == null) {
            return false;
        }
        return this.S.containsAny(ordinalSet.S);
    }

    public int size() {
        return this.S == null ? 0 : this.S.size();
    }

    @Override
    public Iterator<T> iterator() {
        if (this.S == null) {
            return EmptyIterator.instance();
        }
        return new Iterator<T>(){
            IntIterator it;
            {
                this.it = OrdinalSet.this.S.intIterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public T next() {
                return OrdinalSet.this.mapping.getMappedObject(this.it.next());
            }

            @Override
            public void remove() {
                Assertions.UNREACHABLE();
            }
        };
    }

    public static <T> OrdinalSet<T> intersect(OrdinalSet<T> ordinalSet, OrdinalSet<T> ordinalSet2) {
        if (ordinalSet == null) {
            throw new IllegalArgumentException("A is null");
        }
        if (ordinalSet.size() != 0 && ordinalSet2.size() != 0) assert (ordinalSet.mapping.equals(ordinalSet2.mapping));
        if (ordinalSet.S == null || ordinalSet2.S == null) {
            return new OrdinalSet<T>(null, ordinalSet.mapping);
        }
        IntSet intSet = ordinalSet.S.intersection(ordinalSet2.S);
        return new OrdinalSet<T>(intSet, ordinalSet.mapping);
    }

    public static <T> OrdinalSet<T> unify(OrdinalSet<T> ordinalSet, OrdinalSet<T> ordinalSet2) {
        if (ordinalSet == null) {
            throw new IllegalArgumentException("A is null");
        }
        if (ordinalSet2 == null) {
            throw new IllegalArgumentException("B is null");
        }
        if (ordinalSet.size() != 0 && ordinalSet2.size() != 0) assert (ordinalSet.mapping.equals(ordinalSet2.mapping));
        if (ordinalSet.S == null) {
            return ordinalSet2.S == null ? OrdinalSet.empty() : new OrdinalSet<T>(ordinalSet2.S, ordinalSet2.mapping);
        }
        if (ordinalSet2.S == null) {
            return new OrdinalSet<T>(ordinalSet.S, ordinalSet.mapping);
        }
        IntSet intSet = ordinalSet.S.union(ordinalSet2.S);
        return new OrdinalSet<T>(intSet, ordinalSet.mapping);
    }

    public String toString() {
        return Iterator2Collection.toSet(this.iterator()).toString();
    }

    public SparseIntSet makeSparseCopy() {
        return this.S == null ? new SparseIntSet() : new SparseIntSet(this.S);
    }

    public IntSet getBackingSet() {
        return this.S;
    }

    public boolean contains(T t) {
        if (this == EMPTY || this.S == null || t == null) {
            return false;
        }
        int n = this.mapping.getMappedIndex(t);
        return n == -1 ? false : this.S.contains(n);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public static <T> Collection<T> toCollection(OrdinalSet<T> ordinalSet) {
        return Iterator2Collection.toSet(ordinalSet.iterator());
    }

    public static <T> OrdinalSet<T> toOrdinalSet(Collection<T> collection, OrdinalSetMapping<T> ordinalSetMapping) {
        if (collection == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (ordinalSetMapping == null) {
            throw new IllegalArgumentException("m is null");
        }
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            int n = ordinalSetMapping.getMappedIndex(iterator.next());
            assert (n >= 0);
            mutableSparseIntSet.add(n);
        }
        return new OrdinalSet<T>(mutableSparseIntSet, ordinalSetMapping);
    }

    public OrdinalSetMapping<T> getMapping() {
        return this.mapping;
    }
}

