/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.LongSet;
import com.ibm.wala.util.intset.MutableLongSet;
import com.ibm.wala.util.intset.SparseLongSet;

public final class MutableSparseLongSet
extends SparseLongSet
implements MutableLongSet {
    private static final float EXPANSION_FACTOR = 1.5f;
    private static final int INITIAL_NONEMPTY_SIZE = 2;

    public static MutableSparseLongSet make(LongSet longSet) throws UnimplementedError {
        if (!(longSet instanceof SparseLongSet)) {
            Assertions.UNREACHABLE("implement me");
        }
        return new MutableSparseLongSet(longSet);
    }

    public static MutableSparseLongSet createMutableSparseLongSet(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("illegal initialCapacity: " + n);
        }
        return new MutableSparseLongSet(n);
    }

    private MutableSparseLongSet(LongSet longSet) {
        this.copySet(longSet);
    }

    public MutableSparseLongSet(long[] lArray) {
        super(lArray);
    }

    private MutableSparseLongSet(int n) {
        super(new long[n]);
        this.size = 0;
    }

    public MutableSparseLongSet() {
    }

    public void remove(long l) {
        if (this.elements != null) {
            int n = 0;
            while (n < this.size) {
                if (this.elements[n] >= l) break;
                ++n;
            }
            if (n == this.size) {
                return;
            }
            if (this.elements[n] == l) {
                if (this.size == 1) {
                    this.elements = null;
                    this.size = 0;
                } else {
                    if (n < this.size) {
                        System.arraycopy(this.elements, n + 1, this.elements, n, this.size - n - 1);
                    }
                    --this.size;
                }
            }
        }
    }

    public boolean add(long l) {
        int n;
        if (l < 0L) {
            throw new IllegalArgumentException("illegal value: " + l);
        }
        if (this.elements == null) {
            this.elements = new long[2];
            this.size = 1;
            this.elements[0] = l;
            return true;
        }
        if (this.size == 0 || l > this.max()) {
            n = this.size;
        } else {
            if (l == this.max()) {
                return false;
            }
            n = 0;
            while (n < this.size) {
                if (this.elements[n] >= l) break;
                ++n;
            }
        }
        if (n < this.size && this.elements[n] == l) {
            return false;
        }
        if (this.size < this.elements.length - 1) {
            if (this.size != n) {
                System.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
            }
            ++this.size;
            this.elements[n] = l;
            return true;
        }
        float f = (float)this.elements.length * 1.5f + 1.0f;
        long[] lArray = new long[(int)f];
        System.arraycopy(this.elements, 0, lArray, 0, n);
        if (this.size != n) {
            System.arraycopy(this.elements, n, lArray, n + 1, this.size - n);
        }
        lArray[n] = l;
        ++this.size;
        this.elements = lArray;
        return true;
    }

    public void copySet(LongSet longSet) throws UnimplementedError {
        if (longSet instanceof SparseLongSet) {
            SparseLongSet sparseLongSet = (SparseLongSet)longSet;
            if (sparseLongSet.elements != null) {
                this.elements = (long[])sparseLongSet.elements.clone();
                this.size = sparseLongSet.size;
            } else {
                this.elements = null;
                this.size = 0;
            }
        } else {
            Assertions.UNREACHABLE();
        }
    }

    public void intersectWith(LongSet longSet) {
        if (longSet == null) {
            throw new IllegalArgumentException("null set");
        }
        if (longSet instanceof SparseLongSet) {
            this.intersectWith((SparseLongSet)longSet);
        } else {
            int n = 0;
            int n2 = 0;
            while (n2 < this.size) {
                if (longSet.contains(this.elements[n2])) {
                    this.elements[n++] = this.elements[n2];
                }
                ++n2;
            }
            this.size = n;
        }
    }

    public void intersectWith(SparseLongSet sparseLongSet) {
        if (sparseLongSet == null) {
            throw new IllegalArgumentException("null set");
        }
        SparseLongSet sparseLongSet2 = sparseLongSet;
        if (this.isEmpty()) {
            return;
        }
        if (sparseLongSet2.isEmpty()) {
            this.elements = null;
            this.size = 0;
            return;
        }
        if (this.equals(sparseLongSet2)) {
            return;
        }
        if (this.size == 1) {
            if (sparseLongSet2.contains(this.elements[0])) {
                return;
            }
            this.elements = null;
            this.size = 0;
            return;
        }
        if (sparseLongSet2.size == 1) {
            if (this.contains(sparseLongSet2.elements[0])) {
                if (this.size > 2) {
                    this.elements = new long[2];
                }
                this.size = 1;
                this.elements[0] = sparseLongSet2.elements[0];
                return;
            }
            this.elements = null;
            this.size = 0;
            return;
        }
        long[] lArray = this.elements;
        int n = 0;
        int n2 = this.size;
        long[] lArray2 = sparseLongSet2.elements;
        int n3 = 0;
        int n4 = sparseLongSet2.size;
        long[] lArray3 = null;
        int n5 = 0;
        while (n < n2 && n3 < n4) {
            long l = lArray[n] - lArray2[n3];
            if (l > 0L) {
                ++n3;
                continue;
            }
            if (l < 0L) {
                ++n;
                continue;
            }
            if (lArray3 == null) {
                lArray3 = new long[n2];
            }
            lArray3[n5++] = lArray[n];
            ++n;
            ++n3;
        }
        this.size = n5;
        this.elements = lArray3;
    }

    public boolean addAll(LongSet longSet) throws UnimplementedError {
        if (longSet instanceof SparseLongSet) {
            return this.addAll((SparseLongSet)longSet);
        }
        Assertions.UNREACHABLE();
        return false;
    }

    public boolean addAll(SparseLongSet sparseLongSet) {
        if (sparseLongSet == null) {
            throw new IllegalArgumentException("null that");
        }
        if (this.isEmpty()) {
            this.copySet(sparseLongSet);
            return !sparseLongSet.isEmpty();
        }
        if (sparseLongSet.isEmpty()) {
            return false;
        }
        if (this.equals(sparseLongSet)) {
            return false;
        }
        if (sparseLongSet.size == 1) {
            boolean bl = this.add(sparseLongSet.elements[0]);
            return bl;
        }
        long[] lArray = sparseLongSet.elements;
        int n = sparseLongSet.size();
        return this.addAll(lArray, n);
    }

    private boolean addAll(long[] lArray, int n) {
        long[] lArray2 = this.elements;
        int n2 = 0;
        int n3 = this.size();
        int n4 = 0;
        long[] lArray3 = null;
        int n5 = 0;
        while (n2 < n3 && n4 < n) {
            long l = lArray2[n2] - lArray[n4];
            if (l > 0L) {
                if (lArray3 == null) {
                    lArray3 = new long[n3 + n];
                    System.arraycopy(lArray2, 0, lArray3, 0, n5);
                }
                lArray3[n5++] = lArray[n4++];
                continue;
            }
            if (l < 0L) {
                if (lArray3 != null) {
                    lArray3[n5] = lArray2[n2];
                }
                ++n5;
                ++n2;
                continue;
            }
            if (lArray3 != null) {
                lArray3[n5] = lArray2[n2];
            }
            ++n5;
            ++n2;
            ++n4;
        }
        if (n2 < n3) {
            int n6 = n3 - n2;
            if (lArray3 != null) {
                System.arraycopy(lArray2, n2, lArray3, n5, n6);
            }
            n5 += n6;
        } else if (n4 < n) {
            int n7 = n - n4;
            if (lArray3 == null) {
                lArray3 = new long[n3 + n];
                System.arraycopy(lArray2, 0, lArray3, 0, n5);
            }
            System.arraycopy(lArray, n4, lArray3, n5, n7);
            n5 += n7;
        }
        assert (n5 > 0);
        this.elements = lArray3 == null ? lArray2 : lArray3;
        this.size = n5;
        return n3 != this.size;
    }
}

