/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.collections.CompoundIntIterator;
import com.ibm.wala.util.collections.EmptyIntIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.BimodalMutableIntSet;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.BitVectorRepository;
import com.ibm.wala.util.intset.DebuggingMutableIntSet;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSetFactory;
import com.ibm.wala.util.intset.SemiSparseMutableIntSet;
import com.ibm.wala.util.intset.SparseIntSet;

public class MutableSharedBitVectorIntSet
implements MutableIntSet {
    private static final boolean DEBUG = false;
    private static final boolean PARANOID = false;
    private static final int OVERFLOW = 20;
    private MutableSparseIntSet privatePart;
    private BitVectorIntSet sharedPart;

    public MutableSharedBitVectorIntSet() {
    }

    public MutableSharedBitVectorIntSet(MutableSharedBitVectorIntSet mutableSharedBitVectorIntSet) {
        if (mutableSharedBitVectorIntSet == null) {
            throw new IllegalArgumentException("set is null");
        }
        if (mutableSharedBitVectorIntSet.privatePart != null) {
            this.privatePart = MutableSparseIntSet.make(mutableSharedBitVectorIntSet.privatePart);
        }
        this.sharedPart = mutableSharedBitVectorIntSet.sharedPart;
    }

    public MutableSharedBitVectorIntSet(SparseIntSet sparseIntSet) {
        if (sparseIntSet == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (sparseIntSet.size() == 0) {
            return;
        }
        this.privatePart = MutableSparseIntSet.make(sparseIntSet);
        this.checkOverflow();
    }

    public MutableSharedBitVectorIntSet(BitVectorIntSet bitVectorIntSet) {
        if (bitVectorIntSet == null) {
            throw new IllegalArgumentException("s is null");
        }
        this.copyValue(bitVectorIntSet);
    }

    private void copyValue(BitVectorIntSet bitVectorIntSet) {
        if (bitVectorIntSet.size() == 0) {
            this.sharedPart = null;
            this.privatePart = null;
        } else if (bitVectorIntSet.size() < 20) {
            this.sharedPart = null;
            this.privatePart = MutableSparseIntSet.make(bitVectorIntSet);
        } else {
            this.sharedPart = BitVectorRepository.findOrCreateSharedSubset(bitVectorIntSet);
            if (this.sharedPart.size() == bitVectorIntSet.size()) {
                this.privatePart = null;
            } else {
                BitVectorIntSet bitVectorIntSet2 = new BitVectorIntSet(bitVectorIntSet);
                bitVectorIntSet2.removeAll(this.sharedPart);
                this.privatePart = !bitVectorIntSet2.isEmpty() ? MutableSparseIntSet.make(bitVectorIntSet2) : null;
            }
        }
    }

    private void checkIntegrity() {
        assert (this.privatePart == null || !this.privatePart.isEmpty());
        assert (this.sharedPart == null || !this.sharedPart.isEmpty());
        if (this.privatePart != null && this.sharedPart != null) assert (this.privatePart.intersection(this.sharedPart).isEmpty());
    }

    private void checkOverflow() {
        if (this.privatePart != null && this.privatePart.size() > 20) {
            if (this.sharedPart == null) {
                BitVectorIntSet bitVectorIntSet = new BitVectorIntSet(this.privatePart);
                this.sharedPart = BitVectorRepository.findOrCreateSharedSubset(bitVectorIntSet);
                bitVectorIntSet.removeAll(this.sharedPart);
                this.privatePart = !bitVectorIntSet.isEmpty() ? MutableSparseIntSet.make(bitVectorIntSet) : null;
            } else {
                BitVectorIntSet bitVectorIntSet = new BitVectorIntSet(this.sharedPart);
                bitVectorIntSet.addAll(this.privatePart);
                this.sharedPart = BitVectorRepository.findOrCreateSharedSubset(bitVectorIntSet);
                bitVectorIntSet.removeAll(this.sharedPart);
                this.privatePart = !bitVectorIntSet.isEmpty() ? MutableSparseIntSet.make(bitVectorIntSet) : null;
            }
        }
    }

    public boolean contains(int n) {
        if (this.privatePart != null && this.privatePart.contains(n)) {
            return true;
        }
        return this.sharedPart != null && this.sharedPart.contains(n);
    }

    public IntSet intersection(IntSet intSet) {
        if (intSet == null) {
            throw new IllegalArgumentException("null that");
        }
        if (intSet instanceof MutableSharedBitVectorIntSet) {
            return this.intersection((MutableSharedBitVectorIntSet)intSet);
        }
        if (intSet instanceof BitVectorIntSet) {
            MutableSharedBitVectorIntSet mutableSharedBitVectorIntSet = new MutableSharedBitVectorIntSet((BitVectorIntSet)intSet);
            return this.intersection(mutableSharedBitVectorIntSet);
        }
        if (intSet instanceof SparseIntSet) {
            BitVectorIntSet bitVectorIntSet = new BitVectorIntSet(intSet);
            return this.intersection(bitVectorIntSet);
        }
        BitVectorIntSet bitVectorIntSet = new BitVectorIntSet();
        IntIterator intIterator = this.intIterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            if (!intSet.contains(n)) continue;
            bitVectorIntSet.add(n);
        }
        return bitVectorIntSet;
    }

    public IntSet union(IntSet intSet) {
        MutableSharedBitVectorIntSet mutableSharedBitVectorIntSet = new MutableSharedBitVectorIntSet();
        mutableSharedBitVectorIntSet.addAll(this);
        mutableSharedBitVectorIntSet.addAll(intSet);
        return mutableSharedBitVectorIntSet;
    }

    public IntSet intersection(MutableSharedBitVectorIntSet mutableSharedBitVectorIntSet) {
        MutableSparseIntSet mutableSparseIntSet = this.makeSparseCopy();
        mutableSparseIntSet.intersectWith(mutableSharedBitVectorIntSet);
        MutableSharedBitVectorIntSet mutableSharedBitVectorIntSet2 = new MutableSharedBitVectorIntSet(mutableSparseIntSet);
        return mutableSharedBitVectorIntSet2;
    }

    public boolean isEmpty() {
        return this.privatePart == null && this.sharedPart == null;
    }

    public int size() {
        int n = 0;
        n += this.privatePart == null ? 0 : this.privatePart.size();
        return n += this.sharedPart == null ? 0 : this.sharedPart.size();
    }

    public IntIterator intIterator() {
        if (this.privatePart == null) {
            return this.sharedPart == null ? EmptyIntIterator.instance() : this.sharedPart.intIterator();
        }
        return this.sharedPart == null ? this.privatePart.intIterator() : new CompoundIntIterator(this.privatePart.intIterator(), this.sharedPart.intIterator());
    }

    public void foreach(IntSetAction intSetAction) {
        if (this.privatePart != null) {
            this.privatePart.foreach(intSetAction);
        }
        if (this.sharedPart != null) {
            this.sharedPart.foreach(intSetAction);
        }
    }

    public void foreachExcluding(IntSet intSet, IntSetAction intSetAction) {
        if (intSet instanceof MutableSharedBitVectorIntSet) {
            this.foreachExcludingInternal((MutableSharedBitVectorIntSet)intSet, intSetAction);
        } else {
            this.foreachExcludingGeneral(intSet, intSetAction);
        }
    }

    private void foreachExcludingInternal(MutableSharedBitVectorIntSet mutableSharedBitVectorIntSet, IntSetAction intSetAction) {
        if (MutableSharedBitVectorIntSet.sameSharedPart(this, mutableSharedBitVectorIntSet)) {
            if (this.privatePart != null) {
                if (mutableSharedBitVectorIntSet.privatePart != null) {
                    this.privatePart.foreachExcluding(mutableSharedBitVectorIntSet.privatePart, intSetAction);
                } else {
                    this.privatePart.foreach(intSetAction);
                }
            }
        } else {
            if (this.privatePart != null) {
                this.privatePart.foreachExcluding(mutableSharedBitVectorIntSet, intSetAction);
            }
            if (this.sharedPart != null) {
                this.sharedPart.foreachExcluding(mutableSharedBitVectorIntSet.makeDenseCopy(), intSetAction);
            }
        }
    }

    private void foreachExcludingGeneral(IntSet intSet, IntSetAction intSetAction) {
        if (this.privatePart != null) {
            this.privatePart.foreachExcluding(intSet, intSetAction);
        }
        if (this.sharedPart != null) {
            this.sharedPart.foreachExcluding(intSet, intSetAction);
        }
    }

    public int max() {
        int n = -1;
        if (this.privatePart != null && this.privatePart.size() > 0) {
            n = Math.max(n, this.privatePart.max());
        }
        if (this.sharedPart != null) {
            n = Math.max(n, this.sharedPart.max());
        }
        return n;
    }

    public boolean sameValue(IntSet intSet) throws IllegalArgumentException, UnimplementedError {
        if (intSet == null) {
            throw new IllegalArgumentException("that == null");
        }
        if (intSet instanceof MutableSharedBitVectorIntSet) {
            return this.sameValue((MutableSharedBitVectorIntSet)intSet);
        }
        if (intSet instanceof SparseIntSet) {
            return this.sameValue((SparseIntSet)intSet);
        }
        if (intSet instanceof BimodalMutableIntSet) {
            return intSet.sameValue(this.makeSparseCopy());
        }
        if (intSet instanceof BitVectorIntSet) {
            return this.sameValue((BitVectorIntSet)intSet);
        }
        if (intSet instanceof SemiSparseMutableIntSet) {
            return intSet.sameValue(this);
        }
        Assertions.UNREACHABLE("unexpected class " + intSet.getClass());
        return false;
    }

    private boolean sameValue(SparseIntSet sparseIntSet) {
        if (this.size() != sparseIntSet.size()) {
            return false;
        }
        if (this.sharedPart == null) {
            if (this.privatePart == null) {
                return true;
            }
            return this.privatePart.sameValue(sparseIntSet);
        }
        return this.makeSparseCopy().sameValue(sparseIntSet);
    }

    private boolean sameValue(BitVectorIntSet bitVectorIntSet) {
        if (this.size() != bitVectorIntSet.size()) {
            return false;
        }
        if (this.sharedPart == null) {
            if (this.privatePart == null) {
                return true;
            }
            return bitVectorIntSet.makeSparseCopy().sameValue(this.privatePart);
        }
        if (this.privatePart == null) {
            return this.sharedPart.sameValue(bitVectorIntSet);
        }
        return this.makeDenseCopy().sameValue(bitVectorIntSet);
    }

    private boolean sameValue(MutableSharedBitVectorIntSet mutableSharedBitVectorIntSet) {
        if (this.size() != mutableSharedBitVectorIntSet.size()) {
            return false;
        }
        if (this.sharedPart == null) {
            if (this.privatePart == null) {
                return true;
            }
            if (mutableSharedBitVectorIntSet.sharedPart == null) {
                if (mutableSharedBitVectorIntSet.privatePart == null) {
                    return this.privatePart.isEmpty();
                }
                return this.privatePart.sameValue(mutableSharedBitVectorIntSet.privatePart);
            }
            if (mutableSharedBitVectorIntSet.privatePart == null) {
                return this.privatePart.sameValue(mutableSharedBitVectorIntSet.sharedPart);
            }
            BitVectorIntSet bitVectorIntSet = new BitVectorIntSet(mutableSharedBitVectorIntSet.sharedPart);
            bitVectorIntSet.addAllOblivious(mutableSharedBitVectorIntSet.privatePart);
            return this.privatePart.sameValue(bitVectorIntSet);
        }
        if (this.privatePart == null) {
            if (mutableSharedBitVectorIntSet.privatePart == null) {
                return this.sharedPart.sameValue(mutableSharedBitVectorIntSet.sharedPart);
            }
            if (mutableSharedBitVectorIntSet.sharedPart == null) {
                return this.sharedPart.sameValue(mutableSharedBitVectorIntSet.privatePart);
            }
            MutableSparseIntSet mutableSparseIntSet = mutableSharedBitVectorIntSet.makeSparseCopy();
            return this.sharedPart.sameValue(mutableSparseIntSet);
        }
        if (mutableSharedBitVectorIntSet.sharedPart == null) {
            Assertions.UNREACHABLE();
            return false;
        }
        if (mutableSharedBitVectorIntSet.privatePart == null) {
            MutableSparseIntSet mutableSparseIntSet = this.makeSparseCopy();
            return mutableSparseIntSet.sameValue(mutableSharedBitVectorIntSet.sharedPart);
        }
        if (this.sharedPart == mutableSharedBitVectorIntSet.sharedPart) {
            return this.privatePart.sameValue(mutableSharedBitVectorIntSet.privatePart);
        }
        MutableSparseIntSet mutableSparseIntSet = this.makeSparseCopy();
        MutableSparseIntSet mutableSparseIntSet2 = mutableSharedBitVectorIntSet.makeSparseCopy();
        return mutableSparseIntSet.sameValue(mutableSparseIntSet2);
    }

    public boolean isSubset(IntSet intSet) {
        if (intSet == null) {
            throw new IllegalArgumentException("null that");
        }
        if (intSet instanceof MutableSharedBitVectorIntSet) {
            return this.isSubset((MutableSharedBitVectorIntSet)intSet);
        }
        IntIterator intIterator = this.intIterator();
        while (intIterator.hasNext()) {
            if (intSet.contains(intIterator.next())) continue;
            return false;
        }
        return true;
    }

    private boolean isSubset(MutableSharedBitVectorIntSet mutableSharedBitVectorIntSet) {
        if (this.size() > mutableSharedBitVectorIntSet.size()) {
            return false;
        }
        if (this.sharedPart == null) {
            if (this.privatePart == null) {
                return true;
            }
            if (mutableSharedBitVectorIntSet.sharedPart == null) {
                return this.privatePart.isSubset(mutableSharedBitVectorIntSet.privatePart);
            }
            if (mutableSharedBitVectorIntSet.privatePart == null) {
                return this.privatePart.isSubset(mutableSharedBitVectorIntSet.sharedPart);
            }
            MutableSparseIntSet mutableSparseIntSet = mutableSharedBitVectorIntSet.makeSparseCopy();
            return this.privatePart.isSubset(mutableSparseIntSet);
        }
        if (this.privatePart == null) {
            if (mutableSharedBitVectorIntSet.privatePart == null) {
                if (mutableSharedBitVectorIntSet.sharedPart == null) {
                    return false;
                }
                return this.sharedPart.isSubset(mutableSharedBitVectorIntSet.sharedPart);
            }
            if (mutableSharedBitVectorIntSet.sharedPart == null) {
                return this.sharedPart.isSubset(mutableSharedBitVectorIntSet.privatePart);
            }
            MutableSparseIntSet mutableSparseIntSet = mutableSharedBitVectorIntSet.makeSparseCopy();
            return this.sharedPart.isSubset(mutableSparseIntSet);
        }
        if (mutableSharedBitVectorIntSet.privatePart == null) {
            return this.privatePart.isSubset(mutableSharedBitVectorIntSet.sharedPart) && this.sharedPart.isSubset(mutableSharedBitVectorIntSet.sharedPart);
        }
        if (mutableSharedBitVectorIntSet.sharedPart == null) {
            return this.privatePart.isSubset(mutableSharedBitVectorIntSet.privatePart) && this.sharedPart.isSubset(mutableSharedBitVectorIntSet.privatePart);
        }
        if (this.sharedPart.isSubset(mutableSharedBitVectorIntSet.sharedPart)) {
            if (this.privatePart.isSubset(mutableSharedBitVectorIntSet.privatePart)) {
                return true;
            }
            MutableSparseIntSet mutableSparseIntSet = mutableSharedBitVectorIntSet.makeSparseCopy();
            return this.privatePart.isSubset(mutableSparseIntSet);
        }
        BitVectorIntSet bitVectorIntSet = new BitVectorIntSet(this.sharedPart);
        bitVectorIntSet.removeAll(mutableSharedBitVectorIntSet.sharedPart);
        if (bitVectorIntSet.isSubset(mutableSharedBitVectorIntSet.privatePart)) {
            if (this.privatePart.isSubset(mutableSharedBitVectorIntSet.privatePart)) {
                return true;
            }
            MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.make(this.privatePart);
            mutableSparseIntSet.removeAll(mutableSharedBitVectorIntSet.privatePart);
            return mutableSparseIntSet.isSubset(mutableSharedBitVectorIntSet.sharedPart);
        }
        return false;
    }

    public void copySet(IntSet intSet) {
        if (intSet instanceof MutableSharedBitVectorIntSet) {
            MutableSharedBitVectorIntSet mutableSharedBitVectorIntSet = (MutableSharedBitVectorIntSet)intSet;
            this.privatePart = mutableSharedBitVectorIntSet.privatePart != null ? MutableSparseIntSet.make(mutableSharedBitVectorIntSet.privatePart) : null;
            this.sharedPart = mutableSharedBitVectorIntSet.sharedPart;
        } else {
            this.clear();
            this.addAll(intSet);
        }
    }

    public boolean addAll(IntSet intSet) throws IllegalArgumentException {
        if (intSet == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (intSet instanceof MutableSharedBitVectorIntSet) {
            boolean bl = this.addAll((MutableSharedBitVectorIntSet)intSet);
            return bl;
        }
        if (intSet instanceof SparseIntSet) {
            boolean bl = this.addAllInternal((SparseIntSet)intSet);
            return bl;
        }
        if (intSet instanceof BitVectorIntSet) {
            boolean bl = this.addAllInternal((BitVectorIntSet)intSet);
            return bl;
        }
        if (intSet instanceof DebuggingMutableIntSet) {
            SparseIntSet sparseIntSet = new SparseIntSet(intSet);
            boolean bl = this.addAllInternal(sparseIntSet);
            return bl;
        }
        boolean bl = false;
        IntIterator intIterator = intSet.intIterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            if (this.contains(n)) continue;
            bl = true;
            this.add(n);
        }
        return bl;
    }

    private boolean addAllInternal(BitVectorIntSet bitVectorIntSet) {
        assert (this.sharedPart != bitVectorIntSet);
        if (this.privatePart == null && this.sharedPart == null) {
            this.copyValue(bitVectorIntSet);
            return !bitVectorIntSet.isEmpty();
        }
        BitVectorIntSet bitVectorIntSet2 = this.makeDenseCopy();
        boolean bl = bitVectorIntSet2.addAll(bitVectorIntSet);
        this.copyValue(bitVectorIntSet2);
        return bl;
    }

    private boolean addAllInternal(SparseIntSet sparseIntSet) {
        if (this.privatePart == null) {
            if (this.sharedPart == null) {
                if (!sparseIntSet.isEmpty()) {
                    this.privatePart = MutableSparseIntSet.make(sparseIntSet);
                    this.sharedPart = null;
                    this.checkOverflow();
                    return true;
                }
                return false;
            }
            this.privatePart = MutableSparseIntSet.make(sparseIntSet);
            this.privatePart.removeAll(this.sharedPart);
            if (this.privatePart.isEmpty()) {
                this.privatePart = null;
                return false;
            }
            this.checkOverflow();
            return true;
        }
        if (this.sharedPart == null) {
            boolean bl = this.privatePart.addAll(sparseIntSet);
            this.checkOverflow();
            return bl;
        }
        int n = this.privatePart.size();
        this.privatePart.addAll(sparseIntSet);
        this.privatePart.removeAll(this.sharedPart);
        boolean bl = this.privatePart.size() > n;
        this.checkOverflow();
        return bl;
    }

    private boolean addAll(MutableSharedBitVectorIntSet mutableSharedBitVectorIntSet) {
        BitVectorIntSet bitVectorIntSet;
        if (mutableSharedBitVectorIntSet.isEmpty()) {
            return false;
        }
        if (this.isEmpty()) {
            if (mutableSharedBitVectorIntSet.privatePart != null) {
                this.privatePart = MutableSparseIntSet.make(mutableSharedBitVectorIntSet.privatePart);
            }
            this.sharedPart = mutableSharedBitVectorIntSet.sharedPart;
            return true;
        }
        if (mutableSharedBitVectorIntSet.sharedPart == null) {
            return this.addAllInternal(mutableSharedBitVectorIntSet.privatePart);
        }
        if (MutableSharedBitVectorIntSet.sameSharedPart(this, mutableSharedBitVectorIntSet)) {
            if (mutableSharedBitVectorIntSet.privatePart == null) {
                return false;
            }
            return this.addAllInternal(mutableSharedBitVectorIntSet.privatePart);
        }
        if (mutableSharedBitVectorIntSet.privatePart == null) {
            if (this.sharedPart == null || this.sharedPart.isSubset(mutableSharedBitVectorIntSet.sharedPart)) {
                int n = this.size();
                if (this.privatePart != null) {
                    this.privatePart.removeAll(mutableSharedBitVectorIntSet.sharedPart);
                    this.privatePart = this.privatePart.isEmpty() ? null : this.privatePart;
                }
                this.sharedPart = mutableSharedBitVectorIntSet.sharedPart;
                return this.size() > n;
            }
            BitVectorIntSet bitVectorIntSet2 = this.makeDenseCopy();
            boolean bl = bitVectorIntSet2.addAll(mutableSharedBitVectorIntSet.sharedPart);
            if (bl) {
                if (bitVectorIntSet2.sameValue(mutableSharedBitVectorIntSet.sharedPart)) {
                    this.privatePart = null;
                    this.sharedPart = mutableSharedBitVectorIntSet.sharedPart;
                } else {
                    this.copyValue(bitVectorIntSet2);
                }
            }
            return bl;
        }
        BitVectorIntSet bitVectorIntSet3 = this.makeDenseCopy();
        boolean bl = bitVectorIntSet3.addAll(bitVectorIntSet = mutableSharedBitVectorIntSet.makeDenseCopy());
        if (bl) {
            if (bitVectorIntSet3.sameValue(bitVectorIntSet)) {
                this.privatePart = MutableSparseIntSet.make(mutableSharedBitVectorIntSet.privatePart);
                this.sharedPart = mutableSharedBitVectorIntSet.sharedPart;
            } else {
                this.copyValue(bitVectorIntSet3);
            }
        }
        return bl;
    }

    public boolean add(int n) {
        if (this.privatePart == null) {
            if (this.sharedPart == null) {
                this.privatePart = MutableSparseIntSet.makeEmpty();
                this.privatePart.add(n);
                return true;
            }
            if (this.sharedPart.contains(n)) {
                return false;
            }
            this.privatePart = MutableSparseIntSet.makeEmpty();
            this.privatePart.add(n);
            return true;
        }
        if (this.sharedPart == null) {
            boolean bl = this.privatePart.add(n);
            this.checkOverflow();
            return bl;
        }
        if (this.sharedPart.contains(n)) {
            return false;
        }
        boolean bl = this.privatePart.add(n);
        this.checkOverflow();
        return bl;
    }

    public boolean remove(int n) {
        if (this.privatePart != null && this.privatePart.contains(n)) {
            this.privatePart.remove(n);
            if (this.privatePart.size() == 0) {
                this.privatePart = null;
            }
            return true;
        }
        if (this.sharedPart != null && this.sharedPart.contains(n)) {
            this.privatePart = this.makeSparseCopy();
            this.privatePart.remove(n);
            if (this.privatePart.size() == 0) {
                this.privatePart = null;
            }
            this.sharedPart = null;
            this.checkOverflow();
            return true;
        }
        return false;
    }

    public void intersectWith(IntSet intSet) {
        if (intSet instanceof MutableSharedBitVectorIntSet) {
            this.intersectWithInternal((MutableSharedBitVectorIntSet)intSet);
        } else if (intSet instanceof BitVectorIntSet) {
            this.intersectWithInternal(new MutableSharedBitVectorIntSet((BitVectorIntSet)intSet));
        } else {
            IntIterator intIterator = this.intIterator();
            while (intIterator.hasNext()) {
                int n = intIterator.next();
                if (intSet.contains(n)) continue;
                this.remove(n);
            }
        }
    }

    private void intersectWithInternal(MutableSharedBitVectorIntSet mutableSharedBitVectorIntSet) {
        if (this.sharedPart != null) {
            if (MutableSharedBitVectorIntSet.sameSharedPart(this, mutableSharedBitVectorIntSet)) {
                if (this.privatePart != null) {
                    if (mutableSharedBitVectorIntSet.privatePart == null) {
                        this.privatePart = null;
                    } else {
                        this.privatePart.intersectWith(mutableSharedBitVectorIntSet.privatePart);
                        if (this.privatePart.isEmpty()) {
                            this.privatePart = null;
                        }
                    }
                }
            } else if (mutableSharedBitVectorIntSet.sharedPart == null) {
                if (mutableSharedBitVectorIntSet.privatePart == null) {
                    this.privatePart = null;
                    this.sharedPart = null;
                } else {
                    MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.make(mutableSharedBitVectorIntSet.privatePart);
                    mutableSparseIntSet.intersectWith(this);
                    this.sharedPart = null;
                    if (mutableSparseIntSet.isEmpty()) {
                        this.privatePart = null;
                    } else {
                        this.privatePart = mutableSparseIntSet;
                        this.checkOverflow();
                    }
                }
            } else {
                BitVectorIntSet bitVectorIntSet = this.makeDenseCopy();
                bitVectorIntSet.intersectWith(mutableSharedBitVectorIntSet.makeDenseCopy());
                this.copyValue(bitVectorIntSet);
            }
        } else if (this.privatePart != null) {
            this.privatePart.intersectWith(mutableSharedBitVectorIntSet);
            if (this.privatePart.isEmpty()) {
                this.privatePart = null;
            }
        }
    }

    public static boolean sameSharedPart(MutableSharedBitVectorIntSet mutableSharedBitVectorIntSet, MutableSharedBitVectorIntSet mutableSharedBitVectorIntSet2) {
        if (mutableSharedBitVectorIntSet2 == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (mutableSharedBitVectorIntSet == null) {
            throw new IllegalArgumentException("a is null");
        }
        return mutableSharedBitVectorIntSet.sharedPart == mutableSharedBitVectorIntSet2.sharedPart;
    }

    public String toString() {
        return this.makeSparseCopy().toString();
    }

    MutableSparseIntSet makeSparseCopy() {
        if (this.privatePart == null) {
            if (this.sharedPart == null) {
                return MutableSparseIntSet.makeEmpty();
            }
            return new MutableSparseIntSetFactory().makeCopy(this.sharedPart);
        }
        if (this.sharedPart == null) {
            return MutableSparseIntSet.make(this.privatePart);
        }
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.make(this.privatePart);
        mutableSparseIntSet.addAll(this.sharedPart);
        return mutableSparseIntSet;
    }

    BitVectorIntSet makeDenseCopy() {
        if (this.privatePart == null) {
            if (this.sharedPart == null) {
                return new BitVectorIntSet();
            }
            return new BitVectorIntSet(this.sharedPart);
        }
        if (this.sharedPart == null) {
            return new BitVectorIntSet(this.privatePart);
        }
        BitVectorIntSet bitVectorIntSet = new BitVectorIntSet(this.sharedPart);
        bitVectorIntSet.addAllOblivious(this.privatePart);
        return bitVectorIntSet;
    }

    public boolean hasSharedPart() {
        return this.sharedPart != null;
    }

    public boolean containsAny(IntSet intSet) {
        if (intSet instanceof MutableSharedBitVectorIntSet) {
            MutableSharedBitVectorIntSet mutableSharedBitVectorIntSet = (MutableSharedBitVectorIntSet)intSet;
            if (this.sharedPart != null) {
                if (mutableSharedBitVectorIntSet.sharedPart != null && this.sharedPart.containsAny(mutableSharedBitVectorIntSet.sharedPart)) {
                    return true;
                }
                if (mutableSharedBitVectorIntSet.privatePart != null && this.sharedPart.containsAny(mutableSharedBitVectorIntSet.privatePart)) {
                    return true;
                }
            }
            return this.privatePart != null && this.privatePart.containsAny(intSet);
        }
        if (this.sharedPart != null && this.sharedPart.containsAny(intSet)) {
            return true;
        }
        return this.privatePart != null && this.privatePart.containsAny(intSet);
    }

    public boolean addAllInIntersection(IntSet intSet, IntSet intSet2) {
        if (intSet instanceof MutableSharedBitVectorIntSet) {
            return this.addAllInIntersectionInternal((MutableSharedBitVectorIntSet)intSet, intSet2);
        }
        return this.addAllInIntersectionGeneral(intSet, intSet2);
    }

    private boolean addAllInIntersectionGeneral(IntSet intSet, IntSet intSet2) {
        BitVectorIntSet bitVectorIntSet = new BitVectorIntSet(intSet);
        bitVectorIntSet.intersectWith(intSet2);
        return this.addAll(bitVectorIntSet);
    }

    private boolean addAllInIntersectionInternal(MutableSharedBitVectorIntSet mutableSharedBitVectorIntSet, IntSet intSet) {
        if (mutableSharedBitVectorIntSet.sharedPart == null) {
            if (mutableSharedBitVectorIntSet.privatePart == null) {
                return false;
            }
            return this.addAllInIntersectionInternal(mutableSharedBitVectorIntSet.privatePart, intSet);
        }
        if (this.sharedPart == mutableSharedBitVectorIntSet.sharedPart) {
            if (mutableSharedBitVectorIntSet.privatePart == null) {
                return false;
            }
            return this.addAllInIntersectionInternal(mutableSharedBitVectorIntSet.privatePart, intSet);
        }
        MutableSharedBitVectorIntSet mutableSharedBitVectorIntSet2 = new MutableSharedBitVectorIntSet(mutableSharedBitVectorIntSet);
        mutableSharedBitVectorIntSet2.intersectWith(intSet);
        return this.addAll(mutableSharedBitVectorIntSet2);
    }

    private boolean addAllInIntersectionInternal(SparseIntSet sparseIntSet, IntSet intSet) {
        if (this.sharedPart == null) {
            if (this.privatePart == null) {
                this.privatePart = MutableSparseIntSet.make(sparseIntSet);
                this.privatePart.intersectWith(intSet);
                if (this.privatePart.size() == 0) {
                    this.privatePart = null;
                }
                this.checkOverflow();
                return this.size() > 0;
            }
            boolean bl = this.privatePart.addAllInIntersection(sparseIntSet, intSet);
            this.checkOverflow();
            return bl;
        }
        if (this.privatePart == null) {
            this.privatePart = MutableSparseIntSet.make(this.sharedPart);
            this.sharedPart = null;
            boolean bl = this.privatePart.addAllInIntersection(sparseIntSet, intSet);
            this.checkOverflow();
            return bl;
        }
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.make(sparseIntSet);
        mutableSparseIntSet.intersectWith(intSet);
        return this.addAll(mutableSparseIntSet);
    }

    public void clear() {
        this.privatePart = null;
        this.sharedPart = null;
    }
}

