/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.IntVector;
import com.ibm.wala.util.intset.NumberUtility;
import java.util.Arrays;

public class MultiModalIntVector
implements IntVector {
    private static final float INITIAL_GROWTH_FACTOR = 1.5f;
    private static final float MINIMUM_GROWTH_FACTOR = 1.1f;
    private static final float DIFF_GROWTH_FACTOR = 0.39999998f;
    private float CURRENT_GROWTH_RATE = 1.5f;
    private static final int MAX_SIZE = 10000;
    private static final int INITIAL_SIZE = 1;
    int maxIndex = -1;
    private int[] intStore = new int[0];
    private short[] shortStore = new short[0];
    private byte[] byteStore = new byte[0];
    final int defaultValue;

    public MultiModalIntVector(int n) {
        this.defaultValue = n;
        this.init(this.getInitialSize(), n);
    }

    private void init(int n, int n2) {
        if (NumberUtility.isByte(n2)) {
            this.byteStore = new byte[n];
            this.byteStore[0] = (byte)n2;
        } else if (NumberUtility.isShort(n2)) {
            this.shortStore = new short[n];
            this.shortStore[0] = (short)n2;
        } else {
            this.intStore = new int[n];
            this.intStore[0] = n2;
        }
    }

    public MultiModalIntVector(int n, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("invalid initialSize: " + n2);
        }
        this.defaultValue = n;
        this.init(n2, n);
    }

    int getInitialSize() {
        return 1;
    }

    float getGrowthFactor() {
        return 1.5f;
    }

    float getGrowthFactor(int n) {
        if (this.CURRENT_GROWTH_RATE >= 1.1f) {
            float f = (float)(1.0 / (1.0 + Math.pow(Math.E, -1.0 * ((double)(n / 10000) * 12.0 - 6.0))));
            this.CURRENT_GROWTH_RATE = 1.5f - 0.39999998f * f;
        }
        return this.CURRENT_GROWTH_RATE;
    }

    public int get(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("illegal x: " + n);
        }
        int n2 = n;
        if (n2 < this.byteStore.length) {
            return this.byteStore[n2];
        }
        if ((n2 -= this.byteStore.length) < this.shortStore.length) {
            return this.shortStore[n2];
        }
        if ((n2 -= this.shortStore.length) < this.intStore.length) {
            return this.intStore[n2];
        }
        return this.defaultValue;
    }

    private int getStoreLength() {
        return this.shortStore.length + this.byteStore.length + this.intStore.length;
    }

    public void set(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("illegal x: " + n);
        }
        if (n > 10000) {
            throw new IllegalArgumentException("x is too big: " + n);
        }
        this.maxIndex = Math.max(this.maxIndex, n);
        this.handleMorph(n, n2);
        if (n2 == this.defaultValue) {
            int n3 = this.getStoreLength();
            if (n >= n3) {
                return;
            }
            this.add(n2, n);
        } else {
            this.ensureCapacity(n, n2);
            this.add(n2, n);
        }
    }

    private void add(int n, int n2) {
        if (this.byteStore.length > n2) {
            this.byteStore[n2] = (byte)n;
        } else if (this.shortStore.length > (n2 -= this.byteStore.length)) {
            this.shortStore[n2] = (short)n;
        } else {
            this.intStore[n2 -= this.shortStore.length] = n;
        }
    }

    private void handleMorph(int n, int n2) {
        if (NumberUtility.isShort(n2)) {
            if (n < this.byteStore.length) {
                int n3 = this.byteStore.length - n + this.shortStore.length;
                short[] sArray = new short[n3];
                byte[] byArray = new byte[n];
                int n4 = n;
                while (n4 < this.byteStore.length) {
                    sArray[n4 - n] = this.byteStore[n4];
                    ++n4;
                }
                System.arraycopy(this.byteStore, 0, byArray, 0, n);
                System.arraycopy(this.shortStore, 0, sArray, this.byteStore.length - n, this.shortStore.length);
                this.byteStore = byArray;
                this.shortStore = sArray;
            }
        } else if (!NumberUtility.isByte(n2)) {
            if (n < this.byteStore.length) {
                int n5 = this.byteStore.length - n + this.intStore.length;
                int[] nArray = new int[n5];
                int n6 = n;
                while (n6 < this.byteStore.length) {
                    nArray[n6 - n] = this.byteStore[n6];
                    ++n6;
                }
                byte[] byArray = new byte[n];
                System.arraycopy(this.byteStore, 0, byArray, 0, n);
                int n7 = 0;
                while (n7 < this.shortStore.length) {
                    nArray[this.byteStore.length - 1 + n7] = this.shortStore[n7];
                    ++n7;
                }
                System.arraycopy(this.intStore, 0, nArray, this.byteStore.length + this.shortStore.length - n, this.intStore.length);
                this.intStore = nArray;
                this.byteStore = byArray;
                this.shortStore = new short[0];
            } else {
                int n8 = n - this.byteStore.length;
                if (n8 < this.shortStore.length) {
                    int n9 = this.shortStore.length - n8 + this.intStore.length;
                    int[] nArray = new int[n9];
                    int n10 = n8;
                    while (n10 < this.shortStore.length) {
                        nArray[n10 - n8] = this.shortStore[n10];
                        ++n10;
                    }
                    short[] sArray = new short[n8];
                    System.arraycopy(this.shortStore, 0, sArray, 0, n8);
                    System.arraycopy(this.intStore, 0, nArray, this.shortStore.length - n8, this.intStore.length);
                    this.intStore = nArray;
                    this.shortStore = sArray;
                }
            }
        }
    }

    private void ensureCapacity(int n, int n2) {
        int n3 = this.getStoreLength();
        if (this.intStore.length > 0 || !NumberUtility.isShort(n2) && !NumberUtility.isByte(n2)) {
            if (n >= n3) {
                int[] nArray = this.intStore;
                int n4 = 1 + (int)(this.getGrowthFactor(n3) * (float)n) - this.byteStore.length - this.shortStore.length;
                int[] nArray2 = new int[n4];
                Arrays.fill(nArray2, this.defaultValue);
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                this.intStore = nArray2;
            }
        } else if (this.shortStore.length > 0 || NumberUtility.isShort(n2)) {
            if (n >= n3) {
                short[] sArray = this.shortStore;
                int n5 = 1 + (int)(this.getGrowthFactor(n3) * (float)n) - this.byteStore.length;
                short[] sArray2 = new short[n5];
                Arrays.fill(sArray2, (short)this.defaultValue);
                System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
                this.shortStore = sArray2;
            }
        } else if (n >= n3) {
            byte[] byArray = this.byteStore;
            int n6 = 1 + (int)(this.getGrowthFactor(n3) * (float)n);
            byte[] byArray2 = new byte[n6];
            Arrays.fill(byArray2, (byte)this.defaultValue);
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.byteStore = byArray2;
        }
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public void print() {
        String string = "";
        int n = 0;
        while (n < this.byteStore.length) {
            string = String.valueOf(string) + this.byteStore[n] + ",";
            ++n;
        }
        n = 0;
        while (n < this.shortStore.length) {
            string = String.valueOf(string) + this.shortStore[n] + ",";
            ++n;
        }
        n = 0;
        while (n < this.intStore.length) {
            string = String.valueOf(string) + this.intStore[n] + ",";
            ++n;
        }
        System.out.println(string);
    }
}

