/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.BimodalMutableIntSet;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.DebuggingMutableIntSet;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableIntSetFactory;
import com.ibm.wala.util.intset.MutableSharedBitVectorIntSet;
import com.ibm.wala.util.intset.MutableSharedBitVectorIntSetFactory;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SemiSparseMutableIntSet;
import com.ibm.wala.util.intset.SparseIntSet;

public class IntSetUtil {
    public static final String INT_SET_FACTORY_CONFIG_PROPERTY_NAME = "com.ibm.wala.mutableIntSetFactory";
    private static MutableIntSetFactory defaultIntSetFactory;
    private static final boolean DEBUG = false;

    static {
        MutableSharedBitVectorIntSetFactory mutableSharedBitVectorIntSetFactory = new MutableSharedBitVectorIntSetFactory();
        if (System.getProperty(INT_SET_FACTORY_CONFIG_PROPERTY_NAME) != null) {
            try {
                Class<?> clazz = Class.forName(System.getProperty(INT_SET_FACTORY_CONFIG_PROPERTY_NAME));
                MutableIntSetFactory mutableIntSetFactory = (MutableIntSetFactory)clazz.newInstance();
                IntSetUtil.setDefaultIntSetFactory(mutableIntSetFactory);
            }
            catch (Exception exception) {
                System.err.println("Cannot use int set factory " + System.getProperty(INT_SET_FACTORY_CONFIG_PROPERTY_NAME));
                IntSetUtil.setDefaultIntSetFactory(mutableSharedBitVectorIntSetFactory);
            }
        } else {
            IntSetUtil.setDefaultIntSetFactory(mutableSharedBitVectorIntSetFactory);
        }
        assert (defaultIntSetFactory != null);
    }

    public static MutableIntSet make() {
        return defaultIntSetFactory.make();
    }

    private IntSetUtil() {
    }

    public static MutableIntSet makeMutableCopy(IntSet intSet) throws IllegalArgumentException, UnimplementedError {
        if (intSet == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (intSet instanceof SparseIntSet) {
            return MutableSparseIntSet.make(intSet);
        }
        if (intSet instanceof BitVectorIntSet) {
            return new BitVectorIntSet(intSet);
        }
        if (intSet instanceof BimodalMutableIntSet) {
            return BimodalMutableIntSet.makeCopy(intSet);
        }
        if (intSet instanceof MutableSharedBitVectorIntSet) {
            return new MutableSharedBitVectorIntSet((MutableSharedBitVectorIntSet)intSet);
        }
        if (intSet instanceof SemiSparseMutableIntSet) {
            return new SemiSparseMutableIntSet((SemiSparseMutableIntSet)intSet);
        }
        if (intSet instanceof DebuggingMutableIntSet) {
            MutableIntSet mutableIntSet = IntSetUtil.makeMutableCopy(((DebuggingMutableIntSet)intSet).primaryImpl);
            MutableIntSet mutableIntSet2 = IntSetUtil.makeMutableCopy(((DebuggingMutableIntSet)intSet).secondaryImpl);
            return new DebuggingMutableIntSet(mutableIntSet, mutableIntSet2);
        }
        Assertions.UNREACHABLE(intSet.getClass().toString());
        return null;
    }

    public static IntSet diff(IntSet intSet, IntSet intSet2) {
        if (intSet == null) {
            throw new IllegalArgumentException("null A");
        }
        if (intSet2 == null) {
            throw new IllegalArgumentException("null B");
        }
        return IntSetUtil.diff(intSet, intSet2, IntSetUtil.getDefaultIntSetFactory());
    }

    private static IntSet defaultSlowDiff(IntSet intSet, IntSet intSet2, MutableIntSetFactory mutableIntSetFactory) {
        Object t = mutableIntSetFactory.makeCopy(intSet);
        IntIterator intIterator = intSet2.intIterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            t.remove(n);
        }
        return t;
    }

    public static IntSet diff(IntSet intSet, IntSet intSet2, MutableIntSetFactory mutableIntSetFactory) {
        if (mutableIntSetFactory == null) {
            throw new IllegalArgumentException("null factory");
        }
        if (intSet == null) {
            throw new IllegalArgumentException("null A");
        }
        if (intSet2 == null) {
            throw new IllegalArgumentException("null B");
        }
        if (intSet instanceof SparseIntSet && intSet2 instanceof SparseIntSet) {
            return SparseIntSet.diff((SparseIntSet)intSet, (SparseIntSet)intSet2);
        }
        if (intSet instanceof SemiSparseMutableIntSet && intSet2 instanceof SemiSparseMutableIntSet) {
            SemiSparseMutableIntSet semiSparseMutableIntSet = SemiSparseMutableIntSet.diff((SemiSparseMutableIntSet)intSet, (SemiSparseMutableIntSet)intSet2);
            return semiSparseMutableIntSet;
        }
        return IntSetUtil.defaultSlowDiff(intSet, intSet2, mutableIntSetFactory);
    }

    public static MutableIntSet removeAll(MutableIntSet mutableIntSet, IntSet intSet) throws IllegalArgumentException {
        if (mutableIntSet == null) {
            throw new IllegalArgumentException("A == null");
        }
        if (intSet == null) {
            throw new IllegalArgumentException("B == null");
        }
        if (mutableIntSet instanceof SemiSparseMutableIntSet && intSet instanceof SemiSparseMutableIntSet) {
            return ((SemiSparseMutableIntSet)mutableIntSet).removeAll((SemiSparseMutableIntSet)intSet);
        }
        IntIterator intIterator = intSet.intIterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            mutableIntSet.remove(n);
        }
        return mutableIntSet;
    }

    public static int binarySearch(int[] nArray, int n, int n2, int n3) throws IllegalArgumentException {
        if (nArray == null) {
            throw new IllegalArgumentException("null array");
        }
        if (nArray.length == 0) {
            return -1;
        }
        if (n2 <= n3 && (n2 < 0 || n3 < 0)) {
            throw new IllegalArgumentException("can't search negative indices " + n2 + " " + n3);
        }
        if (n3 > nArray.length - 1) {
            n3 = nArray.length - 1;
        }
        if (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            int n5 = nArray[n4];
            if (n5 == n) {
                return n4;
            }
            if (n5 > n) {
                return IntSetUtil.binarySearch(nArray, n, n2, n4 - 1);
            }
            return IntSetUtil.binarySearch(nArray, n, n4 + 1, n3);
        }
        return -1;
    }

    public static MutableIntSetFactory getDefaultIntSetFactory() {
        return defaultIntSetFactory;
    }

    public static void setDefaultIntSetFactory(MutableIntSetFactory mutableIntSetFactory) {
        if (mutableIntSetFactory == null) {
            throw new IllegalArgumentException("null defaultIntSetFactory");
        }
        defaultIntSetFactory = mutableIntSetFactory;
    }

    public static IntSet add(IntSet intSet, int n) throws IllegalArgumentException {
        if (intSet == null) {
            throw new IllegalArgumentException("s == null");
        }
        if (intSet instanceof SparseIntSet) {
            SparseIntSet sparseIntSet = (SparseIntSet)intSet;
            return SparseIntSet.add(sparseIntSet, n);
        }
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.make(intSet);
        mutableSparseIntSet.add(n);
        return mutableSparseIntSet;
    }

    public static int[] toArray(IntSet intSet) {
        int n = 0;
        int[] nArray = new int[intSet.size()];
        IntIterator intIterator = intSet.intIterator();
        while (intIterator.hasNext()) {
            nArray[n++] = intIterator.next();
        }
        assert (!intIterator.hasNext());
        return nArray;
    }
}

