/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.BimodalMutableIntSet;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableSharedBitVectorIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SparseIntSet;

public final class BitVectorIntSet
implements MutableIntSet {
    private int populationCount = 0;
    private static final int UNDEFINED = -1;
    private BitVector bitVector = new BitVector(0);

    public BitVectorIntSet() {
    }

    public BitVectorIntSet(BitVector bitVector) {
        if (bitVector == null) {
            throw new IllegalArgumentException("null v");
        }
        this.bitVector.or(bitVector);
        this.populationCount = -1;
    }

    public BitVectorIntSet(IntSet intSet) throws IllegalArgumentException {
        if (intSet == null) {
            throw new IllegalArgumentException("S == null");
        }
        this.copySet(intSet);
    }

    public void clear() {
        this.bitVector.clearAll();
        this.populationCount = 0;
    }

    public void copySet(IntSet intSet) throws IllegalArgumentException {
        if (intSet == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (intSet instanceof BitVectorIntSet) {
            BitVectorIntSet bitVectorIntSet = (BitVectorIntSet)intSet;
            this.bitVector = new BitVector(bitVectorIntSet.bitVector);
            this.populationCount = bitVectorIntSet.populationCount;
        } else if (intSet instanceof MutableSharedBitVectorIntSet) {
            BitVectorIntSet bitVectorIntSet = ((MutableSharedBitVectorIntSet)intSet).makeDenseCopy();
            this.bitVector = new BitVector(bitVectorIntSet.bitVector);
            this.populationCount = bitVectorIntSet.populationCount;
        } else if (intSet instanceof SparseIntSet) {
            SparseIntSet sparseIntSet = (SparseIntSet)intSet;
            if (sparseIntSet.size == 0) {
                this.populationCount = 0;
                this.bitVector = new BitVector(0);
            } else {
                this.bitVector = new BitVector(sparseIntSet.max());
                this.populationCount = sparseIntSet.size;
                int n = 0;
                while (n < sparseIntSet.size) {
                    this.bitVector.set(sparseIntSet.elements[n]);
                    ++n;
                }
            }
        } else if (intSet instanceof BimodalMutableIntSet) {
            IntSet intSet2 = ((BimodalMutableIntSet)intSet).getBackingStore();
            this.copySet(intSet2);
        } else {
            this.bitVector.clearAll();
            this.populationCount = intSet.size();
            IntIterator intIterator = intSet.intIterator();
            while (intIterator.hasNext()) {
                this.bitVector.set(intIterator.next());
            }
        }
    }

    public boolean addAll(IntSet intSet) {
        if (intSet instanceof BitVectorIntSet) {
            BitVector bitVector = ((BitVectorIntSet)intSet).bitVector;
            int n = this.bitVector.orWithDelta(bitVector);
            this.populationCount += n;
            int n2 = this.populationCount = this.populationCount == n + -1 ? -1 : this.populationCount;
            return n != 0;
        }
        BitVectorIntSet bitVectorIntSet = new BitVectorIntSet(intSet);
        return this.addAll(bitVectorIntSet);
    }

    public void addAllOblivious(IntSet intSet) throws IllegalArgumentException {
        if (intSet == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (intSet instanceof BitVectorIntSet) {
            BitVector bitVector = ((BitVectorIntSet)intSet).bitVector;
            this.bitVector.or(bitVector);
            this.populationCount = -1;
        } else {
            BitVectorIntSet bitVectorIntSet = new BitVectorIntSet(intSet);
            this.addAllOblivious(bitVectorIntSet);
        }
    }

    public boolean add(int n) {
        if (this.bitVector.get(n)) {
            return false;
        }
        this.bitVector.set(n);
        ++this.populationCount;
        this.populationCount = this.populationCount == 0 ? -1 : this.populationCount;
        return true;
    }

    public boolean remove(int n) {
        if (this.contains(n)) {
            --this.populationCount;
            this.populationCount = this.populationCount == -2 ? -1 : this.populationCount;
            this.bitVector.clear(n);
            return true;
        }
        return false;
    }

    public void intersectWith(IntSet intSet) {
        if (!(intSet instanceof BitVectorIntSet)) {
            intSet = new BitVectorIntSet(intSet);
        }
        BitVector bitVector = ((BitVectorIntSet)intSet).bitVector;
        this.bitVector.and(bitVector);
        this.populationCount = -1;
    }

    public IntSet intersection(IntSet intSet) {
        BitVectorIntSet bitVectorIntSet = new BitVectorIntSet();
        bitVectorIntSet.copySet(this);
        bitVectorIntSet.intersectWith(intSet);
        return bitVectorIntSet;
    }

    public IntSet union(IntSet intSet) {
        BitVectorIntSet bitVectorIntSet = new BitVectorIntSet();
        bitVectorIntSet.addAll(this);
        bitVectorIntSet.addAll(intSet);
        return bitVectorIntSet;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        this.populationCount = this.populationCount == -1 ? this.bitVector.populationCount() : this.populationCount;
        return this.populationCount;
    }

    public IntIterator intIterator() {
        this.populationCount = this.populationCount == -1 ? this.bitVector.populationCount() : this.populationCount;
        return new IntIterator(){
            int count = 0;
            int last = 0;

            public boolean hasNext() {
                return this.count < BitVectorIntSet.this.populationCount;
            }

            public int next() {
                ++this.count;
                this.last = BitVectorIntSet.this.nextSetBit(this.last) + 1;
                return this.last - 1;
            }
        };
    }

    public void foreach(IntSetAction intSetAction) {
        if (intSetAction == null) {
            throw new IllegalArgumentException("null action");
        }
        int n = this.bitVector.nextSetBit(0);
        this.populationCount = this.populationCount == -1 ? this.bitVector.populationCount() : this.populationCount;
        int n2 = 0;
        while (n2 < this.populationCount) {
            intSetAction.act(n);
            n = this.bitVector.nextSetBit(n + 1);
            ++n2;
        }
    }

    public SparseIntSet makeSparseCopy() {
        this.populationCount = this.populationCount == -1 ? this.bitVector.populationCount() : this.populationCount;
        int[] nArray = new int[this.populationCount];
        int n = 0;
        int n2 = -1;
        while (n < this.populationCount) {
            nArray[n++] = n2 = this.bitVector.nextSetBit(n2 + 1);
        }
        return new SparseIntSet(nArray);
    }

    public void foreachExcluding(IntSet intSet, IntSetAction intSetAction) {
        if (intSet instanceof BitVectorIntSet) {
            this.fastForeachExcluding((BitVectorIntSet)intSet, intSetAction);
        } else {
            this.slowForeachExcluding(intSet, intSetAction);
        }
    }

    private void slowForeachExcluding(IntSet intSet, IntSetAction intSetAction) {
        this.populationCount = this.populationCount == -1 ? this.bitVector.populationCount() : this.populationCount;
        int n = 0;
        int n2 = 0;
        while (n2 < this.populationCount) {
            if (this.contains(n)) {
                if (!intSet.contains(n)) {
                    intSetAction.act(n);
                }
                ++n2;
            }
            ++n;
        }
    }

    private void fastForeachExcluding(BitVectorIntSet bitVectorIntSet, IntSetAction intSetAction) {
        int[] nArray = this.bitVector.bits;
        int[] nArray2 = bitVectorIntSet.bitVector.bits;
        int n = 0;
        while (n < nArray2.length && n < nArray.length) {
            int n2 = nArray[n] & ~nArray2[n];
            this.actOnWord(intSetAction, n << 5, n2);
            ++n;
        }
        while (n < nArray.length) {
            this.actOnWord(intSetAction, n << 5, nArray[n]);
            ++n;
        }
    }

    private void actOnWord(IntSetAction intSetAction, int n, int n2) {
        if (n2 != 0) {
            if ((n2 & 1) != 0) {
                intSetAction.act(n);
            }
            int n3 = 0;
            while (n3 < 31) {
                ++n;
                if (((n2 >>>= 1) & 1) != 0) {
                    intSetAction.act(n);
                }
                ++n3;
            }
        }
    }

    public boolean contains(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid i: " + n);
        }
        return this.bitVector.get(n);
    }

    public int max() {
        return this.bitVector.max();
    }

    public String toString() {
        return this.bitVector.toString();
    }

    public int nextSetBit(int n) {
        return this.bitVector.nextSetBit(n);
    }

    public boolean sameValue(IntSet intSet) throws IllegalArgumentException, UnimplementedError {
        if (intSet == null) {
            throw new IllegalArgumentException("that == null");
        }
        if (intSet instanceof BitVectorIntSet) {
            BitVectorIntSet bitVectorIntSet = (BitVectorIntSet)intSet;
            return this.bitVector.sameBits(bitVectorIntSet.bitVector);
        }
        if (intSet instanceof BimodalMutableIntSet) {
            return intSet.sameValue(this);
        }
        if (intSet instanceof SparseIntSet) {
            return this.sameValueInternal((SparseIntSet)intSet);
        }
        if (intSet instanceof MutableSharedBitVectorIntSet) {
            return this.sameValue(((MutableSharedBitVectorIntSet)intSet).makeDenseCopy());
        }
        Assertions.UNREACHABLE("unexpected argument type " + intSet.getClass());
        return false;
    }

    private boolean sameValueInternal(SparseIntSet sparseIntSet) {
        int n = this.populationCount = this.populationCount == -1 ? this.bitVector.populationCount() : this.populationCount;
        if (this.populationCount != sparseIntSet.size()) {
            return false;
        }
        int n2 = 0;
        while (n2 < sparseIntSet.size()) {
            int n3 = sparseIntSet.elementAt(n2);
            if (!this.bitVector.contains(n3)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isSubset(IntSet intSet) {
        if (intSet instanceof BitVectorIntSet) {
            return this.bitVector.isSubset(((BitVectorIntSet)intSet).bitVector);
        }
        if (intSet instanceof SparseIntSet) {
            return this.isSubsetInternal((SparseIntSet)intSet);
        }
        IntIterator intIterator = this.intIterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            if (intSet.contains(n)) continue;
            return false;
        }
        return true;
    }

    private boolean isSubsetInternal(SparseIntSet sparseIntSet) {
        return this.toSparseIntSet().isSubset(sparseIntSet);
    }

    public BitVector getBitVector() {
        return this.bitVector;
    }

    public SparseIntSet toSparseIntSet() {
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
        IntIterator intIterator = this.intIterator();
        while (intIterator.hasNext()) {
            mutableSparseIntSet.add(intIterator.next());
        }
        return mutableSparseIntSet;
    }

    public boolean removeAll(BitVectorIntSet bitVectorIntSet) {
        if (bitVectorIntSet == null) {
            throw new IllegalArgumentException("set is null");
        }
        int n = this.size();
        this.bitVector.andNot(bitVectorIntSet.bitVector);
        this.populationCount = -1;
        return n > this.size();
    }

    public boolean containsAny(IntSet intSet) throws IllegalArgumentException {
        if (intSet == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (intSet instanceof BitVectorIntSet) {
            BitVectorIntSet bitVectorIntSet = (BitVectorIntSet)intSet;
            return !this.bitVector.intersectionEmpty(bitVectorIntSet.bitVector);
        }
        IntIterator intIterator = intSet.intIterator();
        while (intIterator.hasNext()) {
            if (!this.contains(intIterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean addAllInIntersection(IntSet intSet, IntSet intSet2) throws IllegalArgumentException {
        if (intSet == null) {
            throw new IllegalArgumentException("other == null");
        }
        BitVectorIntSet bitVectorIntSet = new BitVectorIntSet(intSet);
        bitVectorIntSet.intersectWith(intSet2);
        return this.addAll(bitVectorIntSet);
    }

    public boolean containsAll(BitVectorIntSet bitVectorIntSet) {
        if (bitVectorIntSet == null) {
            throw new IllegalArgumentException("other is null");
        }
        return bitVectorIntSet.isSubset(this);
    }
}

